// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Subclass for the common case of a partitioning which yields an equality
 *  expression for each segment */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class KeyValuePartitioning extends Partitioning {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public KeyValuePartitioning(Pointer p) { super(p); }

  /** An unconverted equality expression consisting of a field name and the representation
   *  of a scalar value */
  public static class Key extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public Key() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Key(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Key(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public Key position(long position) {
          return (Key)super.position(position);
      }
      @Override public Key getPointer(long i) {
          return new Key((Pointer)this).offsetAddress(i);
      }
  
    public native @StdString String name(); public native Key name(String setter);
    public native @ByRef StringOptional value(); public native Key value(StringOptional setter);
  }

  public native @ByVal PartitionedBatchesResult Partition(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::RecordBatch>"}) RecordBatch batch);

  public native @ByVal ExpressionResult Parse(@StdString String path);
  public native @ByVal ExpressionResult Parse(@StdString BytePointer path);

  public native @ByVal StringResult Format(@Const @ByRef Expression expr);
}
