// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_flight;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.arrow_flight.*;


@Namespace("arrow::flight") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_flight.class)
public class FlightServerOptions extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FlightServerOptions(Pointer p) { super(p); }

  public FlightServerOptions(@Const @ByRef Location location_) { super((Pointer)null); allocate(location_); }
  private native void allocate(@Const @ByRef Location location_);

  /** \brief The host & port (or domain socket path) to listen on.
   *  Use port 0 to bind to an available port. */
  public native @ByRef Location location(); public native FlightServerOptions location(Location setter);
  /** \brief The authentication handler to use. */
  public native @SharedPtr ServerAuthHandler auth_handler(); public native FlightServerOptions auth_handler(ServerAuthHandler setter);
  /** \brief A list of TLS certificate+key pairs to use. */
  public native @StdVector CertKeyPair tls_certificates(); public native FlightServerOptions tls_certificates(CertKeyPair setter);
  /** \brief Enable mTLS and require that the client present a certificate. */
  public native @Cast("bool") boolean verify_client(); public native FlightServerOptions verify_client(boolean setter);
  /** \brief If using mTLS, the PEM-encoded root certificate to use. */
  
  ///
  public native @StdString String root_certificates(); public native FlightServerOptions root_certificates(String setter);
  /** \brief A list of server middleware to apply, along with a key to
   *  identify them by.
   * 
   *  Middleware are always applied in the order provided. Duplicate
   *  keys are an error. */
  
  ///
  public native @ByRef ServerMiddlewareFactoryStringPairVector middleware(); public native FlightServerOptions middleware(ServerMiddlewareFactoryStringPairVector setter);

  /** \brief A Flight implementation-specific callback to customize
   *  transport-specific options.
   * 
   *  Not guaranteed to be called. The type of the parameter is
   *  specific to the Flight implementation. Users should take care to
   *  link to the same transport implementation as Flight to avoid
   *  runtime problems. */
  public native @ByRef @Cast("std::function<void(void*)>*") Pointer builder_hook(); public native FlightServerOptions builder_hook(Pointer setter);
}
