// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


// Abstract page iterator interface. This way, we can feed column pages to the
// ColumnReader through whatever mechanism we choose
@Namespace("parquet") @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class PageReader extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PageReader(Pointer p) { super(p); }


  public static native @UniquePtr PageReader Open(
        @Cast("parquet::ArrowInputStream*") @SharedPtr InputStream stream, @Cast("int64_t") long total_num_rows,
        Compression.type codec, MemoryPool pool/*=arrow::default_memory_pool()*/,
        @Const CryptoContext ctx/*=nullptr*/);
  public static native @UniquePtr PageReader Open(
        @Cast("parquet::ArrowInputStream*") @SharedPtr InputStream stream, @Cast("int64_t") long total_num_rows,
        Compression.type codec);
  public static native @UniquePtr PageReader Open(
        @Cast("parquet::ArrowInputStream*") @SharedPtr InputStream stream, @Cast("int64_t") long total_num_rows,
        @Cast("arrow::Compression::type") int codec, MemoryPool pool/*=arrow::default_memory_pool()*/,
        @Const CryptoContext ctx/*=nullptr*/);
  public static native @UniquePtr PageReader Open(
        @Cast("parquet::ArrowInputStream*") @SharedPtr InputStream stream, @Cast("int64_t") long total_num_rows,
        @Cast("arrow::Compression::type") int codec);

  // @returns: shared_ptr<Page>(nullptr) on EOS, std::shared_ptr<Page>
  // containing new Page otherwise
  public native @SharedPtr Page NextPage();

  public native void set_max_page_header_size(@Cast("uint32_t") int size);
}
