// Targeted by JavaCPP version 1.5.6: DO NOT EDIT THIS FILE

package org.bytedeco.plasma;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.plasma.*;
  // NOLINT

@Namespace("plasma") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.plasma.class)
public class EventLoop extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public EventLoop(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public EventLoop(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public EventLoop position(long position) {
        return (EventLoop)super.position(position);
    }
    @Override public EventLoop getPointer(long i) {
        return new EventLoop((Pointer)this).offsetAddress(i);
    }

  // Signature of the handler that will be called when there is a new event
  // on the file descriptor that this handler has been registered for.
  //
  // The arguments are the event flags (read or write).

  // This handler will be called when a timer times out. The timer id is
  // passed as an argument. The return is the number of milliseconds the timer
  // shall be reset to or kEventLoopTimerDone if the timer shall not be
  // triggered again.

  public EventLoop() { super((Pointer)null); allocate(); }
  private native void allocate();

  /** Add a new file event handler to the event loop.
   * 
   *  @param fd The file descriptor we are listening to.
   *  @param events The flags for events we are listening to (read or write).
   *  @param callback The callback that will be called when the event happens.
   *  @return Returns true if the event handler was added successfully. */
  
  ///
  public native @Cast("bool") boolean AddFileEvent(int fd, int events, @Cast("const plasma::EventLoop::FileCallback*") @ByRef Pointer callback);

  /** Remove a file event handler from the event loop.
   * 
   *  @param fd The file descriptor of the event handler. */
  
  ///
  public native void RemoveFileEvent(int fd);

  /** Register a handler that will be called after a time slice of
   *  "timeout" milliseconds.
   * 
   *  @param timeout The timeout in milliseconds.
   *  @param callback The callback for the timeout.
   *  @return The ID of the newly created timer. */
  
  ///
  public native @Cast("int64_t") long AddTimer(@Cast("int64_t") long timeout, @Cast("const plasma::EventLoop::TimerCallback*") @ByRef Pointer callback);

  /** Remove a timer handler from the event loop.
   * 
   *  @param timer_id The ID of the timer that is to be removed.
   *  @return The ae.c error code. TODO(pcm): needs to be standardized */
  public native int RemoveTimer(@Cast("int64_t") long timer_id);

  /** \brief Run the event loop. */
  public native void Start();

  /** \brief Stop the event loop */
  public native void Stop();

  public native void Shutdown();
}
