// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** Helper that contains information about how to apply a continuation */
@Namespace("arrow::detail") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ContinueFuture extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public ContinueFuture() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ContinueFuture(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ContinueFuture(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public ContinueFuture position(long position) {
        return (ContinueFuture)super.position(position);
    }
    @Override public ContinueFuture getPointer(long i) {
        return new ContinueFuture((Pointer)this).offsetAddress(i);
    }


  // If the callback returns void then we return Future<> that always finishes OK.

  /** If the callback returns a non-future then we return Future<T>
   *  and mark the future finished with the callback result.  It will get promoted
   *  to Result<T> as part of MarkFinished if it isn't already.
   * 
   *  If the callback returns Status and we return Future<> then also send the callback
   *  result as-is to the destination future. */

  /** If the callback returns a Result and the next future is Future<> then we mark
   *  the future finished with the callback result.
   * 
   *  It may seem odd that the next future is Future<> when the callback returns a
   *  result but this can occur if the OnFailure callback returns a result while the
   *  OnSuccess callback is void/Status (e.g. you would get this calling the one-arg
   *  version of Then with an OnSuccess callback that returns void) */

  /** If the callback returns a Future<T> then we return Future<T>.  We create a new
   *  future and add a callback to the future given to us by the user that forwards the
   *  result to the future we just created */

  /** Helpers to conditionally ignore arguments to ContinueFunc */
}
