// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief FileSystem entry info */
@Namespace("arrow::fs") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class FileInfo extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileInfo(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileInfo(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public FileInfo position(long position) {
        return (FileInfo)super.position(position);
    }
    @Override public FileInfo getPointer(long i) {
        return new FileInfo((Pointer)this).offsetAddress(i);
    }

  public FileInfo() { super((Pointer)null); allocate(); }
  private native void allocate();
  public FileInfo(@ByRef(true) FileInfo arg0) { super((Pointer)null); allocate(arg0); }
  private native void allocate(@ByRef(true) FileInfo arg0);
  public native @ByRef @Name("operator =") FileInfo put(@ByRef(true) FileInfo arg0);

  public FileInfo(@StdString String path, FileType type/*=arrow::fs::FileType::Unknown*/) { super((Pointer)null); allocate(path, type); }
  private native void allocate(@StdString String path, FileType type/*=arrow::fs::FileType::Unknown*/);
  public FileInfo(@StdString String path) { super((Pointer)null); allocate(path); }
  private native void allocate(@StdString String path);
  public FileInfo(@StdString BytePointer path, @Cast("arrow::fs::FileType") byte type/*=arrow::fs::FileType::Unknown*/) { super((Pointer)null); allocate(path, type); }
  private native void allocate(@StdString BytePointer path, @Cast("arrow::fs::FileType") byte type/*=arrow::fs::FileType::Unknown*/);
  public FileInfo(@StdString BytePointer path) { super((Pointer)null); allocate(path); }
  private native void allocate(@StdString BytePointer path);

  /** The file type */
  public native FileType type();
  public native void set_type(FileType type);
  public native void set_type(@Cast("arrow::fs::FileType") byte type);

  /** The full file path in the filesystem */
  public native @StdString String path();
  public native void set_path(@StdString String path);
  public native void set_path(@StdString BytePointer path);

  /** The file base name (component after the last directory separator) */
  public native @StdString String base_name();

  // The directory base name (component before the file base name).
  
  ///
  public native @StdString String dir_name();

  /** The size in bytes, if available
   * 
   *  Only regular files are guaranteed to have a size. */
  public native @Cast("int64_t") long size();
  public native void set_size(@Cast("int64_t") long size);

  /** The file extension (excluding the dot) */
  public native @StdString String extension();

  /** The time of last modification, if available */
  public native @ByVal @Cast("arrow::fs::TimePoint*") Pointer mtime();
  public native void set_mtime(@ByVal @Cast("arrow::fs::TimePoint*") Pointer mtime);

  public native @Cast("bool") boolean IsFile();
  public native @Cast("bool") boolean IsDirectory();

  public native @Cast("bool") boolean Equals(@Const @ByRef FileInfo other);

  public native @StdString String ToString();

  /** Function object implementing less-than comparison and hashing by
   *  path, to support sorting infos, using them as keys, and other
   *  interactions with the STL. */
  public static class ByPath extends Pointer {
      static { Loader.load(); }
      /** Default native constructor. */
      public ByPath() { super((Pointer)null); allocate(); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public ByPath(long size) { super((Pointer)null); allocateArray(size); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public ByPath(Pointer p) { super(p); }
      private native void allocate();
      private native void allocateArray(long size);
      @Override public ByPath position(long position) {
          return (ByPath)super.position(position);
      }
      @Override public ByPath getPointer(long i) {
          return new ByPath((Pointer)this).offsetAddress(i);
      }
  
    public native @Cast("bool") @Name("operator ()") boolean apply(@Const @ByRef FileInfo l, @Const @ByRef FileInfo r);

    public native @Cast("size_t") @Name("operator ()") long apply(@Const @ByRef FileInfo i);
  }
}
