// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A mutable central function registry for built-in functions as well
 *  as user-defined functions. Functions are implementations of
 *  arrow::compute::Function.
 * 
 *  Generally, each function contains kernels which are implementations of a
 *  function for a specific argument signature. After looking up a function in
 *  the registry, one can either execute it eagerly with Function::Execute or
 *  use one of the function's dispatch methods to pick a suitable kernel for
 *  lower-level function execution. */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class FunctionRegistry extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FunctionRegistry(Pointer p) { super(p); }


  /** \brief Construct a new registry. Most users only need to use the global
   *  registry */
  public static native @UniquePtr FunctionRegistry Make();

  /** \brief Add a new function to the registry. Returns Status::KeyError if a
   *  function with the same name is already registered */
  public native @ByVal Status AddFunction(@SharedPtr Function function, @Cast("bool") boolean allow_overwrite/*=false*/);
  public native @ByVal Status AddFunction(@SharedPtr Function function);

  /** \brief Add aliases for the given function name. Returns Status::KeyError if the
   *  function with the given name is not registered */
  public native @ByVal Status AddAlias(@StdString String target_name, @StdString String source_name);
  public native @ByVal Status AddAlias(@StdString BytePointer target_name, @StdString BytePointer source_name);

  /** \brief Add a new function options type to the registry. Returns Status::KeyError if
   *  a function options type with the same name is already registered */
  public native @ByVal Status AddFunctionOptionsType(@Const FunctionOptionsType options_type,
                                  @Cast("bool") boolean allow_overwrite/*=false*/);
  public native @ByVal Status AddFunctionOptionsType(@Const FunctionOptionsType options_type);

  /** \brief Retrieve a function by name from the registry */
  public native @ByVal FunctionResult GetFunction(@StdString String name);
  public native @ByVal FunctionResult GetFunction(@StdString BytePointer name);

  /** \brief Return vector of all entry names in the registry. Helpful for
   *  displaying a manifest of available functions */
  public native @ByVal StringVector GetFunctionNames();

  /** \brief Retrieve a function options type by name from the registry */
  public native @ByVal @Cast("arrow::Result<const arrow::compute::FunctionOptionsType*>*") FunctionOptionsTypeResult GetFunctionOptionsType(
        @StdString String name);
  public native @ByVal @Cast("arrow::Result<const arrow::compute::FunctionOptionsType*>*") FunctionOptionsTypeResult GetFunctionOptionsType(
        @StdString BytePointer name);

  /** \brief The number of currently registered functions */
  public native int num_functions();
}
