// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \class MessageDecoderListener
 *  \brief An abstract class to listen events from MessageDecoder.
 * 
 *  This API is EXPERIMENTAL.
 * 
 *  @since 0.17.0 */
@Namespace("arrow::ipc") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class MessageDecoderListener extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MessageDecoderListener(Pointer p) { super(p); }


  /** \brief Called when a message is decoded.
   * 
   *  MessageDecoder calls this method when it decodes a message. This
   *  method is called multiple times when the target stream has
   *  multiple messages.
   * 
   *  @param message [in] a decoded message
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status OnMessageDecoded(@UniquePtr Message message);

  /** \brief Called when the decoder state is changed to
   *  MessageDecoder::State::INITIAL.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status OnInitial();

  /** \brief Called when the decoder state is changed to
   *  MessageDecoder::State::METADATA_LENGTH.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status OnMetadataLength();

  /** \brief Called when the decoder state is changed to
   *  MessageDecoder::State::METADATA.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status OnMetadata();

  /** \brief Called when the decoder state is changed to
   *  MessageDecoder::State::BODY.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status */
  
  ///
  ///
  public native @ByVal Status OnBody();

  /** \brief Called when the decoder state is changed to
   *  MessageDecoder::State::EOS.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status */
  public native @ByVal Status OnEOS();
}
