// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** A task group which serializes asynchronous tasks in a push-based workflow
 * 
 *  Tasks will be executed in the order they are added
 * 
 *  This will buffer results in an unlimited fashion so it should be combined
 *  with some kind of backpressure */
@Namespace("arrow::util") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class SerializedAsyncTaskGroup extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public SerializedAsyncTaskGroup(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public SerializedAsyncTaskGroup(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public SerializedAsyncTaskGroup position(long position) {
        return (SerializedAsyncTaskGroup)super.position(position);
    }
    @Override public SerializedAsyncTaskGroup getPointer(long i) {
        return new SerializedAsyncTaskGroup((Pointer)this).offsetAddress(i);
    }

  
  ///
  ///
  ///
  public SerializedAsyncTaskGroup() { super((Pointer)null); allocate(); }
  private native void allocate();
  /** Push an item into the serializer and (eventually) into the consumer
   * 
   *  The item will not be delivered to the consumer until all previous items have been
   *  consumed.
   * 
   *  If the consumer returns an error then this serializer will go into an error state
   *  and all subsequent pushes will fail with that error.  Pushes that have been queued
   *  but not delivered will be silently dropped.
   * 
   *  @return True if the item was pushed immediately to the consumer, false if it was
   *  queued */
  
  ///
  public native @ByVal Status AddTask(@ByVal @Cast("std::function<arrow::Result<arrow::Future<> >()>*") Pointer task);

  /** Signal that all top level tasks have been added
   * 
   *  The returned future that will finish when all tasks have been consumed. */
  
  ///
  public native @ByVal Future End();

  /** A future that finishes when all queued items have been delivered.
   * 
   *  This will return the same future returned by End but will not signal
   *  that all tasks have been finished.  End must be called at some point in order for
   *  this future to finish. */
  public native @ByVal Future OnFinished();
}
