// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Options for writing a dataset. */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FileSystemDatasetWriteOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public FileSystemDatasetWriteOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FileSystemDatasetWriteOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileSystemDatasetWriteOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FileSystemDatasetWriteOptions position(long position) {
        return (FileSystemDatasetWriteOptions)super.position(position);
    }
    @Override public FileSystemDatasetWriteOptions getPointer(long i) {
        return new FileSystemDatasetWriteOptions((Pointer)this).offsetAddress(i);
    }

  /** Options for individual fragment writing. */
  public native @SharedPtr FileWriteOptions file_write_options(); public native FileSystemDatasetWriteOptions file_write_options(FileWriteOptions setter);

  /** FileSystem into which a dataset will be written. */
  public native @SharedPtr FileSystem filesystem(); public native FileSystemDatasetWriteOptions filesystem(FileSystem setter);

  /** Root directory into which the dataset will be written. */
  public native @StdString String base_dir(); public native FileSystemDatasetWriteOptions base_dir(String setter);

  /** Partitioning used to generate fragment paths. */
  public native @SharedPtr Partitioning partitioning(); public native FileSystemDatasetWriteOptions partitioning(Partitioning setter);

  /** Maximum number of partitions any batch may be written into, default is 1K. */
  public native int max_partitions(); public native FileSystemDatasetWriteOptions max_partitions(int setter);

  /** Template string used to generate fragment basenames.
   *  {i} will be replaced by an auto incremented integer. */
  public native @StdString String basename_template(); public native FileSystemDatasetWriteOptions basename_template(String setter);

  /** If greater than 0 then this will limit the maximum number of files that can be left
   *  open. If an attempt is made to open too many files then the least recently used file
   *  will be closed.  If this setting is set too low you may end up fragmenting your data
   *  into many small files. */
  public native @Cast("uint32_t") int max_open_files(); public native FileSystemDatasetWriteOptions max_open_files(int setter);

  /** If greater than 0 then this will limit how many rows are placed in any single file.
   *  Otherwise there will be no limit and one file will be created in each output
   *  directory unless files need to be closed to respect max_open_files */
  public native @Cast("uint64_t") long max_rows_per_file(); public native FileSystemDatasetWriteOptions max_rows_per_file(long setter);

  /** Controls what happens if an output directory already exists. */
  public native ExistingDataBehavior existing_data_behavior(); public native FileSystemDatasetWriteOptions existing_data_behavior(ExistingDataBehavior setter);

  /** Callback to be invoked against all FileWriters before
   *  they are finalized with FileWriter::Finish(). */
  public native @ByRef FileWriterVisitor writer_pre_finish(); public native FileSystemDatasetWriteOptions writer_pre_finish(FileWriterVisitor setter);

  /** Callback to be invoked against all FileWriters after they have
   *  called FileWriter::Finish(). */
  public native @ByRef FileWriterVisitor writer_post_finish(); public native FileSystemDatasetWriteOptions writer_post_finish(FileWriterVisitor setter);

  public native @SharedPtr FileFormat format();
}
