// Targeted by JavaCPP version 1.5.7: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


/** \brief RowGroupMetaData is a proxy around format::RowGroupMetaData. */
@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class RowGroupMetaData extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RowGroupMetaData(Pointer p) { super(p); }

  /** \brief Create a RowGroupMetaData from a serialized thrift message. */
  public static native @UniquePtr RowGroupMetaData Make(
        @Const Pointer metadata, @Const SchemaDescriptor schema,
        @Const ApplicationVersion writer_version/*=nullptr*/,
        @SharedPtr InternalFileDecryptor file_decryptor/*=nullptr*/);
  public static native @UniquePtr RowGroupMetaData Make(
        @Const Pointer metadata, @Const SchemaDescriptor schema);

  public native @Cast("bool") boolean Equals(@Const @ByRef RowGroupMetaData other);

  /** \brief The number of columns in this row group. The order must match the
   *  parent's column ordering. */
  
  ///
  ///
  ///
  public native int num_columns();

  /** \brief Return the ColumnChunkMetaData of the corresponding column ordinal.
   * 
   *  WARNING, the returned object references memory location in it's parent
   *  (RowGroupMetaData) object. Hence, the parent must outlive the returned
   *  object.
   * 
   *  @param index [in] of the ColumnChunkMetaData to retrieve.
   * 
   *  @throws ParquetException if the index is out of bound. */
  public native @UniquePtr ColumnChunkMetaData ColumnChunk(int index);

  /** \brief Number of rows in this row group. */
  public native @Cast("int64_t") long num_rows();

  /** \brief Total byte size of all the uncompressed column data in this row group. */
  
  ///
  public native @Cast("int64_t") long total_byte_size();

  /** \brief Total byte size of all the compressed (and potentially encrypted)
   *  column data in this row group.
   * 
   *  This information is optional and may be 0 if omitted. */
  
  ///
  public native @Cast("int64_t") long total_compressed_size();

  /** \brief Byte offset from beginning of file to first page (data or
   *  dictionary) in this row group
   * 
   *  The file_offset field that this method exposes is optional. This method
   *  will return 0 if that field is not set to a meaningful value. */
  public native @Cast("int64_t") long file_offset();
  // Return const-pointer to make it clear that this object is not to be copied
  public native @Const SchemaDescriptor schema();
  // Indicate if all of the RowGroup's ColumnChunks can be decompressed.
  public native @Cast("bool") boolean can_decompress();
}
