// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Common kernel base data structure for ScalarKernel and
 *  VectorKernel. It is called "ArrayKernel" in that the functions generally
 *  output array values (as opposed to scalar values in the case of aggregate
 *  functions). */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ArrayKernel extends Kernel {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ArrayKernel(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ArrayKernel(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ArrayKernel position(long position) {
        return (ArrayKernel)super.position(position);
    }
    @Override public ArrayKernel getPointer(long i) {
        return new ArrayKernel((Pointer)this).offsetAddress(i);
    }

  public ArrayKernel() { super((Pointer)null); allocate(); }
  private native void allocate();

  public ArrayKernel(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec,
                @ByVal(nullValue = "arrow::compute::KernelInit(nullptr)") @Cast("arrow::compute::KernelInit*") Pointer init) { super((Pointer)null); allocate(sig, exec, init); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec,
                @ByVal(nullValue = "arrow::compute::KernelInit(nullptr)") @Cast("arrow::compute::KernelInit*") Pointer init);
  public ArrayKernel(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec) { super((Pointer)null); allocate(sig, exec); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::compute::KernelSignature>"}) KernelSignature sig, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec);

  public ArrayKernel(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec,
                @ByVal(nullValue = "arrow::compute::KernelInit(nullptr)") @Cast("arrow::compute::KernelInit*") Pointer init) { super((Pointer)null); allocate(in_types, out_type, exec, init); }
  private native void allocate(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec,
                @ByVal(nullValue = "arrow::compute::KernelInit(nullptr)") @Cast("arrow::compute::KernelInit*") Pointer init);
  public ArrayKernel(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec) { super((Pointer)null); allocate(in_types, out_type, exec); }
  private native void allocate(@StdVector InputType in_types, @ByVal OutputType out_type, @ByVal @Cast("arrow::compute::ArrayKernelExec*") Pointer exec);

  /** \brief Perform a single invocation of this kernel. Depending on the
   *  implementation, it may only write into preallocated memory, while in some
   *  cases it will allocate its own memory. Any required state is managed
   *  through the KernelContext. */
  public native @ByRef @Cast("arrow::compute::ArrayKernelExec*") Pointer exec(); public native ArrayKernel exec(Pointer setter);

  /** \brief Writing execution results into larger contiguous allocations
   *  requires that the kernel be able to write into sliced output ArrayData*,
   *  including sliced output validity bitmaps. Some kernel implementations may
   *  not be able to do this, so setting this to false disables this
   *  functionality. */
  public native @Cast("bool") boolean can_write_into_slices(); public native ArrayKernel can_write_into_slices(boolean setter);
}
