// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** Used to control timestamp timezone conversion and handling ambiguous/nonexistent
 *  times. */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class AssumeTimezoneOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AssumeTimezoneOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AssumeTimezoneOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public AssumeTimezoneOptions position(long position) {
        return (AssumeTimezoneOptions)super.position(position);
    }
    @Override public AssumeTimezoneOptions getPointer(long i) {
        return new AssumeTimezoneOptions((Pointer)this).offsetAddress(i);
    }

  /** \brief How to interpret ambiguous local times that can be interpreted as
   *  multiple instants (normally two) due to DST shifts.
   * 
   *  AMBIGUOUS_EARLIEST emits the earliest instant amongst possible interpretations.
   *  AMBIGUOUS_LATEST emits the latest instant amongst possible interpretations. */
  public enum Ambiguous { AMBIGUOUS_RAISE(0), AMBIGUOUS_EARLIEST(1), AMBIGUOUS_LATEST(2);

      public final int value;
      private Ambiguous(int v) { this.value = v; }
      private Ambiguous(Ambiguous e) { this.value = e.value; }
      public Ambiguous intern() { for (Ambiguous e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  /** \brief How to handle local times that do not exist due to DST shifts.
   * 
   *  NONEXISTENT_EARLIEST emits the instant "just before" the DST shift instant
   *  in the given timestamp precision (for example, for a nanoseconds precision
   *  timestamp, this is one nanosecond before the DST shift instant).
   *  NONEXISTENT_LATEST emits the DST shift instant. */
  public enum Nonexistent { NONEXISTENT_RAISE(0), NONEXISTENT_EARLIEST(1), NONEXISTENT_LATEST(2);

      public final int value;
      private Nonexistent(int v) { this.value = v; }
      private Nonexistent(Nonexistent e) { this.value = e.value; }
      public Nonexistent intern() { for (Nonexistent e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }

  public AssumeTimezoneOptions(@StdString String timezone,
                                   Ambiguous ambiguous/*=arrow::compute::AssumeTimezoneOptions::AMBIGUOUS_RAISE*/,
                                   Nonexistent nonexistent/*=arrow::compute::AssumeTimezoneOptions::NONEXISTENT_RAISE*/) { super((Pointer)null); allocate(timezone, ambiguous, nonexistent); }
  private native void allocate(@StdString String timezone,
                                   Ambiguous ambiguous/*=arrow::compute::AssumeTimezoneOptions::AMBIGUOUS_RAISE*/,
                                   Nonexistent nonexistent/*=arrow::compute::AssumeTimezoneOptions::NONEXISTENT_RAISE*/);
  public AssumeTimezoneOptions(@StdString String timezone) { super((Pointer)null); allocate(timezone); }
  private native void allocate(@StdString String timezone);
  public AssumeTimezoneOptions(@StdString BytePointer timezone,
                                   @Cast("arrow::compute::AssumeTimezoneOptions::Ambiguous") int ambiguous/*=arrow::compute::AssumeTimezoneOptions::AMBIGUOUS_RAISE*/,
                                   @Cast("arrow::compute::AssumeTimezoneOptions::Nonexistent") int nonexistent/*=arrow::compute::AssumeTimezoneOptions::NONEXISTENT_RAISE*/) { super((Pointer)null); allocate(timezone, ambiguous, nonexistent); }
  private native void allocate(@StdString BytePointer timezone,
                                   @Cast("arrow::compute::AssumeTimezoneOptions::Ambiguous") int ambiguous/*=arrow::compute::AssumeTimezoneOptions::AMBIGUOUS_RAISE*/,
                                   @Cast("arrow::compute::AssumeTimezoneOptions::Nonexistent") int nonexistent/*=arrow::compute::AssumeTimezoneOptions::NONEXISTENT_RAISE*/);
  public AssumeTimezoneOptions(@StdString BytePointer timezone) { super((Pointer)null); allocate(timezone); }
  private native void allocate(@StdString BytePointer timezone);
  public AssumeTimezoneOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();

  /** Timezone to convert timestamps from */
  public native @StdString String timezone(); public native AssumeTimezoneOptions timezone(String setter);

  /** How to interpret ambiguous local times (due to DST shifts) */
  public native Ambiguous ambiguous(); public native AssumeTimezoneOptions ambiguous(Ambiguous setter);
  /** How to interpret non-existent local times (due to DST shifts) */
  public native Nonexistent nonexistent(); public native AssumeTimezoneOptions nonexistent(Nonexistent setter);
}
