// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class AsyncToggle extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public AsyncToggle() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public AsyncToggle(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public AsyncToggle(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public AsyncToggle position(long position) {
        return (AsyncToggle)super.position(position);
    }
    @Override public AsyncToggle getPointer(long i) {
        return new AsyncToggle((Pointer)this).offsetAddress(i);
    }

  /** Get a future that will complete when the toggle next becomes open
   * 
   *  If the toggle is open this returns immediately
   *  If the toggle is closed this future will be unfinished until the next call to Open */
  
  ///
  public native @ByVal Future WhenOpen();
  /** \brief Close the toggle
   * 
   *  After this call any call to WhenOpen will be delayed until the next open */
  
  ///
  ///
  ///
  public native void Close();
  /** \brief Open the toggle
   * 
   *  Note: This call may complete a future, triggering any callbacks, and generally
   *  should not be done while holding any locks.
   * 
   *  Note: If Open is called from multiple threads it could lead to a situation where
   *  callbacks from the second open finish before callbacks on the first open.
   * 
   *  All current waiters will be released to enter, even if another close call
   *  quickly follows */
  public native void Open();

  /** \brief Return true if the toggle is currently open */
  public native @Cast("bool") boolean IsOpen();
}
