// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Options to control backpressure behavior */
@Namespace("arrow::util") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class BackpressureOptions extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public BackpressureOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public BackpressureOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public BackpressureOptions position(long position) {
        return (BackpressureOptions)super.position(position);
    }
    @Override public BackpressureOptions getPointer(long i) {
        return new BackpressureOptions((Pointer)this).offsetAddress(i);
    }

  /** \brief Create default options that perform no backpressure */
  
  ///
  public BackpressureOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  /** \brief Create options that will perform backpressure
   * 
   *  @param toggle A toggle to be shared between the producer and consumer
   *  @param resume_if_below The producer should resume producing if the backpressure
   *                         queue has fewer than resume_if_below items.
   *  @param pause_if_above The producer should pause producing if the backpressure
   *                        queue has more than pause_if_above items */
  public BackpressureOptions(@SharedPtr AsyncToggle toggle, @Cast("uint32_t") int resume_if_below,
                        @Cast("uint32_t") int pause_if_above) { super((Pointer)null); allocate(toggle, resume_if_below, pause_if_above); }
  private native void allocate(@SharedPtr AsyncToggle toggle, @Cast("uint32_t") int resume_if_below,
                        @Cast("uint32_t") int pause_if_above);

  public static native @ByVal BackpressureOptions Make(@Cast("uint32_t") int resume_if_below/*=32*/,
                                    @Cast("uint32_t") int pause_if_above/*=64*/);
  public static native @ByVal BackpressureOptions Make();

  public static native @ByVal BackpressureOptions NoBackpressure();

  public native @SharedPtr AsyncToggle toggle(); public native BackpressureOptions toggle(AsyncToggle setter);
  public native @Cast("uint32_t") int resume_if_below(); public native BackpressureOptions resume_if_below(int setter);
  public native @Cast("uint32_t") int pause_if_above(); public native BackpressureOptions pause_if_above(int setter);
}
