// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \addtogroup compute-concrete-options
 *  \{ */

@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class CastOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public CastOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public CastOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public CastOptions position(long position) {
        return (CastOptions)super.position(position);
    }
    @Override public CastOptions getPointer(long i) {
        return new CastOptions((Pointer)this).offsetAddress(i);
    }

  public CastOptions(@Cast("bool") boolean safe/*=true*/) { super((Pointer)null); allocate(safe); }
  private native void allocate(@Cast("bool") boolean safe/*=true*/);
  public CastOptions() { super((Pointer)null); allocate(); }
  private native void allocate();

  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();
  public static native @ByVal CastOptions Safe(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type/*=nullptr*/);
  public static native @ByVal CastOptions Safe();

  public static native @ByVal CastOptions Unsafe(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type/*=nullptr*/);
  public static native @ByVal CastOptions Unsafe();

  // Type being casted to. May be passed separate to eager function
  // compute::Cast
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType to_type(); public native CastOptions to_type(DataType setter);

  public native @Cast("bool") boolean allow_int_overflow(); public native CastOptions allow_int_overflow(boolean setter);
  public native @Cast("bool") boolean allow_time_truncate(); public native CastOptions allow_time_truncate(boolean setter);
  public native @Cast("bool") boolean allow_time_overflow(); public native CastOptions allow_time_overflow(boolean setter);
  public native @Cast("bool") boolean allow_decimal_truncate(); public native CastOptions allow_decimal_truncate(boolean setter);
  public native @Cast("bool") boolean allow_float_truncate(); public native CastOptions allow_float_truncate(boolean setter);
  // Indicate if conversions from Binary/FixedSizeBinary to string must
  // validate the utf8 payload.
  public native @Cast("bool") boolean allow_invalid_utf8(); public native CastOptions allow_invalid_utf8(boolean setter);
}
