// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Compression codec */
@Namespace("arrow::util") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Codec extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Codec(Pointer p) { super(p); }


  /** \brief Return special value to indicate that a codec implementation
   *  should use its default compression level */
  public static native int UseDefaultCompressionLevel();

  /** \brief Return a string name for compression type */
  public static native @StdString String GetCodecAsString(Compression.type t);
  public static native @StdString BytePointer GetCodecAsString(@Cast("arrow::Compression::type") int t);

  /** \brief Return compression type for name (all upper case) */
  public static native @ByVal CompressionTypeResult GetCompressionType(@StdString String name);
  public static native @ByVal CompressionTypeResult GetCompressionType(@StdString BytePointer name);

  /** \brief Create a codec for the given compression algorithm */
  public static native @ByVal CodecResult Create(
        Compression.type codec, int compression_level/*=arrow::util::kUseDefaultCompressionLevel*/);
  public static native @ByVal CodecResult Create(
        Compression.type codec);
  public static native @ByVal CodecResult Create(
        @Cast("arrow::Compression::type") int codec, int compression_level/*=arrow::util::kUseDefaultCompressionLevel*/);
  public static native @ByVal CodecResult Create(
        @Cast("arrow::Compression::type") int codec);

  /** \brief Return true if support for indicated codec has been enabled */
  public static native @Cast("bool") boolean IsAvailable(Compression.type codec);
  public static native @Cast("bool") boolean IsAvailable(@Cast("arrow::Compression::type") int codec);

  /** \brief Return true if indicated codec supports setting a compression level */
  public static native @Cast("bool") boolean SupportsCompressionLevel(Compression.type codec);
  public static native @Cast("bool") boolean SupportsCompressionLevel(@Cast("arrow::Compression::type") int codec);

  /** \brief Return the smallest supported compression level for the codec
   *  Note: This function creates a temporary Codec instance */
  public static native @ByVal IntResult MinimumCompressionLevel(Compression.type codec);
  public static native @ByVal IntResult MinimumCompressionLevel(@Cast("arrow::Compression::type") int codec);

  /** \brief Return the largest supported compression level for the codec
   *  Note: This function creates a temporary Codec instance */
  public static native @ByVal IntResult MaximumCompressionLevel(Compression.type codec);
  public static native @ByVal IntResult MaximumCompressionLevel(@Cast("arrow::Compression::type") int codec);

  /** \brief Return the default compression level
   *  Note: This function creates a temporary Codec instance */
  public static native @ByVal IntResult DefaultCompressionLevel(Compression.type codec);
  public static native @ByVal IntResult DefaultCompressionLevel(@Cast("arrow::Compression::type") int codec);

  /** \brief Return the smallest supported compression level */
  public native int minimum_compression_level();

  /** \brief Return the largest supported compression level */
  public native int maximum_compression_level();

  /** \brief Return the default compression level */
  
  ///
  ///
  public native int default_compression_level();

  /** \brief One-shot decompression function
   * 
   *  output_buffer_len must be correct and therefore be obtained in advance.
   *  The actual decompressed length is returned.
   * 
   *  \note One-shot decompression is not always compatible with streaming
   *  compression.  Depending on the codec (e.g. LZ4), different formats may
   *  be used. */
  
  ///
  ///
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") BytePointer output_buffer);
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") ByteBuffer output_buffer);
  public native @ByVal LongResult Decompress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                       @Cast("int64_t") long output_buffer_len,
                                       @Cast("uint8_t*") byte[] output_buffer);

  /** \brief One-shot compression function
   * 
   *  output_buffer_len must first have been computed using MaxCompressedLen().
   *  The actual compressed length is returned.
   * 
   *  \note One-shot compression is not always compatible with streaming
   *  decompression.  Depending on the codec (e.g. LZ4), different formats may
   *  be used. */
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") BytePointer output_buffer);
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") ByteBuffer output_buffer);
  public native @ByVal LongResult Compress(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input,
                                     @Cast("int64_t") long output_buffer_len, @Cast("uint8_t*") byte[] output_buffer);

  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") BytePointer input);
  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") ByteBuffer input);
  public native @Cast("int64_t") long MaxCompressedLen(@Cast("int64_t") long input_len, @Cast("const uint8_t*") byte[] input);

  /** \brief Create a streaming compressor instance */
  public native @ByVal CompressorResult MakeCompressor();

  /** \brief Create a streaming compressor instance */
  public native @ByVal DecompressorResult MakeDecompressor();

  /** \brief This Codec's compression type */
  public native Compression.type compression_type();

  /** \brief The name of this Codec's compression type */
  public native @StdString String name();

  /** \brief This Codec's compression level, if applicable */
  public native int compression_level();
}
