// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Helper class for incremental dictionary unification */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class DictionaryUnifier extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public DictionaryUnifier(Pointer p) { super(p); }


  /** \brief Construct a DictionaryUnifier
   *  @param value_type [in] the data type of the dictionaries
   *  @param pool [in] MemoryPool to use for memory allocations */
  
  ///
  ///
  public static native @ByVal DictionaryUnifierResult Make(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type, MemoryPool pool/*=arrow::default_memory_pool()*/);
  public static native @ByVal DictionaryUnifierResult Make(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType value_type);

  /** \brief Unify dictionaries accross array chunks
   * 
   *  The dictionaries in the array chunks will be unified, their indices
   *  accordingly transposed.
   * 
   *  Only dictionaries with a primitive value type are currently supported.
   *  However, dictionaries nested inside a more complex type are correctly unified. */
  
  ///
  ///
  public static native @ByVal ChunkedArrayResult UnifyChunkedArray(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray array,
        MemoryPool pool/*=arrow::default_memory_pool()*/);
  public static native @ByVal ChunkedArrayResult UnifyChunkedArray(
        @SharedPtr @Cast({"", "std::shared_ptr<arrow::ChunkedArray>"}) ChunkedArray array);

  /** \brief Unify dictionaries accross the chunks of each table column
   * 
   *  The dictionaries in each table column will be unified, their indices
   *  accordingly transposed.
   * 
   *  Only dictionaries with a primitive value type are currently supported.
   *  However, dictionaries nested inside a more complex type are correctly unified. */
  public static native @ByVal TableResult UnifyTable(
        @Const @ByRef Table table, MemoryPool pool/*=arrow::default_memory_pool()*/);
  public static native @ByVal TableResult UnifyTable(
        @Const @ByRef Table table);

  /** \brief Append dictionary to the internal memo */
  public native @ByVal Status Unify(@Const @ByRef Array dictionary);

  /** \brief Append dictionary and compute transpose indices
   *  @param dictionary [in] the dictionary values to unify
   *  @param out_transpose [out] a Buffer containing computed transpose indices
   *  as int32_t values equal in length to the passed dictionary. The value in
   *  each slot corresponds to the new index value for each original index
   *  for a DictionaryArray with the old dictionary */
  public native @ByVal Status Unify(@Const @ByRef Array dictionary,
                         @SharedPtr @Cast({"", "std::shared_ptr<arrow::Buffer>*"}) ArrowBuffer out_transpose);

  /** \brief Return a result DictionaryType with the smallest possible index
   *  type to accommodate the unified dictionary. The unifier cannot be used
   *  after this is called */
  public native @ByVal Status GetResult(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>*"}) DataType out_type,
                             @SharedPtr Array out_dict);

  /** \brief Return a unified dictionary with the given index type.  If
   *  the index type is not large enough then an invalid status will be returned.
   *  The unifier cannot be used after this is called */
  public native @ByVal Status GetResultWithIndexType(@SharedPtr @Cast({"", "std::shared_ptr<arrow::DataType>"}) DataType index_type,
                                          @SharedPtr Array out_dict);
}
