// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A general listener class to receive events.
 * 
 *  You must implement callback methods for interested events.
 * 
 *  This API is EXPERIMENTAL.
 * 
 *  @since 0.17.0 */
@Namespace("arrow::ipc") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class Listener extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public Listener() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public Listener(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public Listener(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public Listener position(long position) {
        return (Listener)super.position(position);
    }
    @Override public Listener getPointer(long i) {
        return new Listener((Pointer)this).offsetAddress(i);
    }


  /** \brief Called when end-of-stream is received.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @return Status
   * 
   *  @see StreamDecoder */
  
  ///
  ///
  ///
  public native @ByVal Status OnEOS();

  /** \brief Called when a record batch is decoded.
   * 
   *  The default implementation just returns
   *  arrow::Status::NotImplemented().
   * 
   *  @param record_batch [in] a record batch decoded
   *  @return Status
   * 
   *  @see StreamDecoder */
  
  ///
  ///
  ///
  public native @ByVal Status OnRecordBatchDecoded(@SharedPtr @Cast({"", "std::shared_ptr<arrow::RecordBatch>"}) RecordBatch record_batch);

  /** \brief Called when a schema is decoded.
   * 
   *  The default implementation just returns arrow::Status::OK().
   * 
   *  @param schema [in] a schema decoded
   *  @return Status
   * 
   *  @see StreamDecoder */
  public native @ByVal Status OnSchemaDecoded(@SharedPtr @ByVal Schema schema);
}
