// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;
  // namespace internal

/** Base class for memory allocation on the CPU.
 * 
 *  Besides tracking the number of allocated bytes, the allocator also should
 *  take care of the required 64-byte alignment. */
@Namespace("arrow") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class MemoryPool extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public MemoryPool(Pointer p) { super(p); }


  /** \brief EXPERIMENTAL. Create a new instance of the default MemoryPool */
  
  ///
  public static native @UniquePtr MemoryPool CreateDefault();

  /** Allocate a new memory region of at least size bytes.
   * 
   *  The allocated region shall be 64-byte aligned. */
  
  ///
  public native @ByVal Status Allocate(@Cast("int64_t") long size, @Cast("uint8_t**") PointerPointer out);
  public native @ByVal Status Allocate(@Cast("int64_t") long size, @Cast("uint8_t**") @ByPtrPtr BytePointer out);
  public native @ByVal Status Allocate(@Cast("int64_t") long size, @Cast("uint8_t**") @ByPtrPtr ByteBuffer out);
  public native @ByVal Status Allocate(@Cast("int64_t") long size, @Cast("uint8_t**") @ByPtrPtr byte[] out);

  /** Resize an already allocated memory section.
   * 
   *  As by default most default allocators on a platform don't support aligned
   *  reallocation, this function can involve a copy of the underlying data. */
  
  ///
  public native @ByVal Status Reallocate(@Cast("int64_t") long old_size, @Cast("int64_t") long new_size, @Cast("uint8_t**") PointerPointer ptr);
  public native @ByVal Status Reallocate(@Cast("int64_t") long old_size, @Cast("int64_t") long new_size, @Cast("uint8_t**") @ByPtrPtr BytePointer ptr);
  public native @ByVal Status Reallocate(@Cast("int64_t") long old_size, @Cast("int64_t") long new_size, @Cast("uint8_t**") @ByPtrPtr ByteBuffer ptr);
  public native @ByVal Status Reallocate(@Cast("int64_t") long old_size, @Cast("int64_t") long new_size, @Cast("uint8_t**") @ByPtrPtr byte[] ptr);

  /** Free an allocated region.
   * 
   *  @param buffer Pointer to the start of the allocated memory region
   *  @param size Allocated size located at buffer. An allocator implementation
   *    may use this for tracking the amount of allocated bytes as well as for
   *    faster deallocation if supported by its backend. */
  
  ///
  public native void Free(@Cast("uint8_t*") BytePointer buffer, @Cast("int64_t") long size);
  public native void Free(@Cast("uint8_t*") ByteBuffer buffer, @Cast("int64_t") long size);
  public native void Free(@Cast("uint8_t*") byte[] buffer, @Cast("int64_t") long size);

  /** Return unused memory to the OS
   * 
   *  Only applies to allocators that hold onto unused memory.  This will be
   *  best effort, a memory pool may not implement this feature or may be
   *  unable to fulfill the request due to fragmentation. */
  public native void ReleaseUnused();

  /** The number of bytes that were allocated and not yet free'd through
   *  this allocator. */
  
  ///
  public native @Cast("int64_t") long bytes_allocated();

  /** Return peak memory allocation in this memory pool
   * 
   *  @return Maximum bytes allocated. If not known (or not implemented),
   *  returns -1 */
  public native @Cast("int64_t") long max_memory();

  /** The name of the backend used by this MemoryPool (e.g. "system" or "jemalloc"). */
  public native @StdString String backend_name();
}
