// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A read cache designed to hide IO latencies when reading.
 * 
 *  This class takes multiple byte ranges that an application expects to read, and
 *  coalesces them into fewer, larger read requests, which benefits performance on some
 *  filesystems, particularly remote ones like Amazon S3. By default, it also issues
 *  these read requests in parallel up front.
 * 
 *  To use:
 *  1. Cache() the ranges you expect to read in the future. Ideally, these ranges have
 *     the exact offset and length that will later be read. The cache will combine those
 *     ranges according to parameters (see constructor).
 * 
 *     By default, the cache will also start fetching the combined ranges in parallel in
 *     the background, unless CacheOptions.lazy is set.
 * 
 *  2. Call WaitFor() to be notified when the given ranges have been read. If
 *     CacheOptions.lazy is set, I/O will be triggered in the background here instead.
 *     This can be done in parallel (e.g. if parsing a file, call WaitFor() for each
 *     chunk of the file that can be parsed in parallel).
 * 
 *  3. Call Read() to retrieve the actual data for the given ranges.
 *     A synchronous application may skip WaitFor() and just call Read() - it will still
 *     benefit from coalescing and parallel fetching. */
@Namespace("arrow::io::internal") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class ReadRangeCache extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ReadRangeCache(Pointer p) { super(p); }

  @MemberGetter public static native @Cast("const int64_t") long kDefaultHoleSizeLimit();
  public static final long kDefaultHoleSizeLimit = kDefaultHoleSizeLimit();
  @MemberGetter public static native @Cast("const int64_t") long kDefaultRangeSizeLimit();
  public static final long kDefaultRangeSizeLimit = kDefaultRangeSizeLimit();

  /** Construct a read cache with default */
  public ReadRangeCache(@SharedPtr RandomAccessFile file, @ByVal IOContext ctx) { super((Pointer)null); allocate(file, ctx); }
  private native void allocate(@SharedPtr RandomAccessFile file, @ByVal IOContext ctx);

  /** Construct a read cache with given options */
  public ReadRangeCache(@SharedPtr RandomAccessFile file, @ByVal IOContext ctx,
                            @ByVal CacheOptions options) { super((Pointer)null); allocate(file, ctx, options); }
  private native void allocate(@SharedPtr RandomAccessFile file, @ByVal IOContext ctx,
                            @ByVal CacheOptions options);

  /** \brief Cache the given ranges in the background.
   * 
   *  The caller must ensure that the ranges do not overlap with each other,
   *  nor with previously cached ranges.  Otherwise, behaviour will be undefined. */
  public native @ByVal Status Cache(@StdVector ReadRange ranges);

  /** \brief Read a range previously given to Cache(). */
  public native @ByVal BufferResult Read(@ByVal ReadRange range);

  /** \brief Wait until all ranges added so far have been cached. */
  public native @ByVal Future Wait();

  /** \brief Wait until all given ranges have been cached. */
  public native @ByVal Future WaitFor(@StdVector ReadRange ranges);
}
