// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class RoundToMultipleOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public RoundToMultipleOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public RoundToMultipleOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public RoundToMultipleOptions position(long position) {
        return (RoundToMultipleOptions)super.position(position);
    }
    @Override public RoundToMultipleOptions getPointer(long i) {
        return new RoundToMultipleOptions((Pointer)this).offsetAddress(i);
    }

  public RoundToMultipleOptions(double multiple/*=1.0*/,
                                    RoundMode round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/) { super((Pointer)null); allocate(multiple, round_mode); }
  private native void allocate(double multiple/*=1.0*/,
                                    RoundMode round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/);
  public RoundToMultipleOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  public RoundToMultipleOptions(double multiple/*=1.0*/,
                                    @Cast("arrow::compute::RoundMode") byte round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/) { super((Pointer)null); allocate(multiple, round_mode); }
  private native void allocate(double multiple/*=1.0*/,
                                    @Cast("arrow::compute::RoundMode") byte round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/);
  public RoundToMultipleOptions(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple,
                                    RoundMode round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/) { super((Pointer)null); allocate(multiple, round_mode); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple,
                                    RoundMode round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/);
  public RoundToMultipleOptions(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple) { super((Pointer)null); allocate(multiple); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple);
  public RoundToMultipleOptions(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple,
                                    @Cast("arrow::compute::RoundMode") byte round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/) { super((Pointer)null); allocate(multiple, round_mode); }
  private native void allocate(@SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple,
                                    @Cast("arrow::compute::RoundMode") byte round_mode/*=arrow::compute::RoundMode::HALF_TO_EVEN*/);
  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();
  
  ///
  public static native @ByVal RoundToMultipleOptions Defaults();
  /** Rounding scale (multiple to round to).
   * 
   *  Should be a scalar of a type compatible with the argument to be rounded.
   *  For example, rounding a decimal value means a decimal multiple is
   *  required. Rounding a floating point or integer value means a floating
   *  point scalar is required. */
  public native @SharedPtr @Cast({"", "std::shared_ptr<arrow::Scalar>"}) Scalar multiple(); public native RoundToMultipleOptions multiple(Scalar setter);
  /** Rounding and tie-breaking mode */
  public native RoundMode round_mode(); public native RoundToMultipleOptions round_mode(RoundMode setter);
}
