// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief A class that reads a CSV file incrementally
 * 
 *  Caveats:
 *  - For now, this is always single-threaded (regardless of {@code ReadOptions::use_threads}.
 *  - Type inference is done on the first block and types are frozen afterwards;
 *    to make sure the right data types are inferred, either set
 *    {@code ReadOptions::block_size} to a large enough value, or use
 *    {@code ConvertOptions::column_types} to set the desired data types explicitly. */
@Namespace("arrow::csv") @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class StreamingReader extends RecordBatchReader {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public StreamingReader(Pointer p) { super(p); }


  
  ///
  ///
  public native @ByVal RecordBatchFuture ReadNextAsync();

  /** \brief Return the number of bytes which have been read and processed
   * 
   *  The returned number includes CSV bytes which the StreamingReader has
   *  finished processing, but not bytes for which some processing (e.g.
   *  CSV parsing or conversion to Arrow layout) is still ongoing.
   * 
   *  Furthermore, the following rules apply:
   *  - bytes skipped by {@code ReadOptions.skip_rows} are counted as being read before
   *  any records are returned.
   *  - bytes read while parsing the header are counted as being read before any
   *  records are returned.
   *  - bytes skipped by {@code ReadOptions.skip_rows_after_names} are counted after the
   *  first batch is returned. */
  
  ///
  ///
  public native @Cast("int64_t") long bytes_read();

  /** Create a StreamingReader instance
   * 
   *  This involves some I/O as the first batch must be loaded during the creation process
   *  so it is returned as a future
   * 
   *  Currently, the StreamingReader is not async-reentrant and does not do any fan-out
   *  parsing (see ARROW-11889) */
  public static native @ByVal StreamingReaderFuture MakeAsync(
        @ByVal IOContext io_context, @SharedPtr @Cast({"", "std::shared_ptr<arrow::io::InputStream>"}) InputStream input,
        Executor cpu_executor, @Const @ByRef ReadOptions arg3, @Const @ByRef CsvParseOptions arg4,
        @Const @ByRef ConvertOptions arg5);

  public static native @ByVal StreamingReaderResult Make(
        @ByVal IOContext io_context, @SharedPtr @Cast({"", "std::shared_ptr<arrow::io::InputStream>"}) InputStream input,
        @Const @ByRef ReadOptions arg2, @Const @ByRef CsvParseOptions arg3, @Const @ByRef ConvertOptions arg4);

  public static native @Deprecated @ByVal StreamingReaderResult Make(
        MemoryPool pool, @SharedPtr @Cast({"", "std::shared_ptr<arrow::io::InputStream>"}) InputStream input,
        @Const @ByRef ReadOptions read_options, @Const @ByRef CsvParseOptions parse_options,
        @Const @ByRef ConvertOptions convert_options);
}
