// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow;

import org.bytedeco.arrow.Function;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.arrow.global.arrow.*;


/** \brief Control TDigest approximate quantile kernel behavior
 * 
 *  By default, returns the median value. */
@Namespace("arrow::compute") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow.class)
public class TDigestOptions extends FunctionOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TDigestOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TDigestOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TDigestOptions position(long position) {
        return (TDigestOptions)super.position(position);
    }
    @Override public TDigestOptions getPointer(long i) {
        return new TDigestOptions((Pointer)this).offsetAddress(i);
    }

  public TDigestOptions(double q/*=0.5*/, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/) { super((Pointer)null); allocate(q, delta, buffer_size, skip_nulls, min_count); }
  private native void allocate(double q/*=0.5*/, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/);
  public TDigestOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  public TDigestOptions(@StdVector DoublePointer q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/) { super((Pointer)null); allocate(q, delta, buffer_size, skip_nulls, min_count); }
  private native void allocate(@StdVector DoublePointer q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/);
  public TDigestOptions(@StdVector DoublePointer q) { super((Pointer)null); allocate(q); }
  private native void allocate(@StdVector DoublePointer q);
  public TDigestOptions(@StdVector DoubleBuffer q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/) { super((Pointer)null); allocate(q, delta, buffer_size, skip_nulls, min_count); }
  private native void allocate(@StdVector DoubleBuffer q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/);
  public TDigestOptions(@StdVector DoubleBuffer q) { super((Pointer)null); allocate(q); }
  private native void allocate(@StdVector DoubleBuffer q);
  public TDigestOptions(@StdVector double[] q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/) { super((Pointer)null); allocate(q, delta, buffer_size, skip_nulls, min_count); }
  private native void allocate(@StdVector double[] q, @Cast("uint32_t") int delta/*=100*/,
                            @Cast("uint32_t") int buffer_size/*=500*/, @Cast("bool") boolean skip_nulls/*=true*/,
                            @Cast("uint32_t") int min_count/*=0*/);
  public TDigestOptions(@StdVector double[] q) { super((Pointer)null); allocate(q); }
  private native void allocate(@StdVector double[] q);
  @MemberGetter public static native byte kTypeName(int i);
  @MemberGetter public static native String kTypeName();
  public static native @ByVal TDigestOptions Defaults();

  /** quantile must be between 0 and 1 inclusive */
  public native @StdVector DoublePointer q(); public native TDigestOptions q(DoublePointer setter);
  /** compression parameter, default 100 */
  public native @Cast("uint32_t") int delta(); public native TDigestOptions delta(int setter);
  /** input buffer size, default 500 */
  public native @Cast("uint32_t") int buffer_size(); public native TDigestOptions buffer_size(int setter);
  /** If true (the default), null values are ignored. Otherwise, if any value is null,
   *  emit null. */
  public native @Cast("bool") boolean skip_nulls(); public native TDigestOptions skip_nulls(boolean setter);
  /** If less than this many non-null values are observed, emit null. */
  public native @Cast("uint32_t") int min_count(); public native TDigestOptions min_count(int setter);
}
