// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Create a generator that takes in a stream of generators and pulls from each
 *  one in sequence.
 * 
 *  This generator is async-reentrant but will never pull from source reentrantly and
 *  will never pull from any subscription reentrantly.
 * 
 *  This generator may queue 1 instance of T
 * 
 *  TODO: Could potentially make a bespoke implementation instead of MergedGenerator that
 *  forwards async-reentrant requests instead of buffering them (which is what
 *  MergedGenerator does) */

@Name("arrow::Enumerated<std::shared_ptr<arrow::dataset::Fragment> >") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class FragmentEnumerated extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public FragmentEnumerated() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public FragmentEnumerated(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FragmentEnumerated(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public FragmentEnumerated position(long position) {
        return (FragmentEnumerated)super.position(position);
    }
    @Override public FragmentEnumerated getPointer(long i) {
        return new FragmentEnumerated((Pointer)this).offsetAddress(i);
    }

  public native @SharedPtr @ByRef Fragment value(); public native FragmentEnumerated value(Fragment setter);
  public native int index(); public native FragmentEnumerated index(int setter);
  public native @Cast("bool") boolean last(); public native FragmentEnumerated last(boolean setter);
}
