// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Multi-level, directory based partitioning
 *  originating from Apache Hive with all data files stored in the
 *  leaf directories. Data is partitioned by static values of a
 *  particular column in the schema. Partition keys are represented in
 *  the form $key=$value in directory names.
 *  Field order is ignored, as are missing or unrecognized field names.
 * 
 *  For example given schema<year:int16, month:int8, day:int8> the path
 *  "/day=321/ignored=3.4/year=2009" parses to ("year"_ == 2009 and "day"_ == 321) */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class HivePartitioning extends KeyValuePartitioning {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public HivePartitioning(Pointer p) { super(p); }

  /** If a field in schema is of dictionary type, the corresponding element of
   *  dictionaries must be contain the dictionary of values for that field. */
  public HivePartitioning(@SharedPtr @ByVal Schema schema, @ByVal(nullValue = "arrow::ArrayVector{}") ArrayVector dictionaries,
                              @StdString String null_fallback/*=arrow::dataset::kDefaultHiveNullFallback*/) { super((Pointer)null); allocate(schema, dictionaries, null_fallback); }
  private native void allocate(@SharedPtr @ByVal Schema schema, @ByVal(nullValue = "arrow::ArrayVector{}") ArrayVector dictionaries,
                              @StdString String null_fallback/*=arrow::dataset::kDefaultHiveNullFallback*/);
  public HivePartitioning(@SharedPtr @ByVal Schema schema) { super((Pointer)null); allocate(schema); }
  private native void allocate(@SharedPtr @ByVal Schema schema);
  public HivePartitioning(@SharedPtr @ByVal Schema schema, @ByVal(nullValue = "arrow::ArrayVector{}") ArrayVector dictionaries,
                              @StdString BytePointer null_fallback/*=arrow::dataset::kDefaultHiveNullFallback*/) { super((Pointer)null); allocate(schema, dictionaries, null_fallback); }
  private native void allocate(@SharedPtr @ByVal Schema schema, @ByVal(nullValue = "arrow::ArrayVector{}") ArrayVector dictionaries,
                              @StdString BytePointer null_fallback/*=arrow::dataset::kDefaultHiveNullFallback*/);

  public HivePartitioning(@SharedPtr @ByVal Schema schema, @ByVal ArrayVector dictionaries,
                              @ByVal HivePartitioningOptions options) { super((Pointer)null); allocate(schema, dictionaries, options); }
  private native void allocate(@SharedPtr @ByVal Schema schema, @ByVal ArrayVector dictionaries,
                              @ByVal HivePartitioningOptions options);

  public native @StdString String type_name();
  public native @StdString String null_fallback();
  public native @Const @ByRef HivePartitioningOptions options();

  public static native @ByVal KeyOptionalResult ParseKey(@StdString String segment,
                                                @Const @ByRef HivePartitioningOptions options);
  public static native @ByVal KeyOptionalResult ParseKey(@StdString BytePointer segment,
                                                @Const @ByRef HivePartitioningOptions options);

  /** \brief Create a factory for a hive partitioning. */
  public static native @SharedPtr PartitioningFactory MakeFactory(
        @ByVal(nullValue = "arrow::dataset::HivePartitioningFactoryOptions{}") HivePartitioningFactoryOptions arg0);
  public static native @SharedPtr PartitioningFactory MakeFactory();
}
