// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Per-scan options for Parquet fragments */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class ParquetFragmentScanOptions extends FragmentScanOptions {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParquetFragmentScanOptions(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ParquetFragmentScanOptions(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public ParquetFragmentScanOptions position(long position) {
        return (ParquetFragmentScanOptions)super.position(position);
    }
    @Override public ParquetFragmentScanOptions getPointer(long i) {
        return new ParquetFragmentScanOptions((Pointer)this).offsetAddress(i);
    }

  public ParquetFragmentScanOptions() { super((Pointer)null); allocate(); }
  private native void allocate();
  public native @StdString String type_name();

  /** Reader properties. Not all properties are respected: memory_pool comes from
   *  ScanOptions. */
  public native @SharedPtr ReaderProperties reader_properties(); public native ParquetFragmentScanOptions reader_properties(ReaderProperties setter);
  /** Arrow reader properties. Not all properties are respected: batch_size comes from
   *  ScanOptions, and use_threads will be overridden based on
   *  enable_parallel_column_conversion. Additionally, dictionary columns come from
   *  ParquetFileFormat::ReaderOptions::dict_columns. */
  public native @SharedPtr ArrowReaderProperties arrow_reader_properties(); public native ParquetFragmentScanOptions arrow_reader_properties(ArrowReaderProperties setter);
  /** EXPERIMENTAL: Parallelize conversion across columns. This option is ignored if a
   *  scan is already parallelized across input files to avoid thread contention. This
   *  option will be removed after support is added for simultaneous parallelization
   *  across files and columns. Only affects the threaded reader; the async reader
   *  will parallelize across columns if use_threads is enabled. */
  public native @Cast("bool") boolean enable_parallel_column_conversion(); public native ParquetFragmentScanOptions enable_parallel_column_conversion(boolean setter);
}
