// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief Options for inferring a partitioning. */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class PartitioningFactoryOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public PartitioningFactoryOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public PartitioningFactoryOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public PartitioningFactoryOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public PartitioningFactoryOptions position(long position) {
        return (PartitioningFactoryOptions)super.position(position);
    }
    @Override public PartitioningFactoryOptions getPointer(long i) {
        return new PartitioningFactoryOptions((Pointer)this).offsetAddress(i);
    }

  /** When inferring a schema for partition fields, yield dictionary encoded types
   *  instead of plain. This can be more efficient when materializing virtual
   *  columns, and Expressions parsed by the finished Partitioning will include
   *  dictionaries of all unique inspected values for each field. */
  public native @Cast("bool") boolean infer_dictionary(); public native PartitioningFactoryOptions infer_dictionary(boolean setter);
  /** Optionally, an expected schema can be provided, in which case inference
   *  will only check discovered fields against the schema and update internal
   *  state (such as dictionaries). */
  public native @SharedPtr @ByRef Schema schema(); public native PartitioningFactoryOptions schema(Schema setter);
  /** After splitting a path into components, decode the path components
   *  before parsing according to this scheme. */
  public native SegmentEncoding segment_encoding(); public native PartitioningFactoryOptions segment_encoding(SegmentEncoding setter);

  public native @ByVal KeyValuePartitioningOptions AsPartitioningOptions();
}
