// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** Scan-specific options, which can be changed between scans of the same dataset. */
@Namespace("arrow::dataset") @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class ScanOptions extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public ScanOptions() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ScanOptions(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ScanOptions(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public ScanOptions position(long position) {
        return (ScanOptions)super.position(position);
    }
    @Override public ScanOptions getPointer(long i) {
        return new ScanOptions((Pointer)this).offsetAddress(i);
    }

  /** A row filter (which will be pushed down to partitioning/reading if supported). */
  public native @ByRef Expression filter(); public native ScanOptions filter(Expression setter);
  /** A projection expression (which can add/remove/rename columns). */
  public native @ByRef Expression projection(); public native ScanOptions projection(Expression setter);

  /** Schema with which batches will be read from fragments. This is also known as the
   *  "reader schema" it will be used (for example) in constructing CSV file readers to
   *  identify column types for parsing. Usually only a subset of its fields (see
   *  MaterializedFields) will be materialized during a scan. */
  
  ///
  ///
  ///
  public native @SharedPtr @ByRef Schema dataset_schema(); public native ScanOptions dataset_schema(Schema setter);

  /** Schema of projected record batches. This is independent of dataset_schema as its
   *  fields are derived from the projection. For example, let
   * 
   *    dataset_schema = {"a": int32, "b": int32, "id": utf8}
   *    projection = project({equal(field_ref("a"), field_ref("b"))}, {"a_plus_b"})
   * 
   *  (no filter specified). In this case, the projected_schema would be
   * 
   *    {"a_plus_b": int32} */
  public native @SharedPtr @ByRef Schema projected_schema(); public native ScanOptions projected_schema(Schema setter);

  /** Maximum row count for scanned batches. */
  
  ///
  ///
  public native @Cast("int64_t") long batch_size(); public native ScanOptions batch_size(long setter);

  /** How many batches to read ahead within a file
   * 
   *  Set to 0 to disable batch readahead
   * 
   *  Note: May not be supported by all formats
   *  Note: May not be supported by all scanners
   *  Note: Will be ignored if use_threads is set to false */
  
  ///
  ///
  public native int batch_readahead(); public native ScanOptions batch_readahead(int setter);

  /** How many files to read ahead
   * 
   *  Set to 0 to disable fragment readahead
   * 
   *  Note: May not be enforced by all scanners
   *  Note: Will be ignored if use_threads is set to false */
  public native int fragment_readahead(); public native ScanOptions fragment_readahead(int setter);

  /** A pool from which materialized and scanned arrays will be allocated. */
  
  ///
  public native MemoryPool pool(); public native ScanOptions pool(MemoryPool setter);

  /** IOContext for any IO tasks
   * 
   *  Note: The IOContext executor will be ignored if use_threads is set to false */
  
  ///
  public native @ByRef IOContext io_context(); public native ScanOptions io_context(IOContext setter);

  /** If true the scanner will scan in parallel
   * 
   *  Note: If true, this will use threads from both the cpu_executor and the
   *  io_context.executor
   *  Note: This  must be true in order for any readahead to happen */
  public native @Cast("bool") boolean use_threads(); public native ScanOptions use_threads(boolean setter);

  /** If true then an asycnhronous implementation of the scanner will be used.
   *  This implementation is newer and generally performs better.  However, it
   *  makes extensive use of threading and is still considered experimental */
  public native @Cast("bool") boolean use_async(); public native ScanOptions use_async(boolean setter);

  /** Fragment-specific scan options. */
  public native @SharedPtr FragmentScanOptions fragment_scan_options(); public native ScanOptions fragment_scan_options(FragmentScanOptions setter);

  // Return a vector of fields that requires materialization.
  //
  // This is usually the union of the fields referenced in the projection and the
  // filter expression. Examples:
  //
  // - `SELECT a, b WHERE a < 2 && c > 1` => ["a", "b", "a", "c"]
  // - `SELECT a + b < 3 WHERE a > 1` => ["a", "b"]
  //
  // This is needed for expression where a field may not be directly
  // used in the final projection but is still required to evaluate the
  // expression.
  //
  // This is used by Fragment implementations to apply the column
  // sub-selection optimization.
  public native @ByVal StringVector MaterializedFields();

  // Return a threaded or serial TaskGroup according to use_threads.
  public native @SharedPtr TaskGroup TaskGroup();
}
