// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.arrow_dataset;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;
import org.bytedeco.parquet.*;
import static org.bytedeco.arrow.global.parquet.*;

import static org.bytedeco.arrow.global.arrow_dataset.*;


/** \brief ScannerBuilder is a factory class to construct a Scanner. It is used
 *  to pass information, notably a potential filter expression and a subset of
 *  columns to materialize. */
@Namespace("arrow::dataset") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.arrow_dataset.class)
public class ScannerBuilder extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ScannerBuilder(Pointer p) { super(p); }

  public ScannerBuilder(@SharedPtr @ByVal Dataset dataset) { super((Pointer)null); allocate(dataset); }
  private native void allocate(@SharedPtr @ByVal Dataset dataset);

  public ScannerBuilder(@SharedPtr @ByVal Dataset dataset,
                   @SharedPtr ScanOptions scan_options) { super((Pointer)null); allocate(dataset, scan_options); }
  private native void allocate(@SharedPtr @ByVal Dataset dataset,
                   @SharedPtr ScanOptions scan_options);

  
  ///
  public ScannerBuilder(@SharedPtr @ByVal Schema schema, @SharedPtr @ByVal Fragment fragment,
                   @SharedPtr ScanOptions scan_options) { super((Pointer)null); allocate(schema, fragment, scan_options); }
  private native void allocate(@SharedPtr @ByVal Schema schema, @SharedPtr @ByVal Fragment fragment,
                   @SharedPtr ScanOptions scan_options);

  /** \brief Make a scanner from a record batch reader.
   * 
   *  The resulting scanner can be scanned only once. This is intended
   *  to support writing data from streaming sources or other sources
   *  that can be iterated only once. */
  
  ///
  ///
  ///
  public static native @SharedPtr @ByVal ScannerBuilder FromRecordBatchReader(
        @SharedPtr RecordBatchReader reader);

  /** \brief Set the subset of columns to materialize.
   * 
   *  Columns which are not referenced may not be read from fragments.
   * 
   *  @param columns [in] list of columns to project. Order and duplicates will
   *             be preserved.
   * 
   *  @return Failure if any column name does not exists in the dataset's
   *          Schema. */
  
  ///
  ///
  ///
  public native @ByVal Status Project(@ByVal StringVector columns);

  /** \brief Set expressions which will be evaluated to produce the materialized
   *  columns.
   * 
   *  Columns which are not referenced may not be read from fragments.
   * 
   *  @param exprs [in] expressions to evaluate to produce columns.
   *  @param names [in] list of names for the resulting columns.
   * 
   *  @return Failure if any referenced column does not exists in the dataset's
   *          Schema. */
  
  ///
  ///
  ///
  public native @ByVal Status Project(@StdVector Expression exprs, @ByVal StringVector names);

  /** \brief Set the filter expression to return only rows matching the filter.
   * 
   *  The predicate will be passed down to Sources and corresponding
   *  Fragments to exploit predicate pushdown if possible using
   *  partition information or Fragment internal metadata, e.g. Parquet statistics.
   *  Columns which are not referenced may not be read from fragments.
   * 
   *  @param filter [in] expression to filter rows with.
   * 
   *  @return Failure if any referenced columns does not exist in the dataset's
   *          Schema. */
  public native @ByVal Status Filter(@Const @ByRef Expression filter);

  /** \brief Indicate if the Scanner should make use of the available
   *         ThreadPool found in ScanOptions; */
  
  ///
  public native @ByVal Status UseThreads(@Cast("bool") boolean use_threads/*=true*/);
  public native @ByVal Status UseThreads();

  /** \brief Limit how many fragments the scanner will read at once
   * 
   *  Note: This is only enforced in "async" mode */
  
  ///
  public native @ByVal Status FragmentReadahead(int fragment_readahead);

  /** \brief Indicate if the Scanner should run in experimental "async" mode
   * 
   *  This mode should have considerably better performance on high-latency or parallel
   *  filesystems but is still experimental */
  
  ///
  ///
  public native @ByVal Status UseAsync(@Cast("bool") boolean use_async/*=true*/);
  public native @ByVal Status UseAsync();

  /** \brief Set the maximum number of rows per RecordBatch.
   * 
   *  @param batch_size [in] the maximum number of rows.
   *  @return An error if the number for batch is not greater than 0.
   * 
   *  This option provides a control limiting the memory owned by any RecordBatch. */
  public native @ByVal Status BatchSize(@Cast("int64_t") long batch_size);

  /** \brief Set the pool from which materialized and scanned arrays will be allocated. */
  public native @ByVal Status Pool(MemoryPool pool);

  /** \brief Set fragment-specific scan options. */
  public native @ByVal Status FragmentScanOptions(@SharedPtr FragmentScanOptions fragment_scan_options);

  /** \brief Return the constructed now-immutable Scanner object */
  public native @ByVal ScannerResult Finish();

  public native @Const @SharedPtr @ByRef Schema schema();
  public native @Const @SharedPtr @ByRef Schema projected_schema();
}
