// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


@Namespace("parquet") @NoOffset @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class FileDecryptionProperties extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public FileDecryptionProperties(Pointer p) { super(p); }

  @NoOffset public static class Builder extends Pointer {
      static { Loader.load(); }
      /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
      public Builder(Pointer p) { super(p); }
      /** Native array allocator. Access with {@link Pointer#position(long)}. */
      public Builder(long size) { super((Pointer)null); allocateArray(size); }
      private native void allocateArray(long size);
      @Override public Builder position(long position) {
          return (Builder)super.position(position);
      }
      @Override public Builder getPointer(long i) {
          return new Builder((Pointer)this).offsetAddress(i);
      }
  
    public Builder() { super((Pointer)null); allocate(); }
    private native void allocate();

    /** Set an explicit footer key. If applied on a file that contains
     *  footer key metadata the metadata will be ignored, the footer
     *  will be decrypted/verified with this key.
     *  If explicit key is not set, footer key will be fetched from
     *  key retriever.
     *  With explicit keys or AAD prefix, new encryption properties object must be
     *  created for each encrypted file.
     *  Explicit encryption keys (footer and column) are cloned.
     *  Upon completion of file reading, the cloned encryption keys in the properties
     *  will be wiped out (array values set to 0).
     *  Caller is responsible for wiping out the input key array.
     *  param footerKey Key length must be either 16, 24 or 32 bytes. */
    public native Builder footer_key(@StdString String footer_key);
    public native Builder footer_key(@StdString BytePointer footer_key);

    /** Set explicit column keys (decryption properties).
     *  Its also possible to set a key retriever on this property object.
     *  Upon file decryption, availability of explicit keys is checked before
     *  invocation of the retriever callback.
     *  If an explicit key is available for a footer or a column,
     *  its key metadata will be ignored. */
    public native Builder column_keys(
            @Cast("const parquet::ColumnPathToDecryptionPropertiesMap*") @ByRef ColumnDecryptionPropertiesStringMap column_decryption_properties);

    /** Set a key retriever callback. Its also possible to
     *  set explicit footer or column keys on this file property object.
     *  Upon file decryption, availability of explicit keys is checked before
     *  invocation of the retriever callback.
     *  If an explicit key is available for a footer or a column,
     *  its key metadata will be ignored. */
    public native Builder key_retriever(@SharedPtr DecryptionKeyRetriever key_retriever);

    /** Skip integrity verification of plaintext footers.
     *  If not called, integrity of plaintext footers will be checked in runtime,
     *  and an exception will be thrown in the following situations:
     *  - footer signing key is not available
     *  (not passed, or not found by key retriever)
     *  - footer content and signature don't match */
    public native Builder disable_footer_signature_verification();

    /** Explicitly supply the file AAD prefix.
     *  A must when a prefix is used for file encryption, but not stored in file.
     *  If AAD prefix is stored in file, it will be compared to the explicitly
     *  supplied value and an exception will be thrown if they differ. */
    public native Builder aad_prefix(@StdString String aad_prefix);
    public native Builder aad_prefix(@StdString BytePointer aad_prefix);

    /** Set callback for verification of AAD Prefixes stored in file. */
    public native Builder aad_prefix_verifier(@SharedPtr AADPrefixVerifier aad_prefix_verifier);

    /** By default, reading plaintext (unencrypted) files is not
     *  allowed when using a decryptor
     *  - in order to detect files that were not encrypted by mistake.
     *  However, the default behavior can be overridden by calling this method.
     *  The caller should use then a different method to ensure encryption
     *  of files with sensitive data. */
    public native Builder plaintext_files_allowed();

    public native @SharedPtr FileDecryptionProperties build();
  }

  public native @StdString String column_key(@StdString String column_path);
  public native @StdString BytePointer column_key(@StdString BytePointer column_path);

  public native @StdString String footer_key();

  public native @StdString String aad_prefix();

  public native @SharedPtr DecryptionKeyRetriever key_retriever();

  public native @Cast("bool") boolean check_plaintext_footer_integrity();

  public native @Cast("bool") boolean plaintext_files_allowed();

  public native @SharedPtr AADPrefixVerifier aad_prefix_verifier();

  /** Upon completion of file reading, the encryption keys in the properties
   *  will be wiped out (array values set to 0). */
  public native void WipeOutDecryptionKeys();

  public native @Cast("bool") boolean is_utilized();

  /** FileDecryptionProperties object can be used for reading one file only.
   *  Mark FileDecryptionProperties as utilized once it is used to read a file as the
   *  encryption keys will be wiped out upon completion of file reading. */
  public native void set_utilized();

  /** FileDecryptionProperties object can be used for reading one file only.
   *  (unless this object keeps the keyRetrieval callback only, and no explicit
   *  keys or aadPrefix).
   *  At the end, keys are wiped out in the memory.
   *  This method allows to clone identical properties for another file,
   *  with an option to update the aadPrefix (if newAadPrefix is null,
   *  aadPrefix will be cloned too) */
  public native @SharedPtr FileDecryptionProperties DeepClone(@StdString String new_aad_prefix/*=""*/);
  public native @SharedPtr FileDecryptionProperties DeepClone();
  public native @SharedPtr FileDecryptionProperties DeepClone(@StdString BytePointer new_aad_prefix/*=""*/);
}
