// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.parquet;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.arrow.*;
import static org.bytedeco.arrow.global.arrow.*;

import static org.bytedeco.arrow.global.parquet.*;


/** \brief Feature selection when writing Parquet files
 * 
 *  {@code ParquetVersion::type} governs which data types are allowed and how they
 *  are represented. For example, uint32_t data will be written differently
 *  depending on this value (as INT64 for PARQUET_1_0, as UINT32 for other
 *  versions).
 * 
 *  However, some features - such as compression algorithms, encryption,
 *  or the improved "v2" data page format - must be enabled separately in
 *  ArrowWriterProperties. */
@Namespace("parquet") @Properties(inherit = org.bytedeco.arrow.presets.parquet.class)
public class ParquetVersion extends Pointer {
    static { Loader.load(); }
    /** Default native constructor. */
    public ParquetVersion() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public ParquetVersion(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public ParquetVersion(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public ParquetVersion position(long position) {
        return (ParquetVersion)super.position(position);
    }
    @Override public ParquetVersion getPointer(long i) {
        return new ParquetVersion((Pointer)this).offsetAddress(i);
    }

  public enum type {
    /** Enable only pre-2.2 Parquet format features when writing
     * 
     *  This setting is useful for maximum compatibility with legacy readers.
     *  Note that logical types may still be emitted, as long they have a
     *  corresponding converted type. */
    
///
    PARQUET_1_0(0),

    /** DEPRECATED: Enable Parquet format 2.6 features
     * 
     *  This misleadingly named enum value is roughly similar to PARQUET_2_6. */
    
///
///
    PARQUET_2_0(1),

    /** Enable Parquet format 2.4 and earlier features when writing
     * 
     *  This enables UINT32 as well as logical types which don't have
     *  a corresponding converted type.
     * 
     *  Note: Parquet format 2.4.0 was released in October 2017. */
    
///
///
    PARQUET_2_4(2),

    /** Enable Parquet format 2.6 and earlier features when writing
     * 
     *  This enables the NANOS time unit in addition to the PARQUET_2_4
     *  features.
     * 
     *  Note: Parquet format 2.6.0 was released in September 2018. */
    
///
    PARQUET_2_6(3),

    /** Enable latest Parquet format 2.x features
     * 
     *  This value is equal to the greatest 2.x version supported by
     *  this library. */
    PARQUET_2_LATEST(PARQUET_2_6.value);

      public final int value;
      private type(int v) { this.value = v; }
      private type(type e) { this.value = e.value; }
      public type intern() { for (type e : values()) if (e.value == value) return e; return this; }
      @Override public String toString() { return intern().name(); }
  }
}
