// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Common;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;

import static org.bytedeco.bullet.global.Bullet3Common.*;

// #endif

/**\brief The b3QuadWord class is base class for b3Vector3 and b3Quaternion. 
 * Some issues under PS3 Linux with IBM 2.1 SDK, gcc compiler prevent from using aligned quadword.
 */
// #ifndef USE_LIBSPE2
@Properties(inherit = org.bytedeco.bullet.presets.Bullet3Common.class)
public class b3QuadWord extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3QuadWord(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public b3QuadWord(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public b3QuadWord position(long position) {
        return (b3QuadWord)super.position(position);
    }
    @Override public b3QuadWord getPointer(long i) {
        return new b3QuadWord((Pointer)this).offsetAddress(i);
    }

		public native @Cast("b3Scalar") float m_floats(int i); public native b3QuadWord m_floats(int i, float setter);
		@MemberGetter public native @Cast("b3Scalar*") FloatPointer m_floats();
			public native @Cast("b3Scalar") float x(); public native b3QuadWord x(float setter);
			public native @Cast("b3Scalar") float y(); public native b3QuadWord y(float setter);
			public native @Cast("b3Scalar") float z(); public native b3QuadWord z(float setter);
			public native @Cast("b3Scalar") float w(); public native b3QuadWord w(float setter);
// #if defined(B3_USE_SSE) || defined(B3_USE_NEON)

// #endif

	/**\brief Return the x value */
	public native @Cast("const b3Scalar") float getX();
	/**\brief Return the y value */
	public native @Cast("const b3Scalar") float getY();
	/**\brief Return the z value */
	public native @Cast("const b3Scalar") float getZ();
	/**\brief Set the x value */
	public native void setX(@Cast("b3Scalar") float _x);
	/**\brief Set the y value */
	public native void setY(@Cast("b3Scalar") float _y);
	/**\brief Set the z value */
	public native void setZ(@Cast("b3Scalar") float _z);
	/**\brief Set the w value */
	public native void setW(@Cast("b3Scalar") float _w);
	/**\brief Return the x value */

	//B3_FORCE_INLINE b3Scalar&       operator[](int i)       { return (&m_floats[0])[i];	}
	//B3_FORCE_INLINE const b3Scalar& operator[](int i) const { return (&m_floats[0])[i]; }
	/**operator b3Scalar*() replaces operator[], using implicit conversion. We added operator != and operator == to avoid pointer comparisons. */
	public native @Cast("b3Scalar*") @Name("operator b3Scalar*") FloatPointer asFloatPointer();

	public native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef b3QuadWord other);

	public native @Cast("bool") @Name("operator !=") boolean notEquals(@Const @ByRef b3QuadWord other);

	/**\brief Set x,y,z and zero w 
   * @param x Value of x
   * @param y Value of y
   * @param z Value of z
   */
	public native void setValue(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z);

	/*		void getValue(b3Scalar *m) const 
		{
			m[0] = m_floats[0];
			m[1] = m_floats[1];
			m[2] = m_floats[2];
		}
*/
	/**\brief Set the values 
   * @param x Value of x
   * @param y Value of y
   * @param z Value of z
   * @param w Value of w
   */
	public native void setValue(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z, @Cast("const b3Scalar") float _w);
	/**\brief No initialization constructor */
	public b3QuadWord() { super((Pointer)null); allocate(); }
	private native void allocate();

	/**\brief Three argument constructor (zeros w)
   * @param x Value of x
   * @param y Value of y
   * @param z Value of z
   */
	public b3QuadWord(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z) { super((Pointer)null); allocate(_x, _y, _z); }
	private native void allocate(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z);

	/**\brief Initializing constructor
   * @param x Value of x
   * @param y Value of y
   * @param z Value of z
   * @param w Value of w
   */
	public b3QuadWord(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z, @Cast("const b3Scalar") float _w) { super((Pointer)null); allocate(_x, _y, _z, _w); }
	private native void allocate(@Cast("const b3Scalar") float _x, @Cast("const b3Scalar") float _y, @Cast("const b3Scalar") float _z, @Cast("const b3Scalar") float _w);

	/**\brief Set each element to the max of the current values and the values of another b3QuadWord
   * @param other The other b3QuadWord to compare with 
   */
	public native void setMax(@Const @ByRef b3QuadWord other);
	/**\brief Set each element to the min of the current values and the values of another b3QuadWord
   * @param other The other b3QuadWord to compare with 
   */
	public native void setMin(@Const @ByRef b3QuadWord other);
}
