// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;
  // for the types

/** The btConvexTriangleMeshShape is a convex hull of a triangle mesh, but the performance is not as good as btConvexHullShape.
 *  A small benefit of this class is that it uses the btStridingMeshInterface, so you can avoid the duplication of the triangle mesh data. Nevertheless, most users should use the much better performing btConvexHullShape instead. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btConvexTriangleMeshShape extends btPolyhedralConvexAabbCachingShape {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btConvexTriangleMeshShape(Pointer p) { super(p); }


	public btConvexTriangleMeshShape(btStridingMeshInterface meshInterface, @Cast("bool") boolean calcAabb/*=true*/) { super((Pointer)null); allocate(meshInterface, calcAabb); }
	private native void allocate(btStridingMeshInterface meshInterface, @Cast("bool") boolean calcAabb/*=true*/);
	public btConvexTriangleMeshShape(btStridingMeshInterface meshInterface) { super((Pointer)null); allocate(meshInterface); }
	private native void allocate(btStridingMeshInterface meshInterface);

	public native btStridingMeshInterface getMeshInterface();

	public native @ByVal btVector3 localGetSupportingVertex(@Const @ByRef btVector3 vec);
	public native @ByVal btVector3 localGetSupportingVertexWithoutMargin(@Const @ByRef btVector3 vec);
	public native void batchedUnitVectorGetSupportingVertexWithoutMargin(@Const btVector3 vectors, btVector3 supportVerticesOut, int numVectors);

	//debugging
	public native @Cast("const char*") BytePointer getName();

	public native int getNumVertices();
	public native int getNumEdges();
	public native void getEdge(int i, @ByRef btVector3 pa, @ByRef btVector3 pb);
	public native void getVertex(int i, @ByRef btVector3 vtx);
	public native int getNumPlanes();
	public native void getPlane(@ByRef btVector3 planeNormal, @ByRef btVector3 planeSupport, int i);
	public native @Cast("bool") boolean isInside(@Const @ByRef btVector3 pt, @Cast("btScalar") double tolerance);

	public native void setLocalScaling(@Const @ByRef btVector3 scaling);
	public native @Const @ByRef btVector3 getLocalScaling();

	/**computes the exact moment of inertia and the transform from the coordinate system defined by the principal axes of the moment of inertia
	 * and the center of mass to the current coordinate system. A mass of 1 is assumed, for other masses just multiply the computed "inertia"
	 * by the mass. The resulting transform "principal" has to be applied inversely to the mesh in order for the local coordinate system of the
	 * shape to be centered at the center of mass and to coincide with the principal axes. This also necessitates a correction of the world transform
	 * of the collision object by the principal transform. This method also computes the volume of the convex mesh. */
	public native void calculatePrincipalAxisTransform(@ByRef btTransform principal, @ByRef btVector3 inertia, @Cast("btScalar*") @ByRef DoublePointer volume);
	public native void calculatePrincipalAxisTransform(@ByRef btTransform principal, @ByRef btVector3 inertia, @Cast("btScalar*") @ByRef DoubleBuffer volume);
	public native void calculatePrincipalAxisTransform(@ByRef btTransform principal, @ByRef btVector3 inertia, @Cast("btScalar*") @ByRef double[] volume);
}
