// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btDbvt class implements a fast dynamic bounding volume tree based on axis aligned bounding boxes (aabb tree).
 * This btDbvt is used for soft body collision detection and for the btDbvtBroadphase. It has a fast insert, remove and update of nodes.
 * Unlike the btQuantizedBvh, nodes can be dynamically moved around, which allows for change in topology of the underlying data structure. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btDbvt extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btDbvt(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btDbvt(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btDbvt position(long position) {
        return (btDbvt)super.position(position);
    }
    @Override public btDbvt getPointer(long i) {
        return new btDbvt((Pointer)this).offsetAddress(i);
    }

	/* Stack element	*/
	@NoOffset public static class sStkNN extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sStkNN(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public sStkNN(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public sStkNN position(long position) {
	        return (sStkNN)super.position(position);
	    }
	    @Override public sStkNN getPointer(long i) {
	        return new sStkNN((Pointer)this).offsetAddress(i);
	    }
	
		public native @Const btDbvtNode a(); public native sStkNN a(btDbvtNode setter);
		public native @Const btDbvtNode b(); public native sStkNN b(btDbvtNode setter);
		public sStkNN() { super((Pointer)null); allocate(); }
		private native void allocate();
		public sStkNN(@Const btDbvtNode na, @Const btDbvtNode nb) { super((Pointer)null); allocate(na, nb); }
		private native void allocate(@Const btDbvtNode na, @Const btDbvtNode nb);
	}
	@NoOffset public static class sStkNP extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sStkNP(Pointer p) { super(p); }
	
		public native @Const btDbvtNode node(); public native sStkNP node(btDbvtNode setter);
		public native int mask(); public native sStkNP mask(int setter);
		public sStkNP(@Const btDbvtNode n, @Cast("unsigned") int m) { super((Pointer)null); allocate(n, m); }
		private native void allocate(@Const btDbvtNode n, @Cast("unsigned") int m);
	}
	@NoOffset public static class sStkNPS extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sStkNPS(Pointer p) { super(p); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public sStkNPS(long size) { super((Pointer)null); allocateArray(size); }
	    private native void allocateArray(long size);
	    @Override public sStkNPS position(long position) {
	        return (sStkNPS)super.position(position);
	    }
	    @Override public sStkNPS getPointer(long i) {
	        return new sStkNPS((Pointer)this).offsetAddress(i);
	    }
	
		public native @Const btDbvtNode node(); public native sStkNPS node(btDbvtNode setter);
		public native int mask(); public native sStkNPS mask(int setter);
		public native @Cast("btScalar") double value(); public native sStkNPS value(double setter);
		public sStkNPS() { super((Pointer)null); allocate(); }
		private native void allocate();
		public sStkNPS(@Const btDbvtNode n, @Cast("unsigned") int m, @Cast("btScalar") double v) { super((Pointer)null); allocate(n, m, v); }
		private native void allocate(@Const btDbvtNode n, @Cast("unsigned") int m, @Cast("btScalar") double v);
	}
	@NoOffset public static class sStkCLN extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public sStkCLN(Pointer p) { super(p); }
	
		public native @Const btDbvtNode node(); public native sStkCLN node(btDbvtNode setter);
		public native btDbvtNode parent(); public native sStkCLN parent(btDbvtNode setter);
		public sStkCLN(@Const btDbvtNode n, btDbvtNode p) { super((Pointer)null); allocate(n, p); }
		private native void allocate(@Const btDbvtNode n, btDbvtNode p);
	}
    
    @NoOffset public static class sStknNN extends Pointer {
        static { Loader.load(); }
        /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
        public sStknNN(Pointer p) { super(p); }
        /** Native array allocator. Access with {@link Pointer#position(long)}. */
        public sStknNN(long size) { super((Pointer)null); allocateArray(size); }
        private native void allocateArray(long size);
        @Override public sStknNN position(long position) {
            return (sStknNN)super.position(position);
        }
        @Override public sStknNN getPointer(long i) {
            return new sStknNN((Pointer)this).offsetAddress(i);
        }
    
        public native @Const btDbvntNode a(); public native sStknNN a(btDbvntNode setter);
        public native @Const btDbvntNode b(); public native sStknNN b(btDbvntNode setter);
        public sStknNN() { super((Pointer)null); allocate(); }
        private native void allocate();
        public sStknNN(@Const btDbvntNode na, @Const btDbvntNode nb) { super((Pointer)null); allocate(na, nb); }
        private native void allocate(@Const btDbvntNode na, @Const btDbvntNode nb);
    }
	// Policies/Interfaces

	/* ICollide	*/
	public static class ICollide extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public ICollide() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public ICollide(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public ICollide(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public ICollide position(long position) {
	        return (ICollide)super.position(position);
	    }
	    @Override public ICollide getPointer(long i) {
	        return new ICollide((Pointer)this).offsetAddress(i);
	    }
	
		public native void Process(@Const btDbvtNode arg0, @Const btDbvtNode arg1);
		public native void Process(@Const btDbvtNode arg0);
		public native void Process(@Const btDbvtNode n, @Cast("btScalar") double arg1);
        public native void Process(@Const btDbvntNode arg0, @Const btDbvntNode arg1);
		public native @Cast("bool") boolean Descent(@Const btDbvtNode arg0);
		public native @Cast("bool") boolean AllLeaves(@Const btDbvtNode arg0);
	}
	/* IWriter	*/
	public static class IWriter extends Pointer {
	    static { Loader.load(); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public IWriter(Pointer p) { super(p); }
	
		public native void Prepare(@Const btDbvtNode root, int numnodes);
		public native void WriteNode(@Const btDbvtNode arg0, int index, int parent, int child0, int child1);
		public native void WriteLeaf(@Const btDbvtNode arg0, int index, int parent);
	}
	/* IClone	*/
	public static class IClone extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public IClone() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public IClone(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public IClone(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public IClone position(long position) {
	        return (IClone)super.position(position);
	    }
	    @Override public IClone getPointer(long i) {
	        return new IClone((Pointer)this).offsetAddress(i);
	    }
	
		public native void CloneLeaf(btDbvtNode arg0);
	}

	// Constants
	/** enum btDbvt:: */
	public static final int
		SIMPLE_STACKSIZE = 64,
		DOUBLE_STACKSIZE = SIMPLE_STACKSIZE * 2;

	// Fields
	public native btDbvtNode m_root(); public native btDbvt m_root(btDbvtNode setter);
	public native btDbvtNode m_free(); public native btDbvt m_free(btDbvtNode setter);
	public native int m_lkhd(); public native btDbvt m_lkhd(int setter);
	public native int m_leaves(); public native btDbvt m_leaves(int setter);
	public native @Cast("unsigned") int m_opath(); public native btDbvt m_opath(int setter);

	public native @ByRef btDbvtStkNNArray m_stkStack(); public native btDbvt m_stkStack(btDbvtStkNNArray setter);

	// Methods
	public btDbvt() { super((Pointer)null); allocate(); }
	private native void allocate();
	public native void clear();
	public native @Cast("bool") boolean empty();
	public native void optimizeBottomUp();
	public native void optimizeTopDown(int bu_treshold/*=128*/);
	public native void optimizeTopDown();
	public native void optimizeIncremental(int passes);
	public native btDbvtNode insert(@Cast("const btDbvtVolume*") @ByRef btDbvtAabbMm box, Pointer data);
	public native void update(btDbvtNode leaf, int lookahead/*=-1*/);
	public native void update(btDbvtNode leaf);
	public native void update(btDbvtNode leaf, @Cast("btDbvtVolume*") @ByRef btDbvtAabbMm volume);
	public native @Cast("bool") boolean update(btDbvtNode leaf, @Cast("btDbvtVolume*") @ByRef btDbvtAabbMm volume, @Const @ByRef btVector3 velocity, @Cast("btScalar") double margin);
	public native @Cast("bool") boolean update(btDbvtNode leaf, @Cast("btDbvtVolume*") @ByRef btDbvtAabbMm volume, @Const @ByRef btVector3 velocity);
	public native @Cast("bool") boolean update(btDbvtNode leaf, @Cast("btDbvtVolume*") @ByRef btDbvtAabbMm volume, @Cast("btScalar") double margin);
	public native void remove(btDbvtNode leaf);
	public native void write(IWriter iwriter);
	public native void clone(@ByRef btDbvt dest, IClone iclone/*=0*/);
	public native void clone(@ByRef btDbvt dest);
	public static native int maxdepth(@Const btDbvtNode node);
	public static native int countLeaves(@Const btDbvtNode node);
	
// #if DBVT_ENABLE_BENCHMARK
	public static native void benchmark();
// #else
// #endif
	// DBVT_IPOLICY must support ICollide policy/interface
// #if 0
// #endif

	/**rayTest is a re-entrant ray test, and can be called in parallel as long as the btAlignedAlloc is thread-safe (uses locking etc)
	 * rayTest is slower than rayTestInternal, because it builds a local stack, using memory allocations, and it recomputes signs/rayDirectionInverses each time */
	/**rayTestInternal is faster than rayTest, because it uses a persistent stack (to reduce dynamic memory allocations to a minimum) and it uses precomputed signs/rayInverseDirections
	 * rayTestInternal is used by btDbvtBroadphase to accelerate world ray casts */
	// Helpers
	public static native int nearest(@Const IntPointer i, @Const sStkNPS a, @Cast("btScalar") double v, int l, int h);
	public static native int nearest(@Const IntBuffer i, @Const sStkNPS a, @Cast("btScalar") double v, int l, int h);
	public static native int nearest(@Const int[] i, @Const sStkNPS a, @Cast("btScalar") double v, int l, int h);
	public static native @Name("allocate") int _allocate(@ByRef btIntArray ifree,
										@ByRef btDbvtStkNPSArray stock,
										@Const @ByRef sStkNPS value);
}
