// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btDbvtBroadphase implements a broadphase using two dynamic AABB bounding volume hierarchies/trees (see btDbvt).
 * One tree is used for static/non-moving objects, and another tree is used for dynamic objects. Objects can move from one tree to the other.
 * This is a very fast broadphase, especially for very dynamic worlds where many objects are moving. Its insert/add and remove of objects is generally faster than the sweep and prune broadphases btAxisSweep3 and bt32BitAxisSweep3. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btDbvtBroadphase extends btBroadphaseInterface {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btDbvtBroadphase(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btDbvtBroadphase(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btDbvtBroadphase position(long position) {
        return (btDbvtBroadphase)super.position(position);
    }
    @Override public btDbvtBroadphase getPointer(long i) {
        return new btDbvtBroadphase((Pointer)this).offsetAddress(i);
    }

	/* Config		*/
	/** enum btDbvtBroadphase:: */
	public static final int
		DYNAMIC_SET = 0, /* Dynamic set index	*/
		FIXED_SET = 1,   /* Fixed set index		*/
		STAGECOUNT = 2;   /* Number of stages		*/
	/* Fields		*/
	public native @ByRef btDbvt m_sets(int i); public native btDbvtBroadphase m_sets(int i, btDbvt setter);
	@MemberGetter public native btDbvt m_sets();                           // Dbvt sets
	public native btDbvtProxy m_stageRoots(int i); public native btDbvtBroadphase m_stageRoots(int i, btDbvtProxy setter);
	@MemberGetter public native @Cast("btDbvtProxy**") PointerPointer m_stageRoots();  // Stages list
	public native btOverlappingPairCache m_paircache(); public native btDbvtBroadphase m_paircache(btOverlappingPairCache setter);        // Pair cache
	public native @Cast("btScalar") double m_prediction(); public native btDbvtBroadphase m_prediction(double setter);                      // Velocity prediction
	public native int m_stageCurrent(); public native btDbvtBroadphase m_stageCurrent(int setter);                         // Current stage
	public native int m_fupdates(); public native btDbvtBroadphase m_fupdates(int setter);                             // % of fixed updates per frame
	public native int m_dupdates(); public native btDbvtBroadphase m_dupdates(int setter);                             // % of dynamic updates per frame
	public native int m_cupdates(); public native btDbvtBroadphase m_cupdates(int setter);                             // % of cleanup updates per frame
	public native int m_newpairs(); public native btDbvtBroadphase m_newpairs(int setter);                             // Number of pairs created
	public native int m_fixedleft(); public native btDbvtBroadphase m_fixedleft(int setter);                            // Fixed optimization left
	public native @Cast("unsigned") int m_updates_call(); public native btDbvtBroadphase m_updates_call(int setter);                    // Number of updates call
	public native @Cast("unsigned") int m_updates_done(); public native btDbvtBroadphase m_updates_done(int setter);                    // Number of updates done
	public native @Cast("btScalar") double m_updates_ratio(); public native btDbvtBroadphase m_updates_ratio(double setter);                   // m_updates_done/m_updates_call
	public native int m_pid(); public native btDbvtBroadphase m_pid(int setter);                                  // Parse id
	public native int m_cid(); public native btDbvtBroadphase m_cid(int setter);                                  // Cleanup index
	public native int m_gid(); public native btDbvtBroadphase m_gid(int setter);                                  // Gen id
	public native @Cast("bool") boolean m_releasepaircache(); public native btDbvtBroadphase m_releasepaircache(boolean setter);                    // Release pair cache on delete
	public native @Cast("bool") boolean m_deferedcollide(); public native btDbvtBroadphase m_deferedcollide(boolean setter);                      // Defere dynamic/static collision to collide call
	public native @Cast("bool") boolean m_needcleanup(); public native btDbvtBroadphase m_needcleanup(boolean setter);                         // Need to run cleanup?
	
// #if DBVT_BP_PROFILE
// #endif
	/* Methods		*/
	public btDbvtBroadphase(btOverlappingPairCache paircache/*=0*/) { super((Pointer)null); allocate(paircache); }
	private native void allocate(btOverlappingPairCache paircache/*=0*/);
	public btDbvtBroadphase() { super((Pointer)null); allocate(); }
	private native void allocate();
	public native void collide(btDispatcher dispatcher);
	public native void optimize();

	/* btBroadphaseInterface Implementation	*/
	public native btBroadphaseProxy createProxy(@Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, int shapeType, Pointer userPtr, int collisionFilterGroup, int collisionFilterMask, btDispatcher dispatcher);
	public native void destroyProxy(btBroadphaseProxy proxy, btDispatcher dispatcher);
	public native void setAabb(btBroadphaseProxy proxy, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, btDispatcher dispatcher);
	public native void rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @ByRef btBroadphaseRayCallback rayCallback, @Const @ByRef(nullValue = "btVector3(0, 0, 0)") btVector3 aabbMin, @Const @ByRef(nullValue = "btVector3(0, 0, 0)") btVector3 aabbMax);
	public native void rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @ByRef btBroadphaseRayCallback rayCallback);
	public native void aabbTest(@Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, @ByRef btBroadphaseAabbCallback callback);

	public native void getAabb(btBroadphaseProxy proxy, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);
	public native void calculateOverlappingPairs(btDispatcher dispatcher);
	public native btOverlappingPairCache getOverlappingPairCache();
	public native void getBroadphaseAabb(@ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);
	public native void printStats();

	/**reset broadphase internal structures, to ensure determinism/reproducability */
	public native void resetPool(btDispatcher dispatcher);

	public native void performDeferredRemoval(btDispatcher dispatcher);

	public native void setVelocityPrediction(@Cast("btScalar") double prediction);
	public native @Cast("btScalar") double getVelocityPrediction();

	/**this setAabbForceUpdate is similar to setAabb but always forces the aabb update.
	 * it is not part of the btBroadphaseInterface but specific to btDbvtBroadphase.
	 * it bypasses certain optimizations that prevent aabb updates (when the aabb shrinks), see
	 * http://code.google.com/p/bullet/issues/detail?id=223 */
	public native void setAabbForceUpdate(btBroadphaseProxy absproxy, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax, btDispatcher arg3);

	public static native void benchmark(btBroadphaseInterface arg0);
}
