// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/** This class manages a mesh supplied by the btStridingMeshInterface interface.
/**
Set of btGImpactMeshShapePart parts
- Simply create this shape by passing the btStridingMeshInterface to the constructor btGImpactMeshShape, then you must call updateBound() after creating the mesh
<p>
- You can handle deformable meshes with this shape, by calling postUpdate() every time when changing the mesh vertices.
<p>
*/
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btGImpactMeshShape extends btGImpactShapeInterface {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btGImpactMeshShape(Pointer p) { super(p); }

	public btGImpactMeshShape(btStridingMeshInterface meshInterface) { super((Pointer)null); allocate(meshInterface); }
	private native void allocate(btStridingMeshInterface meshInterface);

	public native btStridingMeshInterface getMeshInterface();

	public native int getMeshPartCount();

	public native btGImpactMeshShapePart getMeshPart(int index);

	public native void setLocalScaling(@Const @ByRef btVector3 scaling);

	public native void setMargin(@Cast("btScalar") double margin);

	/** Tells to this object that is needed to refit all the meshes */
	public native void postUpdate();

	public native void calculateLocalInertia(@Cast("btScalar") double mass, @ByRef btVector3 inertia);

	/** Obtains the primitive manager */
	public native @Const btPrimitiveManagerBase getPrimitiveManager();

	/** Gets the number of children */
	public native int getNumChildShapes();

	/** if true, then its children must get transforms. */
	public native @Cast("bool") boolean childrenHasTransform();

	/** Determines if this shape has triangles */
	public native @Cast("bool") boolean needsRetrieveTriangles();

	/** Determines if this shape has tetrahedrons */
	public native @Cast("bool") boolean needsRetrieveTetrahedrons();

	public native void getBulletTriangle(int prim_index, @ByRef btTriangleShapeEx triangle);

	public native void getBulletTetrahedron(int prim_index, @ByRef btTetrahedronShapeEx tetrahedron);

	/** call when reading child shapes */
	public native void lockChildShapes();

	public native void unlockChildShapes();

	/** Retrieves the bound from a child
	/**
    */
	public native void getChildAabb(int child_index, @Const @ByRef btTransform t, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	/** Gets the children */
	public native btCollisionShape getChildShape(int index);

	/** Gets the child */

	/** Gets the children transform */
	public native @ByVal btTransform getChildTransform(int index);

	/** Sets the children transform
	/**
	\post You must call updateBound() for update the box set.
	*/
	public native void setChildTransform(int index, @Const @ByRef btTransform transform);

	public native @Cast("eGIMPACT_SHAPE_TYPE") int getGImpactShapeType();

	public native @Cast("const char*") BytePointer getName();

	public native void rayTest(@Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo, @ByRef btCollisionWorld.RayResultCallback resultCallback);

	/** Function for retrieve triangles.
	/**
	It gives the triangles in local space
	*/
	public native void processAllTriangles(btTriangleCallback callback, @Const @ByRef btVector3 aabbMin, @Const @ByRef btVector3 aabbMax);

	public native void processAllTrianglesRay(btTriangleCallback callback, @Const @ByRef btVector3 rayFrom, @Const @ByRef btVector3 rayTo);

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
