// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btIndexedMesh indexes a single vertex and index array. Multiple btIndexedMesh objects can be passed into a btTriangleIndexVertexArray using addIndexedMesh.
 * Instead of the number of indices, we pass the number of triangles. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btIndexedMesh extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btIndexedMesh(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btIndexedMesh(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btIndexedMesh position(long position) {
        return (btIndexedMesh)super.position(position);
    }
    @Override public btIndexedMesh getPointer(long i) {
        return new btIndexedMesh((Pointer)this).offsetAddress(i);
    }


	public native int m_numTriangles(); public native btIndexedMesh m_numTriangles(int setter);
	public native @Cast("const unsigned char*") BytePointer m_triangleIndexBase(); public native btIndexedMesh m_triangleIndexBase(BytePointer setter);
	// Size in byte of the indices for one triangle (3*sizeof(index_type) if the indices are tightly packed)
	public native int m_triangleIndexStride(); public native btIndexedMesh m_triangleIndexStride(int setter);
	public native int m_numVertices(); public native btIndexedMesh m_numVertices(int setter);
	public native @Cast("const unsigned char*") BytePointer m_vertexBase(); public native btIndexedMesh m_vertexBase(BytePointer setter);
	// Size of a vertex, in bytes
	public native int m_vertexStride(); public native btIndexedMesh m_vertexStride(int setter);

	// The index type is set when adding an indexed mesh to the
	// btTriangleIndexVertexArray, do not set it manually
	public native @Cast("PHY_ScalarType") int m_indexType(); public native btIndexedMesh m_indexType(int setter);

	// The vertex type has a default type similar to Bullet's precision mode (float or double)
	// but can be set manually if you for example run Bullet with double precision but have
	// mesh data in single precision..
	public native @Cast("PHY_ScalarType") int m_vertexType(); public native btIndexedMesh m_vertexType(int setter);

	public btIndexedMesh() { super((Pointer)null); allocate(); }
	private native void allocate();
}
