// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btMultiSphereShape represents the convex hull of a collection of spheres. You can create special capsules or other smooth volumes.
 * It is possible to animate the spheres for deformation, but call 'recalcLocalAabb' after changing any sphere position/radius */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btMultiSphereShape extends btConvexInternalAabbCachingShape {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btMultiSphereShape(Pointer p) { super(p); }


	public btMultiSphereShape(@Const btVector3 positions, @Cast("const btScalar*") DoublePointer radi, int numSpheres) { super((Pointer)null); allocate(positions, radi, numSpheres); }
	private native void allocate(@Const btVector3 positions, @Cast("const btScalar*") DoublePointer radi, int numSpheres);
	public btMultiSphereShape(@Const btVector3 positions, @Cast("const btScalar*") DoubleBuffer radi, int numSpheres) { super((Pointer)null); allocate(positions, radi, numSpheres); }
	private native void allocate(@Const btVector3 positions, @Cast("const btScalar*") DoubleBuffer radi, int numSpheres);
	public btMultiSphereShape(@Const btVector3 positions, @Cast("const btScalar*") double[] radi, int numSpheres) { super((Pointer)null); allocate(positions, radi, numSpheres); }
	private native void allocate(@Const btVector3 positions, @Cast("const btScalar*") double[] radi, int numSpheres);

	/**CollisionShape Interface */
	public native void calculateLocalInertia(@Cast("btScalar") double mass, @ByRef btVector3 inertia);

	/** btConvexShape Interface */
	public native @ByVal btVector3 localGetSupportingVertexWithoutMargin(@Const @ByRef btVector3 vec);

	public native void batchedUnitVectorGetSupportingVertexWithoutMargin(@Const btVector3 vectors, btVector3 supportVerticesOut, int numVectors);

	public native int getSphereCount();

	public native @Const @ByRef btVector3 getSpherePosition(int index);

	public native @Cast("btScalar") double getSphereRadius(int index);

	public native @Cast("const char*") BytePointer getName();

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
