// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btTriangleBuffer callback can be useful to collect and store overlapping triangles between AABB and concave objects that support 'processAllTriangles'
 * Example usage of this class:
 * 			btTriangleBuffer	triBuf;
 * 			concaveShape->processAllTriangles(&triBuf,aabbMin, aabbMax);
 * 			for (int i=0;i<triBuf.getNumTriangles();i++)
 * 			{
 * 				const btTriangle& tri = triBuf.getTriangle(i);
 * 				//do something useful here with the triangle
 * 			} */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btTriangleBuffer extends btTriangleCallback {
    static { Loader.load(); }
    /** Default native constructor. */
    public btTriangleBuffer() { super((Pointer)null); allocate(); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btTriangleBuffer(long size) { super((Pointer)null); allocateArray(size); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btTriangleBuffer(Pointer p) { super(p); }
    private native void allocate();
    private native void allocateArray(long size);
    @Override public btTriangleBuffer position(long position) {
        return (btTriangleBuffer)super.position(position);
    }
    @Override public btTriangleBuffer getPointer(long i) {
        return new btTriangleBuffer((Pointer)this).offsetAddress(i);
    }

	public native void processTriangle(btVector3 triangle, int partId, int triangleIndex);

	public native int getNumTriangles();

	public native @Const @ByRef btTriangle getTriangle(int index);

	public native void clearBuffer();
}
