// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;


//notes:
// Another memory optimization would be to store m_1MinvJt in the remaining 3 w components
// which makes the btJacobianEntry memory layout 16 bytes
// if you only are interested in angular part, just feed massInvA and massInvB zero

/** Jacobian entry is an abstraction that allows to describe constraints
 *  it can be used in combination with a constraint solver
 *  Can be used to relate the effect of an impulse to the constraint error */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btJacobianEntry extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btJacobianEntry(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btJacobianEntry(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btJacobianEntry position(long position) {
        return (btJacobianEntry)super.position(position);
    }
    @Override public btJacobianEntry getPointer(long i) {
        return new btJacobianEntry((Pointer)this).offsetAddress(i);
    }

	public btJacobianEntry() { super((Pointer)null); allocate(); }
	private native void allocate();
	//constraint between two different rigidbodies
	public btJacobianEntry(
			@Const @ByRef btMatrix3x3 world2A,
			@Const @ByRef btMatrix3x3 world2B,
			@Const @ByRef btVector3 rel_pos1, @Const @ByRef btVector3 rel_pos2,
			@Const @ByRef btVector3 jointAxis,
			@Const @ByRef btVector3 inertiaInvA,
			@Cast("const btScalar") double massInvA,
			@Const @ByRef btVector3 inertiaInvB,
			@Cast("const btScalar") double massInvB) { super((Pointer)null); allocate(world2A, world2B, rel_pos1, rel_pos2, jointAxis, inertiaInvA, massInvA, inertiaInvB, massInvB); }
	private native void allocate(
			@Const @ByRef btMatrix3x3 world2A,
			@Const @ByRef btMatrix3x3 world2B,
			@Const @ByRef btVector3 rel_pos1, @Const @ByRef btVector3 rel_pos2,
			@Const @ByRef btVector3 jointAxis,
			@Const @ByRef btVector3 inertiaInvA,
			@Cast("const btScalar") double massInvA,
			@Const @ByRef btVector3 inertiaInvB,
			@Cast("const btScalar") double massInvB);

	//angular constraint between two different rigidbodies
	public btJacobianEntry(@Const @ByRef btVector3 jointAxis,
						@Const @ByRef btMatrix3x3 world2A,
						@Const @ByRef btMatrix3x3 world2B,
						@Const @ByRef btVector3 inertiaInvA,
						@Const @ByRef btVector3 inertiaInvB) { super((Pointer)null); allocate(jointAxis, world2A, world2B, inertiaInvA, inertiaInvB); }
	private native void allocate(@Const @ByRef btVector3 jointAxis,
						@Const @ByRef btMatrix3x3 world2A,
						@Const @ByRef btMatrix3x3 world2B,
						@Const @ByRef btVector3 inertiaInvA,
						@Const @ByRef btVector3 inertiaInvB);

	//angular constraint between two different rigidbodies
	public btJacobianEntry(@Const @ByRef btVector3 axisInA,
						@Const @ByRef btVector3 axisInB,
						@Const @ByRef btVector3 inertiaInvA,
						@Const @ByRef btVector3 inertiaInvB) { super((Pointer)null); allocate(axisInA, axisInB, inertiaInvA, inertiaInvB); }
	private native void allocate(@Const @ByRef btVector3 axisInA,
						@Const @ByRef btVector3 axisInB,
						@Const @ByRef btVector3 inertiaInvA,
						@Const @ByRef btVector3 inertiaInvB);

	//constraint on one rigidbody
	public btJacobianEntry(
			@Const @ByRef btMatrix3x3 world2A,
			@Const @ByRef btVector3 rel_pos1, @Const @ByRef btVector3 rel_pos2,
			@Const @ByRef btVector3 jointAxis,
			@Const @ByRef btVector3 inertiaInvA,
			@Cast("const btScalar") double massInvA) { super((Pointer)null); allocate(world2A, rel_pos1, rel_pos2, jointAxis, inertiaInvA, massInvA); }
	private native void allocate(
			@Const @ByRef btMatrix3x3 world2A,
			@Const @ByRef btVector3 rel_pos1, @Const @ByRef btVector3 rel_pos2,
			@Const @ByRef btVector3 jointAxis,
			@Const @ByRef btVector3 inertiaInvA,
			@Cast("const btScalar") double massInvA);

	public native @Cast("btScalar") double getDiagonal();

	// for two constraints on the same rigidbody (for example vehicle friction)
	public native @Cast("btScalar") double getNonDiagonal(@Const @ByRef btJacobianEntry jacB, @Cast("const btScalar") double massInvA);

	// for two constraints on sharing two same rigidbodies (for example two contact points between two rigidbodies)
	public native @Cast("btScalar") double getNonDiagonal(@Const @ByRef btJacobianEntry jacB, @Cast("const btScalar") double massInvA, @Cast("const btScalar") double massInvB);

	public native @Cast("btScalar") double getRelativeVelocity(@Const @ByRef btVector3 linvelA, @Const @ByRef btVector3 angvelA, @Const @ByRef btVector3 linvelB, @Const @ByRef btVector3 angvelB);
	//private:

	public native @ByRef btVector3 m_linearJointAxis(); public native btJacobianEntry m_linearJointAxis(btVector3 setter);
	public native @ByRef btVector3 m_aJ(); public native btJacobianEntry m_aJ(btVector3 setter);
	public native @ByRef btVector3 m_bJ(); public native btJacobianEntry m_bJ(btVector3 setter);
	public native @ByRef btVector3 m_0MinvJt(); public native btJacobianEntry m_0MinvJt(btVector3 setter);
	public native @ByRef btVector3 m_1MinvJt(); public native btJacobianEntry m_1MinvJt(btVector3 setter);
	//Optimization: can be stored in the w/last component of one of the vectors
	public native @Cast("btScalar") double m_Adiag(); public native btJacobianEntry m_Adiag(double setter);
}
