// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletDynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

import static org.bytedeco.bullet.global.BulletDynamics.*;


/**TypedConstraint is the baseclass for Bullet constraints and vehicles */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletDynamics.class)
public class btTypedConstraint extends btTypedObject {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btTypedConstraint(Pointer p) { super(p); }


	public static class btConstraintInfo1 extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public btConstraintInfo1() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public btConstraintInfo1(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public btConstraintInfo1(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public btConstraintInfo1 position(long position) {
	        return (btConstraintInfo1)super.position(position);
	    }
	    @Override public btConstraintInfo1 getPointer(long i) {
	        return new btConstraintInfo1((Pointer)this).offsetAddress(i);
	    }
	
		public native int m_numConstraintRows(); public native btConstraintInfo1 m_numConstraintRows(int setter);
		public native int nub(); public native btConstraintInfo1 nub(int setter);
	}

	public static native @ByRef btRigidBody getFixedBody();

	public static class btConstraintInfo2 extends Pointer {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public btConstraintInfo2() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public btConstraintInfo2(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public btConstraintInfo2(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public btConstraintInfo2 position(long position) {
	        return (btConstraintInfo2)super.position(position);
	    }
	    @Override public btConstraintInfo2 getPointer(long i) {
	        return new btConstraintInfo2((Pointer)this).offsetAddress(i);
	    }
	
		// integrator parameters: frames per second (1/stepsize), default error
		// reduction parameter (0..1).
		public native @Cast("btScalar") double fps(); public native btConstraintInfo2 fps(double setter);
		public native @Cast("btScalar") double erp(); public native btConstraintInfo2 erp(double setter);

		// for the first and second body, pointers to two (linear and angular)
		// n*3 jacobian sub matrices, stored by rows. these matrices will have
		// been initialized to 0 on entry. if the second body is zero then the
		// J2xx pointers may be 0.
		public native @Cast("btScalar*") DoublePointer m_J1linearAxis(); public native btConstraintInfo2 m_J1linearAxis(DoublePointer setter);
		public native @Cast("btScalar*") DoublePointer m_J1angularAxis(); public native btConstraintInfo2 m_J1angularAxis(DoublePointer setter);
		public native @Cast("btScalar*") DoublePointer m_J2linearAxis(); public native btConstraintInfo2 m_J2linearAxis(DoublePointer setter);
		public native @Cast("btScalar*") DoublePointer m_J2angularAxis(); public native btConstraintInfo2 m_J2angularAxis(DoublePointer setter);

		// elements to jump from one row to the next in J's
		public native int rowskip(); public native btConstraintInfo2 rowskip(int setter);

		// right hand sides of the equation J*v = c + cfm * lambda. cfm is the
		// "constraint force mixing" vector. c is set to zero on entry, cfm is
		// set to a constant value (typically very small or zero) value on entry.
		public native @Cast("btScalar*") DoublePointer m_constraintError(); public native btConstraintInfo2 m_constraintError(DoublePointer setter);
		public native @Cast("btScalar*") DoublePointer cfm(); public native btConstraintInfo2 cfm(DoublePointer setter);

		// lo and hi limits for variables (set to -/+ infinity on entry).
		public native @Cast("btScalar*") DoublePointer m_lowerLimit(); public native btConstraintInfo2 m_lowerLimit(DoublePointer setter);
		public native @Cast("btScalar*") DoublePointer m_upperLimit(); public native btConstraintInfo2 m_upperLimit(DoublePointer setter);

		// number of solver iterations
		public native int m_numIterations(); public native btConstraintInfo2 m_numIterations(int setter);

		//damping of the velocity
		public native @Cast("btScalar") double m_damping(); public native btConstraintInfo2 m_damping(double setter);
	}

	public native int getOverrideNumSolverIterations();

	/**override the number of constraint solver iterations used to solve this constraint
	 * -1 will use the default number of iterations, as specified in SolverInfo.m_numIterations */
	public native void setOverrideNumSolverIterations(int overideNumIterations);

	/**internal method used by the constraint solver, don't use them directly */
	public native void buildJacobian();

	/**internal method used by the constraint solver, don't use them directly */
	public native void setupSolverConstraint(@ByRef btSolverConstraintArray ca, int solverBodyA, int solverBodyB, @Cast("btScalar") double timeStep);

	/**internal method used by the constraint solver, don't use them directly */
	public native void getInfo1(btConstraintInfo1 info);

	/**internal method used by the constraint solver, don't use them directly */
	public native void getInfo2(btConstraintInfo2 info);

	/**internal method used by the constraint solver, don't use them directly */
	public native void internalSetAppliedImpulse(@Cast("btScalar") double appliedImpulse);
	/**internal method used by the constraint solver, don't use them directly */
	public native @Cast("btScalar") double internalGetAppliedImpulse();

	public native @Cast("btScalar") double getBreakingImpulseThreshold();

	public native void setBreakingImpulseThreshold(@Cast("btScalar") double threshold);

	public native @Cast("bool") boolean isEnabled();

	public native void setEnabled(@Cast("bool") boolean enabled);

	/**internal method used by the constraint solver, don't use them directly */
	public native void solveConstraintObsolete(@ByRef btSolverBody arg0, @ByRef btSolverBody arg1, @Cast("btScalar") double arg2);

	public native @ByRef btRigidBody getRigidBodyA();
	public native @ByRef btRigidBody getRigidBodyB();

	public native int getUserConstraintType();

	public native void setUserConstraintType(int userConstraintType);

	public native void setUserConstraintId(int uid);

	public native int getUserConstraintId();

	public native void setUserConstraintPtr(Pointer ptr);

	public native Pointer getUserConstraintPtr();

	public native void setJointFeedback(btJointFeedback jointFeedback);

	public native btJointFeedback getJointFeedback();

	public native int getUid();

	public native @Cast("bool") boolean needsFeedback();

	/**enableFeedback will allow to read the applied linear and angular impulse
	 * use getAppliedImpulse, getAppliedLinearImpulse and getAppliedAngularImpulse to read feedback information */
	public native void enableFeedback(@Cast("bool") boolean needsFeedback);

	/**getAppliedImpulse is an estimated total applied impulse.
	 * This feedback could be used to determine breaking constraints or playing sounds. */
	public native @Cast("btScalar") double getAppliedImpulse();

	public native @Cast("btTypedConstraintType") int getConstraintType();

	public native void setDbgDrawSize(@Cast("btScalar") double dbgDrawSize);
	public native @Cast("btScalar") double getDbgDrawSize();

	/**override the default global value of a parameter (such as ERP or CFM), optionally provide the axis (0..5).
	 * If no axis is provided, it uses the default axis for this constraint. */
	public native void setParam(int num, @Cast("btScalar") double value, int axis/*=-1*/);
	public native void setParam(int num, @Cast("btScalar") double value);

	/**return the local value of parameter */
	public native @Cast("btScalar") double getParam(int num, int axis/*=-1*/);
	public native @Cast("btScalar") double getParam(int num);

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);
}
