// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.BulletCollision.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

public class BulletCollision extends org.bytedeco.bullet.presets.BulletCollision {
    static { Loader.load(); }

// Parsed from LinearMath/btAlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBJECT_ARRAY__
// #define BT_OBJECT_ARRAY__

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE
// #include "btAlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable BT_USE_PLACEMENT_NEW
 * then the btAlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable BT_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int BT_USE_PLACEMENT_NEW = 1;
//#define BT_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define BT_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef BT_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //BT_USE_MEMCPY

// #ifdef BT_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\BulletCollision\BT_QUANTIZED_BVH_NODE_Array.java


// Targeting ..\BulletCollision\GIM_BVH_DATA_Array_.java


// Targeting ..\BulletCollision\GIM_BVH_TREE_NODE_Array_.java


// Targeting ..\BulletCollision\GIM_CONTACT_Array_.java


// Targeting ..\BulletCollision\GIM_PAIR_Array_.java


// Targeting ..\BulletCollision\btCell32ArrayArray.java


// Targeting ..\BulletCollision\btBvhSubtreeInfoArray.java


// Targeting ..\BulletCollision\btCell32Array.java


// Targeting ..\BulletCollision\btCollisionObjectArray.java


// Targeting ..\BulletCollision\btDbvtStkNNArray.java


// Targeting ..\BulletCollision\btDbvtStkNPSArray.java


// Targeting ..\BulletCollision\btFaceArray.java


// Targeting ..\BulletCollision\btIndexedMeshArray.java


// Targeting ..\BulletCollision\btPersistentManifoldArray.java


// Targeting ..\BulletCollision\btQuantizedBvhNodeArray.java



// #endif  //BT_OBJECT_ARRAY__


// Parsed from BulletCollision/BroadphaseCollision/btAxisSweep3.h

//Bullet Continuous Collision Detection and Physics Library
//Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

//
// btAxisSweep3.h
//
// Copyright (c) 2006 Simon Hobbs
//
// This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held liable for any damages arising from the use of this software.
//
// Permission is granted to anyone to use this software for any purpose, including commercial applications, and to alter it and redistribute it freely, subject to the following restrictions:
//
// 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
//
// 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
//
// 3. This notice may not be removed or altered from any source distribution.

// #ifndef BT_AXIS_SWEEP_3_H
// #define BT_AXIS_SWEEP_3_H

// #include "LinearMath/btVector3.h"
// #include "btOverlappingPairCache.h"
// #include "btBroadphaseInterface.h"
// #include "btBroadphaseProxy.h"
// #include "btOverlappingPairCallback.h"
// #include "btDbvtBroadphase.h"
// #include "btAxisSweep3Internal.h"
// Targeting ..\BulletCollision\btAxisSweep3.java


// Targeting ..\BulletCollision\bt32BitAxisSweep3.java



// #endif


// Parsed from BulletCollision/BroadphaseCollision/btBroadphaseInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BROADPHASE_INTERFACE_H
// #define BT_BROADPHASE_INTERFACE_H
// #include "btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btBroadphaseAabbCallback.java


// Targeting ..\BulletCollision\btBroadphaseRayCallback.java



// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btBroadphaseInterface.java



// #endif  //BT_BROADPHASE_INTERFACE_H


// Parsed from BulletCollision/BroadphaseCollision/btBroadphaseProxy.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BROADPHASE_PROXY_H
// #define BT_BROADPHASE_PROXY_H

// #include "LinearMath/btScalar.h"  //for SIMD_FORCE_INLINE
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAlignedAllocator.h"

/** btDispatcher uses these types
 *  IMPORTANT NOTE:The types are ordered polyhedral, implicit convex and concave
 *  to facilitate type checking
 *  CUSTOM_POLYHEDRAL_SHAPE_TYPE,CUSTOM_CONVEX_SHAPE_TYPE and CUSTOM_CONCAVE_SHAPE_TYPE can be used to extend Bullet without modifying source code */
/** enum BroadphaseNativeTypes */
public static final int
	// polyhedral convex shapes
	BOX_SHAPE_PROXYTYPE = 0,
	TRIANGLE_SHAPE_PROXYTYPE = 1,
	TETRAHEDRAL_SHAPE_PROXYTYPE = 2,
	CONVEX_TRIANGLEMESH_SHAPE_PROXYTYPE = 3,
	CONVEX_HULL_SHAPE_PROXYTYPE = 4,
	CONVEX_POINT_CLOUD_SHAPE_PROXYTYPE = 5,
	CUSTOM_POLYHEDRAL_SHAPE_TYPE = 6,
	//implicit convex shapes
	IMPLICIT_CONVEX_SHAPES_START_HERE = 7,
	SPHERE_SHAPE_PROXYTYPE = 8,
	MULTI_SPHERE_SHAPE_PROXYTYPE = 9,
	CAPSULE_SHAPE_PROXYTYPE = 10,
	CONE_SHAPE_PROXYTYPE = 11,
	CONVEX_SHAPE_PROXYTYPE = 12,
	CYLINDER_SHAPE_PROXYTYPE = 13,
	UNIFORM_SCALING_SHAPE_PROXYTYPE = 14,
	MINKOWSKI_SUM_SHAPE_PROXYTYPE = 15,
	MINKOWSKI_DIFFERENCE_SHAPE_PROXYTYPE = 16,
	BOX_2D_SHAPE_PROXYTYPE = 17,
	CONVEX_2D_SHAPE_PROXYTYPE = 18,
	CUSTOM_CONVEX_SHAPE_TYPE = 19,
	//concave shapes
	CONCAVE_SHAPES_START_HERE = 20,
	//keep all the convex shapetype below here, for the check IsConvexShape in broadphase proxy!
	TRIANGLE_MESH_SHAPE_PROXYTYPE = 21,
	SCALED_TRIANGLE_MESH_SHAPE_PROXYTYPE = 22,
	/**used for demo integration FAST/Swift collision library and Bullet */
	FAST_CONCAVE_MESH_PROXYTYPE = 23,
	//terrain
	TERRAIN_SHAPE_PROXYTYPE = 24,
	/**Used for GIMPACT Trimesh integration */
	GIMPACT_SHAPE_PROXYTYPE = 25,
	/**Multimaterial mesh */
	MULTIMATERIAL_TRIANGLE_MESH_PROXYTYPE = 26,

	EMPTY_SHAPE_PROXYTYPE = 27,
	STATIC_PLANE_PROXYTYPE = 28,
	CUSTOM_CONCAVE_SHAPE_TYPE = 29,
	SDF_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE,
	CONCAVE_SHAPES_END_HERE = CUSTOM_CONCAVE_SHAPE_TYPE + 1,

	COMPOUND_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE + 2,

	SOFTBODY_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE + 3,
	HFFLUID_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE + 4,
	HFFLUID_BUOYANT_CONVEX_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE + 5,
	INVALID_SHAPE_PROXYTYPE = CUSTOM_CONCAVE_SHAPE_TYPE + 6,

	MAX_BROADPHASE_COLLISION_TYPES = CUSTOM_CONCAVE_SHAPE_TYPE + 7;
// Targeting ..\BulletCollision\btBroadphaseProxy.java


// Targeting ..\BulletCollision\btBroadphasePair.java


// Targeting ..\BulletCollision\btBroadphasePairSortPredicate.java



public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef btBroadphasePair a, @Const @ByRef btBroadphasePair b);

// #endif  //BT_BROADPHASE_PROXY_H


// Parsed from BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_ALGORITHM_H
// #define BT_COLLISION_ALGORITHM_H

// #include "LinearMath/btScalar.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btCollisionAlgorithmConstructionInfo.java


// Targeting ..\BulletCollision\btCollisionAlgorithm.java



// #endif  //BT_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/BroadphaseCollision/btDbvt.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2007 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**btDbvt implementation by Nathanael Presson */

// #ifndef BT_DYNAMIC_BOUNDING_VOLUME_TREE_H
// #define BT_DYNAMIC_BOUNDING_VOLUME_TREE_H

// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btAabbUtil2.h"
//
// Compile time configuration
//

// Implementation profiles
public static final int DBVT_IMPL_GENERIC = 0;  // Generic implementation
public static final int DBVT_IMPL_SSE = 1;      // SSE

// Template implementation of ICollide
// #ifdef _WIN32
// #else
public static final int DBVT_USE_TEMPLATE = 0;
// #endif

// Use only intrinsics instead of inline asm
public static final int DBVT_USE_INTRINSIC_SSE = 1;

// Using memmov for collideOCL
public static final int DBVT_USE_MEMMOVE = 1;

// Enable benchmarking code
public static final int DBVT_ENABLE_BENCHMARK = 0;

// Inlining
// #define DBVT_INLINE SIMD_FORCE_INLINE

// Specific methods implementation

//SSE gives errors on a MSVC 7.1
// #if defined(BT_USE_SSE)  //&& defined (_WIN32)
// #else
public static final int DBVT_SELECT_IMPL = DBVT_IMPL_GENERIC;
public static final int DBVT_MERGE_IMPL = DBVT_IMPL_GENERIC;
public static final int DBVT_INT0_IMPL = DBVT_IMPL_GENERIC;
// #endif

// #if (DBVT_SELECT_IMPL == DBVT_IMPL_SSE) ||
// 	(DBVT_MERGE_IMPL == DBVT_IMPL_SSE) ||
// 	(DBVT_INT0_IMPL == DBVT_IMPL_SSE)
// #include <emmintrin.h>
// #endif

//
// Auto config and checks
//

// #if DBVT_USE_TEMPLATE
// #define DBVT_VIRTUAL
// #define DBVT_VIRTUAL_DTOR(a)
// #define DBVT_PREFIX template <typename T>
// #define DBVT_IPOLICY T& policy
// #define DBVT_CHECKTYPE
// 	static const ICollide& typechecker = *(T*)1;
// 	(void)typechecker;
// #else
// #endif

// #if DBVT_USE_MEMMOVE
// #if !defined(__CELLOS_LV2__) && !defined(__MWERKS__)
// #include <memory.h>
// #endif
// #include <string.h>
// Targeting ..\BulletCollision\btDbvtAabbMm.java



// Types
// Targeting ..\BulletCollision\btDbvtNode.java


// Targeting ..\BulletCollision\btDbvntNode.java


// Targeting ..\BulletCollision\btDbvt.java



//
// Inline's
//

//


//


//


//


//


//


//


//


//


//


//


//
public static native @Cast("bool") boolean Intersect(@Const @ByRef btDbvtAabbMm a,
						   @Const @ByRef btDbvtAabbMm b);

//
public static native @Cast("bool") boolean Intersect(@Const @ByRef btDbvtAabbMm a,
						   @Const @ByRef btVector3 b);

//////////////////////////////////////

//
public static native @Cast("btScalar") double Proximity(@Const @ByRef btDbvtAabbMm a,
							   @Const @ByRef btDbvtAabbMm b);

//
public static native int Select(@Const @ByRef btDbvtAabbMm o,
					   @Const @ByRef btDbvtAabbMm a,
					   @Const @ByRef btDbvtAabbMm b);

//
public static native void Merge(@Const @ByRef btDbvtAabbMm a,
					   @Const @ByRef btDbvtAabbMm b,
					   @ByRef btDbvtAabbMm r);

//
public static native @Cast("bool") boolean NotEqual(@Const @ByRef btDbvtAabbMm a,
						  @Const @ByRef btDbvtAabbMm b);

//
// Inline's
//

//


//


//


//


//





// #if 0
// #endif



//




//


//


//


//


//
// PP Cleanup
//

// #undef DBVT_USE_MEMMOVE
// #undef DBVT_USE_TEMPLATE
// #undef DBVT_VIRTUAL_DTOR
// #undef DBVT_VIRTUAL
// #undef DBVT_PREFIX
// #undef DBVT_IPOLICY
// #undef DBVT_CHECKTYPE
// #undef DBVT_IMPL_GENERIC
// #undef DBVT_IMPL_SSE
// #undef DBVT_USE_INTRINSIC_SSE
// #undef DBVT_SELECT_IMPL
// #undef DBVT_MERGE_IMPL
// #undef DBVT_INT0_IMPL

// #endif


// Parsed from BulletCollision/BroadphaseCollision/btDbvtBroadphase.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**btDbvtBroadphase implementation by Nathanael Presson */
// #ifndef BT_DBVT_BROADPHASE_H
// #define BT_DBVT_BROADPHASE_H

// #include "BulletCollision/BroadphaseCollision/btDbvt.h"
// #include "BulletCollision/BroadphaseCollision/btOverlappingPairCache.h"

//
// Compile time config
//

public static native @MemberGetter int DBVT_BP_PROFILE();
public static final int DBVT_BP_PROFILE = DBVT_BP_PROFILE();
//#define DBVT_BP_SORTPAIRS				1
public static final int DBVT_BP_PREVENTFALSEUPDATE = 0;
public static final int DBVT_BP_ACCURATESLEEPING = 0;
public static final int DBVT_BP_ENABLE_BENCHMARK = 0;
//#define DBVT_BP_MARGIN					(btScalar)0.05
public static native @Cast("btScalar") double gDbvtMargin(); public static native void gDbvtMargin(double setter);
// Targeting ..\BulletCollision\btDbvtProxy.java


// Targeting ..\BulletCollision\btDbvtBroadphase.java



// #endif


// Parsed from BulletCollision/BroadphaseCollision/btDispatcher.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DISPATCHER_H
// #define BT_DISPATCHER_H
// #include "LinearMath/btScalar.h"
// Targeting ..\BulletCollision\btDispatcherInfo.java



/** enum ebtDispatcherQueryType */
public static final int
	BT_CONTACT_POINT_ALGORITHMS = 1,
	BT_CLOSEST_POINT_ALGORITHMS = 2;
// Targeting ..\BulletCollision\btDispatcher.java



// #endif  //BT_DISPATCHER_H


// Parsed from BulletCollision/BroadphaseCollision/btOverlappingPairCache.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OVERLAPPING_PAIR_CACHE_H
// #define BT_OVERLAPPING_PAIR_CACHE_H

// #include "btBroadphaseInterface.h"
// #include "btBroadphaseProxy.h"
// #include "btOverlappingPairCallback.h"

// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btOverlapCallback.java


// Targeting ..\BulletCollision\btOverlapFilterCallback.java



@MemberGetter public static native int BT_NULL_PAIR();
// Targeting ..\BulletCollision\btOverlappingPairCache.java


// Targeting ..\BulletCollision\btHashedOverlappingPairCache.java


// Targeting ..\BulletCollision\btSortedOverlappingPairCache.java


// Targeting ..\BulletCollision\btNullPairCache.java



// #endif  //BT_OVERLAPPING_PAIR_CACHE_H


// Parsed from BulletCollision/BroadphaseCollision/btOverlappingPairCallback.h


/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef OVERLAPPING_PAIR_CALLBACK_H
// #define OVERLAPPING_PAIR_CALLBACK_H
// Targeting ..\BulletCollision\btOverlappingPairCallback.java



// #endif  //OVERLAPPING_PAIR_CALLBACK_H


// Parsed from BulletCollision/BroadphaseCollision/btQuantizedBvh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_QUANTIZED_BVH_H
// #define BT_QUANTIZED_BVH_H

//#define DEBUG_CHECK_DEQUANTIZATION 1
// #ifdef DEBUG_CHECK_DEQUANTIZATION
// #ifdef __SPU__
// #endif  //__SPU__

// #include <stdio.h>
// #include <stdlib.h>
// #endif  //DEBUG_CHECK_DEQUANTIZATION

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAlignedAllocator.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btQuantizedBvhData btQuantizedBvhDoubleData
// #define btOptimizedBvhNodeData btOptimizedBvhNodeDoubleData
public static final String btQuantizedBvhDataName = "btQuantizedBvhDoubleData";
// #else
// #endif

//http://msdn.microsoft.com/library/default.asp?url=/library/en-us/vclang/html/vclrf__m128.asp

//Note: currently we have 16 bytes per quantized node
public static final int MAX_SUBTREE_SIZE_IN_BYTES = 2048;

// 10 gives the potential for 1024 parts, with at most 2^21 (2097152) (minus one
// actually) triangles each (since the sign bit is reserved
public static final int MAX_NUM_PARTS_IN_BITS = 10;
// Targeting ..\BulletCollision\btQuantizedBvhNode.java


// Targeting ..\BulletCollision\btOptimizedBvhNode.java


// Targeting ..\BulletCollision\btBvhSubtreeInfo.java


// Targeting ..\BulletCollision\btNodeOverlapCallback.java



// #include "LinearMath/btAlignedAllocator.h"
// #include "LinearMath/btAlignedObjectArray.h"

/**for code readability: */
// Targeting ..\BulletCollision\btQuantizedBvh.java


// Targeting ..\BulletCollision\btBvhSubtreeInfoData.java


// Targeting ..\BulletCollision\btOptimizedBvhNodeFloatData.java


// Targeting ..\BulletCollision\btOptimizedBvhNodeDoubleData.java


// Targeting ..\BulletCollision\btQuantizedBvhNodeData.java


// Targeting ..\BulletCollision\btQuantizedBvhFloatData.java


// Targeting ..\BulletCollision\btQuantizedBvhDoubleData.java


// clang-format on



// #endif  //BT_QUANTIZED_BVH_H


// Parsed from BulletCollision/BroadphaseCollision/btSimpleBroadphase.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMPLE_BROADPHASE_H
// #define BT_SIMPLE_BROADPHASE_H

// #include "btOverlappingPairCache.h"
// Targeting ..\BulletCollision\btSimpleBroadphaseProxy.java


// Targeting ..\BulletCollision\btSimpleBroadphase.java



// #endif  //BT_SIMPLE_BROADPHASE_H


// Parsed from BulletCollision/NarrowPhaseCollision/btComputeGjkEpaPenetration.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2014 Erwin Coumans http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GJK_EPA_PENETATION_CONVEX_COLLISION_H
// #define BT_GJK_EPA_PENETATION_CONVEX_COLLISION_H

// #include "LinearMath/btTransform.h"  // Note that btVector3 might be double precision...
// #include "btGjkEpa3.h"
// #include "btGjkCollisionDescription.h"
// #include "BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h"

// #endif  //BT_GJK_EPA_PENETATION_CONVEX_COLLISION_H


// Parsed from BulletCollision/NarrowPhaseCollision/btContinuousConvexCollision.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONTINUOUS_COLLISION_CONVEX_CAST_H
// #define BT_CONTINUOUS_COLLISION_CONVEX_CAST_H

// #include "btConvexCast.h"
// #include "btSimplexSolverInterface.h"
// Targeting ..\BulletCollision\btContinuousConvexCollision.java



// #endif  //BT_CONTINUOUS_COLLISION_CONVEX_CAST_H


// Parsed from BulletCollision/NarrowPhaseCollision/btConvexCast.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_CAST_H
// #define BT_CONVEX_CAST_H

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btScalar.h"
// #include "LinearMath/btIDebugDraw.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define MAX_CONVEX_CAST_ITERATIONS 64
// #define MAX_CONVEX_CAST_EPSILON (SIMD_EPSILON * 10)
// Targeting ..\BulletCollision\btConvexCast.java



// #endif  //BT_CONVEX_CAST_H


// Parsed from BulletCollision/NarrowPhaseCollision/btConvexPenetrationDepthSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_PENETRATION_DEPTH_H
// #define BT_CONVEX_PENETRATION_DEPTH_H
// #include "btSimplexSolverInterface.h"
// Targeting ..\BulletCollision\btConvexPenetrationDepthSolver.java


// #endif  //BT_CONVEX_PENETRATION_DEPTH_H


// Parsed from BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DISCRETE_COLLISION_DETECTOR1_INTERFACE_H
// #define BT_DISCRETE_COLLISION_DETECTOR1_INTERFACE_H

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btDiscreteCollisionDetectorInterface.java


// Targeting ..\BulletCollision\btStorageResult.java



// #endif  //BT_DISCRETE_COLLISION_DETECTOR1_INTERFACE_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkCollisionDescription.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2014 Erwin Coumans http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef GJK_COLLISION_DESCRIPTION_H
// #define GJK_COLLISION_DESCRIPTION_H

// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btGjkCollisionDescription.java



// #endif  //GJK_COLLISION_DESCRIPTION_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkConvexCast.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GJK_CONVEX_CAST_H
// #define BT_GJK_CONVEX_CAST_H

// #include "BulletCollision/CollisionShapes/btCollisionMargin.h"

// #include "LinearMath/btVector3.h"
// #include "btConvexCast.h"
// #include "btSimplexSolverInterface.h"
// Targeting ..\BulletCollision\btGjkConvexCast.java



// #endif  //BT_GJK_CONVEX_CAST_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkEpa2.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the
use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software in a
product, an acknowledgment in the product documentation would be appreciated
but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
GJK-EPA collision solver by Nathanael Presson, 2008
*/
// #ifndef BT_GJK_EPA2_H
// #define BT_GJK_EPA2_H

// #include "BulletCollision/CollisionShapes/btConvexShape.h"
// Targeting ..\BulletCollision\btGjkEpaSolver2.java



// #endif  //BT_GJK_EPA2_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkEpa3.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2014 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the
use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not
claim that you wrote the original software. If you use this software in a
product, an acknowledgment in the product documentation would be appreciated
but is not required.
2. Altered source versions must be plainly marked as such, and must not be
misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
Initial GJK-EPA collision solver by Nathanael Presson, 2008
Improvements and refactoring by Erwin Coumans, 2008-2014
*/
// #ifndef BT_GJK_EPA3_H
// #define BT_GJK_EPA3_H

// #include "LinearMath/btTransform.h"
// #include "btGjkCollisionDescription.h"
// Targeting ..\BulletCollision\btGjkEpaSolver3.java



// #if defined(DEBUG) || defined(_DEBUG)
// #include <stdio.h>  //for debug printf
// #ifdef __SPU__
// #endif  //__SPU__
// #endif

// Config

/* GJK	*/
public static final int GJK_MAX_ITERATIONS = 128;
public static final double GJK_ACCURARY = ((double)0.0001);
public static final double GJK_MIN_DISTANCE = ((double)0.0001);
public static final double GJK_DUPLICATED_EPS = ((double)0.0001);
public static final double GJK_SIMPLEX2_EPS = ((double)0.0);
public static final double GJK_SIMPLEX3_EPS = ((double)0.0);
public static final double GJK_SIMPLEX4_EPS = ((double)0.0);

/* EPA	*/
public static final int EPA_MAX_VERTICES = 64;
public static final int EPA_MAX_FACES = (EPA_MAX_VERTICES * 2);
public static final int EPA_MAX_ITERATIONS = 255;
public static final double EPA_ACCURACY = ((double)0.0001);
public static final double EPA_FALLBACK = (10 * EPA_ACCURACY);
public static final double EPA_PLANE_EPS = ((double)0.00001);
public static final double EPA_INSIDE_EPS = ((double)0.01);

// Shorthands

// MinkowskiDiff

/** enum eGjkStatus */
public static final int
	eGjkValid = 0,
	eGjkInside = 1,
	eGjkFailed = 2;

// GJK

/** enum eEpaStatus */
public static final int
	eEpaValid = 0,
	eEpaTouching = 1,
	eEpaDegenerated = 2,
	eEpaNonConvex = 3,
	eEpaInvalidHull = 4,
	eEpaOutOfFaces = 5,
	eEpaOutOfVertices = 6,
	eEpaAccuraryReached = 7,
	eEpaFallBack = 8,
	eEpaFailed = 9;

// EPA

//
// Api
//

//

// #if 0
// #endif

/* Symbols cleanup		*/

// #undef GJK_MAX_ITERATIONS
// #undef GJK_ACCURARY
// #undef GJK_MIN_DISTANCE
// #undef GJK_DUPLICATED_EPS
// #undef GJK_SIMPLEX2_EPS
// #undef GJK_SIMPLEX3_EPS
// #undef GJK_SIMPLEX4_EPS

// #undef EPA_MAX_VERTICES
// #undef EPA_MAX_FACES
// #undef EPA_MAX_ITERATIONS
// #undef EPA_ACCURACY
// #undef EPA_FALLBACK
// #undef EPA_PLANE_EPS
// #undef EPA_INSIDE_EPS

// #endif  //BT_GJK_EPA3_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkEpaPenetrationDepthSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

EPA Copyright (c) Ricardo Padrela 2006 

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef BT_GJP_EPA_PENETRATION_DEPTH_H
// #define BT_GJP_EPA_PENETRATION_DEPTH_H

// #include "btConvexPenetrationDepthSolver.h"
// Targeting ..\BulletCollision\btGjkEpaPenetrationDepthSolver.java



// #endif  // BT_GJP_EPA_PENETRATION_DEPTH_H


// Parsed from BulletCollision/NarrowPhaseCollision/btGjkPairDetector.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GJK_PAIR_DETECTOR_H
// #define BT_GJK_PAIR_DETECTOR_H

// #include "btDiscreteCollisionDetectorInterface.h"
// #include "BulletCollision/CollisionShapes/btCollisionMargin.h"
// #include "btSimplexSolverInterface.h"
// Targeting ..\BulletCollision\btGjkPairDetector.java



// #endif  //BT_GJK_PAIR_DETECTOR_H


// Parsed from BulletCollision/NarrowPhaseCollision/btManifoldPoint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MANIFOLD_CONTACT_POINT_H
// #define BT_MANIFOLD_CONTACT_POINT_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransformUtil.h"
// Targeting ..\BulletCollision\btConstraintRow.java


// #endif  //PFX_USE_FREE_VECTORMATH

/** enum btContactPointFlags */
public static final int
	BT_CONTACT_FLAG_LATERAL_FRICTION_INITIALIZED = 1,
	BT_CONTACT_FLAG_HAS_CONTACT_CFM = 2,
	BT_CONTACT_FLAG_HAS_CONTACT_ERP = 4,
	BT_CONTACT_FLAG_CONTACT_STIFFNESS_DAMPING = 8,
	BT_CONTACT_FLAG_FRICTION_ANCHOR = 16;
// Targeting ..\BulletCollision\btManifoldPoint.java



// #endif  //BT_MANIFOLD_CONTACT_POINT_H


// Parsed from BulletCollision/NarrowPhaseCollision/btMinkowskiPenetrationDepthSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MINKOWSKI_PENETRATION_DEPTH_SOLVER_H
// #define BT_MINKOWSKI_PENETRATION_DEPTH_SOLVER_H

// #include "btConvexPenetrationDepthSolver.h"
// Targeting ..\BulletCollision\btMinkowskiPenetrationDepthSolver.java



// #endif  //BT_MINKOWSKI_PENETRATION_DEPTH_SOLVER_H


// Parsed from BulletCollision/NarrowPhaseCollision/btMprPenetration.h


/***
 * ---------------------------------
 * Copyright (c)2012 Daniel Fiser <danfis\danfis.cz>
 *
 *  This file was ported from mpr.c file, part of libccd.
 *  The Minkoski Portal Refinement implementation was ported 
 *  to OpenCL by Erwin Coumans for the Bullet 3 Physics library.
 *  The original MPR idea and implementation is by Gary Snethen
 *  in XenoCollide, see http://github.com/erwincoumans/xenocollide
 *
 *  Distributed under the OSI-approved BSD License (the "License");
 *  see <http://www.opensource.org/licenses/bsd-license.php>.
 *  This software is distributed WITHOUT ANY WARRANTY; without even the
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the License for more information.
 */

/**2014 Oct, Erwin Coumans, Use templates to avoid void* casts */

// #ifndef BT_MPR_PENETRATION_H
// #define BT_MPR_PENETRATION_H

// #define BT_DEBUG_MPR1

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btMprCollisionDescription.java


// Targeting ..\BulletCollision\btMprDistanceInfo.java



// #ifdef __cplusplus
// #define BT_MPR_SQRT sqrtf
// #else
// #define BT_MPR_SQRT sqrt
// #endif
// #define BT_MPR_FMIN(x, y) ((x) < (y) ? (x) : (y))
// #define BT_MPR_FABS fabs

public static final double BT_MPR_TOLERANCE = 1E-6f;
public static final int BT_MPR_MAX_ITERATIONS = 1000;
// Targeting ..\BulletCollision\_btMprSupport_t.java


// Targeting ..\BulletCollision\btMprSupport_t.java


// Targeting ..\BulletCollision\_btMprSimplex_t.java


// Targeting ..\BulletCollision\btMprSimplex_t.java



public static native btMprSupport_t btMprSimplexPointW(btMprSimplex_t s, int idx);

public static native void btMprSimplexSetSize(btMprSimplex_t s, int size);

// #ifdef DEBUG_MPR
// #endif  //DEBUG_MPR

public static native int btMprSimplexSize(@Const btMprSimplex_t s);

public static native @Const btMprSupport_t btMprSimplexPoint(@Const btMprSimplex_t s, int idx);

public static native void btMprSupportCopy(btMprSupport_t d, @Const btMprSupport_t s);

public static native void btMprSimplexSet(btMprSimplex_t s, @Cast("size_t") long pos, @Const btMprSupport_t a);

public static native void btMprSimplexSwap(btMprSimplex_t s, @Cast("size_t") long pos1, @Cast("size_t") long pos2);

public static native int btMprIsZero(float val);

public static native int btMprEq(float _a, float _b);

public static native int btMprVec3Eq(@Const btVector3 a, @Const btVector3 b);

public static native void btMprVec3Set(btVector3 v, float x, float y, float z);

public static native void btMprVec3Add(btVector3 v, @Const btVector3 w);

public static native void btMprVec3Copy(btVector3 v, @Const btVector3 w);

public static native void btMprVec3Scale(btVector3 d, float k);

public static native float btMprVec3Dot(@Const btVector3 a, @Const btVector3 b);

public static native float btMprVec3Len2(@Const btVector3 v);

public static native void btMprVec3Normalize(btVector3 d);

public static native void btMprVec3Cross(btVector3 d, @Const btVector3 a, @Const btVector3 b);

public static native void btMprVec3Sub2(btVector3 d, @Const btVector3 v, @Const btVector3 w);

public static native void btPortalDir(@Const btMprSimplex_t portal, btVector3 dir);

public static native int portalEncapsulesOrigin(@Const btMprSimplex_t portal,
								  @Const btVector3 dir);

public static native int portalReachTolerance(@Const btMprSimplex_t portal,
								@Const btMprSupport_t v4,
								@Const btVector3 dir);

public static native int portalCanEncapsuleOrigin(@Const btMprSimplex_t portal,
									@Const btMprSupport_t v4,
									@Const btVector3 dir);

public static native void btExpandPortal(btMprSimplex_t portal,
						   @Const btMprSupport_t v4);

public static native void btFindPos(@Const btMprSimplex_t portal, btVector3 pos);

public static native float btMprVec3Dist2(@Const btVector3 a, @Const btVector3 b);

public static native float _btMprVec3PointSegmentDist2(@Const btVector3 P,
										 @Const btVector3 x0,
										 @Const btVector3 b,
										 btVector3 witness);

public static native float btMprVec3PointTriDist2(@Const btVector3 P,
									@Const btVector3 x0, @Const btVector3 B,
									@Const btVector3 C,
									btVector3 witness);

public static native void btFindPenetrTouch(btMprSimplex_t portal, FloatPointer depth, btVector3 dir, btVector3 pos);
public static native void btFindPenetrTouch(btMprSimplex_t portal, FloatBuffer depth, btVector3 dir, btVector3 pos);
public static native void btFindPenetrTouch(btMprSimplex_t portal, float[] depth, btVector3 dir, btVector3 pos);

public static native void btFindPenetrSegment(btMprSimplex_t portal,
								FloatPointer depth, btVector3 dir, btVector3 pos);
public static native void btFindPenetrSegment(btMprSimplex_t portal,
								FloatBuffer depth, btVector3 dir, btVector3 pos);
public static native void btFindPenetrSegment(btMprSimplex_t portal,
								float[] depth, btVector3 dir, btVector3 pos);

// #endif  //BT_MPR_PENETRATION_H


// Parsed from BulletCollision/NarrowPhaseCollision/btPersistentManifold.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_PERSISTENT_MANIFOLD_H
// #define BT_PERSISTENT_MANIFOLD_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "btManifoldPoint.h"
// #include "LinearMath/btAlignedAllocator.h"

/**maximum contact breaking and merging threshold */
public static native @Cast("btScalar") double gContactBreakingThreshold(); public static native void gContactBreakingThreshold(double setter);
// Targeting ..\BulletCollision\ContactDestroyedCallback.java


// Targeting ..\BulletCollision\ContactProcessedCallback.java


// Targeting ..\BulletCollision\ContactStartedCallback.java


// Targeting ..\BulletCollision\ContactEndedCallback.java






// #endif  //SWIG

//the enum starts at 1024 to avoid type conflicts with btTypedConstraint
/** enum btContactManifoldTypes */
public static final int
	MIN_CONTACT_MANIFOLD_TYPE = 1024,
	BT_PERSISTENT_MANIFOLD_TYPE = 1025;

public static final int MANIFOLD_CACHE_SIZE = 4;
// Targeting ..\BulletCollision\btPersistentManifold.java


// Targeting ..\BulletCollision\btPersistentManifoldDoubleData.java


// Targeting ..\BulletCollision\btPersistentManifoldFloatData.java



// clang-format on

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btPersistentManifoldData btPersistentManifoldDoubleData
public static final String btPersistentManifoldDataName = "btPersistentManifoldDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

// #endif  //BT_PERSISTENT_MANIFOLD_H


// Parsed from BulletCollision/NarrowPhaseCollision/btPointCollector.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_POINT_COLLECTOR_H
// #define BT_POINT_COLLECTOR_H

// #include "btDiscreteCollisionDetectorInterface.h"
// Targeting ..\BulletCollision\btPointCollector.java



// #endif  //BT_POINT_COLLECTOR_H


// Parsed from BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2011 Advanced Micro Devices, Inc.  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_POLYHEDRAL_CONTACT_CLIPPING_H
// #define BT_POLYHEDRAL_CONTACT_CLIPPING_H

// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btTransform.h"
// #include "btDiscreteCollisionDetectorInterface.h"
// Targeting ..\BulletCollision\btPolyhedralContactClipping.java



// #endif  // BT_POLYHEDRAL_CONTACT_CLIPPING_H


// Parsed from BulletCollision/NarrowPhaseCollision/btRaycastCallback.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_RAYCAST_TRI_CALLBACK_H
// #define BT_RAYCAST_TRI_CALLBACK_H

// #include "BulletCollision/CollisionShapes/btTriangleCallback.h"
// #include "LinearMath/btTransform.h"
// Targeting ..\BulletCollision\btTriangleRaycastCallback.java


// Targeting ..\BulletCollision\btTriangleConvexcastCallback.java



// #endif  //BT_RAYCAST_TRI_CALLBACK_H


// Parsed from BulletCollision/NarrowPhaseCollision/btSimplexSolverInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMPLEX_SOLVER_INTERFACE_H
// #define BT_SIMPLEX_SOLVER_INTERFACE_H

// #include "LinearMath/btVector3.h"

public static native @MemberGetter int NO_VIRTUAL_INTERFACE();
public static final int NO_VIRTUAL_INTERFACE = NO_VIRTUAL_INTERFACE();
// Targeting ..\BulletCollision\btSimplexSolverInterface.java


// #endif
// #endif  //BT_SIMPLEX_SOLVER_INTERFACE_H


// Parsed from BulletCollision/NarrowPhaseCollision/btSubSimplexConvexCast.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SUBSIMPLEX_CONVEX_CAST_H
// #define BT_SUBSIMPLEX_CONVEX_CAST_H

// #include "btConvexCast.h"
// #include "btSimplexSolverInterface.h"
// Targeting ..\BulletCollision\btSubsimplexConvexCast.java



// #endif  //BT_SUBSIMPLEX_CONVEX_CAST_H


// Parsed from BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_VORONOI_SIMPLEX_SOLVER_H
// #define BT_VORONOI_SIMPLEX_SOLVER_H

// #include "btSimplexSolverInterface.h"

public static final int VORONOI_SIMPLEX_MAX_VERTS = 5;

/**disable next define, or use defaultCollisionConfiguration->getSimplexSolver()->setEqualVertexThreshold(0.f) to disable/configure */
// #define BT_USE_EQUAL_VERTEX_THRESHOLD

// #ifdef BT_USE_DOUBLE_PRECISION
public static final double VORONOI_DEFAULT_EQUAL_VERTEX_THRESHOLD = 1e-12f;
// Targeting ..\BulletCollision\btUsageBitfield.java


// Targeting ..\BulletCollision\btSubSimplexClosestResult.java


// Targeting ..\BulletCollision\btVoronoiSimplexSolver.java



// #endif  //BT_VORONOI_SIMPLEX_SOLVER_H


// Parsed from BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  http://bulletphysics.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef __BT_ACTIVATING_COLLISION_ALGORITHM_H
// #define __BT_ACTIVATING_COLLISION_ALGORITHM_H

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// Targeting ..\BulletCollision\btActivatingCollisionAlgorithm.java


// #endif  //__BT_ACTIVATING_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btBox2dBox2dCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BOX_2D_BOX_2D__COLLISION_ALGORITHM_H
// #define BT_BOX_2D_BOX_2D__COLLISION_ALGORITHM_H

// #include "BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// Targeting ..\BulletCollision\btBox2dBox2dCollisionAlgorithm.java



// #endif  //BT_BOX_2D_BOX_2D__COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btBoxBoxCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BOX_BOX__COLLISION_ALGORITHM_H
// #define BT_BOX_BOX__COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// Targeting ..\BulletCollision\btBoxBoxCollisionAlgorithm.java



// #endif  //BT_BOX_BOX__COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btBoxBoxDetector.h

/*
 * Box-Box collision detection re-distributed under the ZLib license with permission from Russell L. Smith
 * Original version is from Open Dynamics Engine, Copyright (C) 2001,2002 Russell L. Smith.
 * All rights reserved.  Email: russ@q12.org   Web: www.q12.org

Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef BT_BOX_BOX_DETECTOR_H
// #define BT_BOX_BOX_DETECTOR_H
// #include "BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h"
// Targeting ..\BulletCollision\btBoxBoxDetector.java



// #endif  //BT_BOX_BOX_DETECTOR_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionConfiguration.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_CONFIGURATION
// #define BT_COLLISION_CONFIGURATION
// Targeting ..\BulletCollision\btCollisionConfiguration.java



// #endif  //BT_COLLISION_CONFIGURATION


// Parsed from BulletCollision/CollisionDispatch/btCollisionCreateFunc.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_CREATE_FUNC
// #define BT_COLLISION_CREATE_FUNC

// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btCollisionAlgorithmCreateFunc.java


// #endif  //BT_COLLISION_CREATE_FUNC


// Parsed from BulletCollision/CollisionDispatch/btCollisionDispatcher.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION__DISPATCHER_H
// #define BT_COLLISION__DISPATCHER_H

// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"

// #include "BulletCollision/CollisionDispatch/btManifoldResult.h"

// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "LinearMath/btAlignedObjectArray.h"

// #include "btCollisionCreateFunc.h"

public static final int USE_DISPATCH_REGISTRY_ARRAY = 1;
// Targeting ..\BulletCollision\btNearCallback.java


// Targeting ..\BulletCollision\btCollisionDispatcher.java



// #endif  //BT_COLLISION__DISPATCHER_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionDispatcherMt.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_DISPATCHER_MT_H
// #define BT_COLLISION_DISPATCHER_MT_H

// #include "BulletCollision/CollisionDispatch/btCollisionDispatcher.h"
// #include "LinearMath/btThreads.h"
// Targeting ..\BulletCollision\btCollisionDispatcherMt.java



// #endif  //BT_COLLISION_DISPATCHER_MT_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionObject.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_OBJECT_H
// #define BT_COLLISION_OBJECT_H

// #include "LinearMath/btTransform.h"

//island management, m_activationState1
public static final int ACTIVE_TAG = 1;
public static final int ISLAND_SLEEPING = 2;
public static final int WANTS_DEACTIVATION = 3;
public static final int DISABLE_DEACTIVATION = 4;
public static final int DISABLE_SIMULATION = 5;
public static final int FIXED_BASE_MULTI_BODY = 6;
// #include "LinearMath/btMotionState.h"
// #include "LinearMath/btAlignedAllocator.h"
// #include "LinearMath/btAlignedObjectArray.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btCollisionObjectData btCollisionObjectDoubleData
public static final String btCollisionObjectDataName = "btCollisionObjectDoubleData";
// Targeting ..\BulletCollision\btCollisionObject.java


// Targeting ..\BulletCollision\btCollisionObjectDoubleData.java


// Targeting ..\BulletCollision\btCollisionObjectFloatData.java


// clang-format on



// #endif  //BT_COLLISION_OBJECT_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h

// #ifndef BT_COLLISION_OBJECT_WRAPPER_H
// #define BT_COLLISION_OBJECT_WRAPPER_H

/**btCollisionObjectWrapperis an internal data structure.
 * Most users can ignore this and use btCollisionObject and btCollisionShape instead */
// #include "LinearMath/btScalar.h"  // for SIMD_FORCE_INLINE definition

// #define BT_DECLARE_STACK_ONLY_OBJECT
// private:
// 	void* operator new(size_t size);
// 	void operator delete(void*);
// Targeting ..\BulletCollision\btCollisionObjectWrapper.java



// #endif  //BT_COLLISION_OBJECT_WRAPPER_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**
 * \mainpage Bullet Documentation
 *
 * \section intro_sec Introduction
 * Bullet is a Collision Detection and Rigid Body Dynamics Library. The Library is Open Source and free for commercial use, under the ZLib license ( http://opensource.org/licenses/zlib-license.php ).
 *
 * The main documentation is Bullet_User_Manual.pdf, included in the source code distribution.
 * There is the Physics Forum for feedback and general Collision Detection and Physics discussions.
 * Please visit http://www.bulletphysics.org
 *
 * \section install_sec Installation
 *
 * \subsection step1 Step 1: Download
 * You can download the Bullet Physics Library from the github repository: https://github.com/bulletphysics/bullet3/releases 
 *
 * \subsection step2 Step 2: Building
 * Bullet has multiple build systems, including premake, cmake and autotools. Premake and cmake support all platforms.
 * Premake is included in the Bullet/build folder for Windows, Mac OSX and Linux. 
 * Under Windows you can click on Bullet/build/vs2010.bat to create Microsoft Visual Studio projects. 
 * On Mac OSX and Linux you can open a terminal and generate Makefile, codeblocks or Xcode4 projects:
 * cd Bullet/build
 * ./premake4_osx gmake or ./premake4_linux gmake or ./premake4_linux64 gmake or (for Mac) ./premake4_osx xcode4
 * cd Bullet/build/gmake
 * make
 * 
 * An alternative to premake is cmake. You can download cmake from http://www.cmake.org
 * cmake can autogenerate projectfiles for Microsoft Visual Studio, Apple Xcode, KDevelop and Unix Makefiles.
 * The easiest is to run the CMake cmake-gui graphical user interface and choose the options and generate projectfiles.
 * You can also use cmake in the command-line. Here are some examples for various platforms:
 * cmake . -G "Visual Studio 9 2008"
 * cmake . -G Xcode
 * cmake . -G "Unix Makefiles"
 * Although cmake is recommended, you can also use autotools for UNIX: ./autogen.sh ./configure to create a Makefile and then run make.
 * 
 * \subsection step3 Step 3: Testing demos
 * Try to run and experiment with BasicDemo executable as a starting point.
 * Bullet can be used in several ways, as Full Rigid Body simulation, as Collision Detector Library or Low Level / Snippets like the GJK Closest Point calculation.
 * The Dependencies can be seen in this documentation under Directories
 * 
 * \subsection step4 Step 4: Integrating in your application, full Rigid Body and Soft Body simulation
 * Check out BasicDemo how to create a btDynamicsWorld, btRigidBody and btCollisionShape, Stepping the simulation and synchronizing your graphics object transform.
 * Check out SoftDemo how to use soft body dynamics, using btSoftRigidDynamicsWorld.
 * \subsection step5 Step 5 : Integrate the Collision Detection Library (without Dynamics and other Extras)
 * Bullet Collision Detection can also be used without the Dynamics/Extras.
 * Check out btCollisionWorld and btCollisionObject, and the CollisionInterfaceDemo.
 * \subsection step6 Step 6 : Use Snippets like the GJK Closest Point calculation.
 * Bullet has been designed in a modular way keeping dependencies to a minimum. The ConvexHullDistance demo demonstrates direct use of btGjkPairDetector.
 *
 * \section copyright Copyright
 * For up-to-data information and copyright and contributors list check out the Bullet_User_Manual.pdf
 * 
 */

// #ifndef BT_COLLISION_WORLD_H
// #define BT_COLLISION_WORLD_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "btCollisionObject.h"
// #include "btCollisionDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btOverlappingPairCache.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btCollisionWorld.java



// #endif  //BT_COLLISION_WORLD_H


// Parsed from BulletCollision/CollisionDispatch/btCollisionWorldImporter.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2014 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_WORLD_IMPORTER_H
// #define BT_COLLISION_WORLD_IMPORTER_H

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btHashMap.h"
// Targeting ..\BulletCollision\ConstraintInput.java


// Targeting ..\BulletCollision\btPoint2PointConstraint.java


// Targeting ..\BulletCollision\btHingeConstraint.java


// Targeting ..\BulletCollision\btConeTwistConstraint.java


// Targeting ..\BulletCollision\btGeneric6DofConstraint.java


// Targeting ..\BulletCollision\btGeneric6DofSpringConstraint.java


// Targeting ..\BulletCollision\btSliderConstraint.java


// Targeting ..\BulletCollision\btGearConstraint.java


// Targeting ..\BulletCollision\btCollisionWorldImporter.java



// #endif  //BT_WORLD_IMPORTER_H


// Parsed from BulletCollision/CollisionDispatch/btCompoundCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

*/

// #ifndef BT_COMPOUND_COLLISION_ALGORITHM_H
// #define BT_COMPOUND_COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"

// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "btCollisionCreateFunc.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "BulletCollision/BroadphaseCollision/btDbvt.h"
// Targeting ..\BulletCollision\btShapePairCallback.java


public static native btShapePairCallback gCompoundChildShapePairCallback(); public static native void gCompoundChildShapePairCallback(btShapePairCallback setter);
// Targeting ..\BulletCollision\btCompoundCollisionAlgorithm.java



// #endif  //BT_COMPOUND_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btCompoundCompoundCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

*/

// #ifndef BT_COMPOUND_COMPOUND_COLLISION_ALGORITHM_H
// #define BT_COMPOUND_COMPOUND_COLLISION_ALGORITHM_H

// #include "btCompoundCollisionAlgorithm.h"

// #include "BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"

// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "BulletCollision/CollisionDispatch/btHashedSimplePairCache.h"

public static native btShapePairCallback gCompoundCompoundChildShapePairCallback(); public static native void gCompoundCompoundChildShapePairCallback(btShapePairCallback setter);
// Targeting ..\BulletCollision\btCompoundCompoundCollisionAlgorithm.java



// #endif  //BT_COMPOUND_COMPOUND_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btConvex2dConvex2dAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_2D_CONVEX_2D_ALGORITHM_H
// #define BT_CONVEX_2D_CONVEX_2D_ALGORITHM_H

// #include "BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/NarrowPhaseCollision/btGjkPairDetector.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "BulletCollision/CollisionDispatch/btCollisionDispatcher.h"
// #include "LinearMath/btTransformUtil.h"  //for btConvexSeparatingDistanceUtil
// Targeting ..\BulletCollision\btConvex2dConvex2dAlgorithm.java



// #endif  //BT_CONVEX_2D_CONVEX_2D_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btConvexConcaveCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_CONCAVE_COLLISION_ALGORITHM_H
// #define BT_CONVEX_CONCAVE_COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"
// #include "BulletCollision/CollisionShapes/btTriangleCallback.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "btCollisionCreateFunc.h"
// Targeting ..\BulletCollision\btConvexTriangleCallback.java


// Targeting ..\BulletCollision\btConvexConcaveCollisionAlgorithm.java



// #endif  //BT_CONVEX_CONCAVE_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btConvexConvexAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_CONVEX_ALGORITHM_H
// #define BT_CONVEX_CONVEX_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/NarrowPhaseCollision/btGjkPairDetector.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/NarrowPhaseCollision/btVoronoiSimplexSolver.h"
// #include "btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"
// #include "LinearMath/btTransformUtil.h"  //for btConvexSeparatingDistanceUtil
// #include "BulletCollision/NarrowPhaseCollision/btPolyhedralContactClipping.h"
// Targeting ..\BulletCollision\btConvexConvexAlgorithm.java



// #endif  //BT_CONVEX_CONVEX_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btConvexPlaneCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_PLANE_COLLISION_ALGORITHM_H
// #define BT_CONVEX_PLANE_COLLISION_ALGORITHM_H

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"

// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btConvexPlaneCollisionAlgorithm.java



// #endif  //BT_CONVEX_PLANE_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btDefaultCollisionConfiguration.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DEFAULT_COLLISION_CONFIGURATION
// #define BT_DEFAULT_COLLISION_CONFIGURATION

// #include "btCollisionConfiguration.h"
// Targeting ..\BulletCollision\btDefaultCollisionConstructionInfo.java


// Targeting ..\BulletCollision\btDefaultCollisionConfiguration.java



// #endif  //BT_DEFAULT_COLLISION_CONFIGURATION


// Parsed from BulletCollision/CollisionDispatch/btEmptyCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_EMPTY_ALGORITH
// #define BT_EMPTY_ALGORITH
// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// #include "btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"

// #define ATTRIBUTE_ALIGNED(a)
// Targeting ..\BulletCollision\btEmptyAlgorithm.java



// #endif  //BT_EMPTY_ALGORITH


// Parsed from BulletCollision/CollisionDispatch/btGhostObject.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  http://bulletphysics.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GHOST_OBJECT_H
// #define BT_GHOST_OBJECT_H

// #include "btCollisionObject.h"
// #include "BulletCollision/BroadphaseCollision/btOverlappingPairCallback.h"
// #include "LinearMath/btAlignedAllocator.h"
// #include "BulletCollision/BroadphaseCollision/btOverlappingPairCache.h"
// #include "btCollisionWorld.h"
// Targeting ..\BulletCollision\btGhostObject.java


// Targeting ..\BulletCollision\btPairCachingGhostObject.java


// Targeting ..\BulletCollision\btGhostPairCallback.java



// #endif


// Parsed from BulletCollision/CollisionDispatch/btHashedSimplePairCache.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_HASHED_SIMPLE_PAIR_CACHE_H
// #define BT_HASHED_SIMPLE_PAIR_CACHE_H

// #include "LinearMath/btAlignedObjectArray.h"

@MemberGetter public static native int BT_SIMPLE_NULL_PAIR();
// Targeting ..\BulletCollision\btSimplePair.java


// Targeting ..\BulletCollision\btHashedSimplePairCache.java



// #endif  //BT_HASHED_SIMPLE_PAIR_CACHE_H


// Parsed from BulletCollision/CollisionDispatch/btInternalEdgeUtility.h


// #ifndef BT_INTERNAL_EDGE_UTILITY_H
// #define BT_INTERNAL_EDGE_UTILITY_H

// #include "LinearMath/btHashMap.h"
// #include "LinearMath/btVector3.h"

// #include "BulletCollision/CollisionShapes/btTriangleInfoMap.h"

/**The btInternalEdgeUtility helps to avoid or reduce artifacts due to wrong collision normals caused by internal edges.
 * See also http://code.google.com/p/bullet/issues/detail?id=27 */

/** enum btInternalEdgeAdjustFlags */
public static final int
	BT_TRIANGLE_CONVEX_BACKFACE_MODE = 1,
	BT_TRIANGLE_CONCAVE_DOUBLE_SIDED = 2,  //double sided options are experimental, single sided is recommended
	BT_TRIANGLE_CONVEX_DOUBLE_SIDED = 4;

/**Call btGenerateInternalEdgeInfo to create triangle info, store in the shape 'userInfo' */
public static native void btGenerateInternalEdgeInfo(btBvhTriangleMeshShape trimeshShape, btTriangleInfoMap triangleInfoMap);

public static native void btGenerateInternalEdgeInfo(btHeightfieldTerrainShape trimeshShape, btTriangleInfoMap triangleInfoMap);

/**Call the btFixMeshNormal to adjust the collision normal, using the triangle info map (generated using btGenerateInternalEdgeInfo)
 * If this info map is missing, or the triangle is not store in this map, nothing will be done */
public static native void btAdjustInternalEdgeContacts(@ByRef btManifoldPoint cp, @Const btCollisionObjectWrapper trimeshColObj0Wrap, @Const btCollisionObjectWrapper otherColObj1Wrap, int partId0, int index0, int normalAdjustFlags/*=0*/);
public static native void btAdjustInternalEdgeContacts(@ByRef btManifoldPoint cp, @Const btCollisionObjectWrapper trimeshColObj0Wrap, @Const btCollisionObjectWrapper otherColObj1Wrap, int partId0, int index0);

/**Enable the BT_INTERNAL_EDGE_DEBUG_DRAW define and call btSetDebugDrawer, to get visual info to see if the internal edge utility works properly.
 * If the utility doesn't work properly, you might have to adjust the threshold values in btTriangleInfoMap */
//#define BT_INTERNAL_EDGE_DEBUG_DRAW

// #ifdef BT_INTERNAL_EDGE_DEBUG_DRAW
// #endif  //BT_INTERNAL_EDGE_DEBUG_DRAW

// #endif  //BT_INTERNAL_EDGE_UTILITY_H


// Parsed from BulletCollision/CollisionDispatch/btManifoldResult.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MANIFOLD_RESULT_H
// #define BT_MANIFOLD_RESULT_H

// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"

// #include "BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h"

// #include "LinearMath/btTransform.h"
// #include "BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h"
// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"
// Targeting ..\BulletCollision\ContactAddedCallback.java


public static native ContactAddedCallback gContactAddedCallback(); public static native void gContactAddedCallback(ContactAddedCallback setter);
// Targeting ..\BulletCollision\CalculateCombinedCallback.java



public static native CalculateCombinedCallback gCalculateCombinedRestitutionCallback(); public static native void gCalculateCombinedRestitutionCallback(CalculateCombinedCallback setter);
public static native CalculateCombinedCallback gCalculateCombinedFrictionCallback(); public static native void gCalculateCombinedFrictionCallback(CalculateCombinedCallback setter);
public static native CalculateCombinedCallback gCalculateCombinedRollingFrictionCallback(); public static native void gCalculateCombinedRollingFrictionCallback(CalculateCombinedCallback setter);
public static native CalculateCombinedCallback gCalculateCombinedSpinningFrictionCallback(); public static native void gCalculateCombinedSpinningFrictionCallback(CalculateCombinedCallback setter);
public static native CalculateCombinedCallback gCalculateCombinedContactDampingCallback(); public static native void gCalculateCombinedContactDampingCallback(CalculateCombinedCallback setter);
public static native CalculateCombinedCallback gCalculateCombinedContactStiffnessCallback(); public static native void gCalculateCombinedContactStiffnessCallback(CalculateCombinedCallback setter);
// Targeting ..\BulletCollision\btManifoldResult.java



// #endif  //BT_MANIFOLD_RESULT_H


// Parsed from BulletCollision/CollisionDispatch/btSimulationIslandManager.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMULATION_ISLAND_MANAGER_H
// #define BT_SIMULATION_ISLAND_MANAGER_H

// #include "BulletCollision/CollisionDispatch/btUnionFind.h"
// #include "btCollisionCreateFunc.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "btCollisionObject.h"
// Targeting ..\BulletCollision\btSimulationIslandManager.java



// #endif  //BT_SIMULATION_ISLAND_MANAGER_H


// Parsed from BulletCollision/CollisionDispatch/btSphereBoxCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SPHERE_BOX_COLLISION_ALGORITHM_H
// #define BT_SPHERE_BOX_COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"

// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btSphereBoxCollisionAlgorithm.java



// #endif  //BT_SPHERE_BOX_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btSphereSphereCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SPHERE_SPHERE_COLLISION_ALGORITHM_H
// #define BT_SPHERE_SPHERE_COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"
// Targeting ..\BulletCollision\btSphereSphereCollisionAlgorithm.java



// #endif  //BT_SPHERE_SPHERE_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btSphereTriangleCollisionAlgorithm.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SPHERE_TRIANGLE_COLLISION_ALGORITHM_H
// #define BT_SPHERE_TRIANGLE_COLLISION_ALGORITHM_H

// #include "btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "btCollisionDispatcher.h"
// Targeting ..\BulletCollision\btSphereTriangleCollisionAlgorithm.java



// #endif  //BT_SPHERE_TRIANGLE_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/CollisionDispatch/btUnionFind.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_UNION_FIND_H
// #define BT_UNION_FIND_H

// #include "LinearMath/btAlignedObjectArray.h"

public static final int USE_PATH_COMPRESSION = 1;

/**see for discussion of static island optimizations by Vroonsh here: http://code.google.com/p/bullet/issues/detail?id=406 */
public static final int STATIC_SIMULATION_ISLAND_OPTIMIZATION = 1;
// Targeting ..\BulletCollision\btElement.java


// Targeting ..\BulletCollision\btUnionFind.java



// #endif  //BT_UNION_FIND_H


// Parsed from BulletCollision/CollisionDispatch/SphereTriangleDetector.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SPHERE_TRIANGLE_DETECTOR_H
// #define BT_SPHERE_TRIANGLE_DETECTOR_H

// #include "BulletCollision/NarrowPhaseCollision/btDiscreteCollisionDetectorInterface.h"
// Targeting ..\BulletCollision\SphereTriangleDetector.java


// #endif  //BT_SPHERE_TRIANGLE_DETECTOR_H


// Parsed from BulletCollision/CollisionShapes/btBox2dShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBB_BOX_2D_SHAPE_H
// #define BT_OBB_BOX_2D_SHAPE_H

// #include "BulletCollision/CollisionShapes/btPolyhedralConvexShape.h"
// #include "BulletCollision/CollisionShapes/btCollisionMargin.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btMinMax.h"
// Targeting ..\BulletCollision\btBox2dShape.java



// #endif  //BT_OBB_BOX_2D_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btBoxShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBB_BOX_MINKOWSKI_H
// #define BT_OBB_BOX_MINKOWSKI_H

// #include "btPolyhedralConvexShape.h"
// #include "btCollisionMargin.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btMinMax.h"
// Targeting ..\BulletCollision\btBoxShape.java



// #endif  //BT_OBB_BOX_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btBvhTriangleMeshShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BVH_TRIANGLE_MESH_SHAPE_H
// #define BT_BVH_TRIANGLE_MESH_SHAPE_H

// #include "btTriangleMeshShape.h"
// #include "btOptimizedBvh.h"
// #include "LinearMath/btAlignedAllocator.h"
// #include "btTriangleInfoMap.h"
// Targeting ..\BulletCollision\btBvhTriangleMeshShape.java


// Targeting ..\BulletCollision\btTriangleMeshShapeData.java



// clang-format on



// #endif  //BT_BVH_TRIANGLE_MESH_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btCapsuleShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CAPSULE_SHAPE_H
// #define BT_CAPSULE_SHAPE_H

// #include "btConvexInternalShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btCapsuleShape.java


// Targeting ..\BulletCollision\btCapsuleShapeX.java


// Targeting ..\BulletCollision\btCapsuleShapeZ.java


// Targeting ..\BulletCollision\btCapsuleShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */




// #endif  //BT_CAPSULE_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btCollisionMargin.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_MARGIN_H
// #define BT_COLLISION_MARGIN_H

/**The CONVEX_DISTANCE_MARGIN is a default collision margin for convex collision shapes derived from btConvexInternalShape.
 * This collision margin is used by Gjk and some other algorithms
 * Note that when creating small objects, you need to make sure to set a smaller collision margin, using the 'setMargin' API */
public static native @MemberGetter double CONVEX_DISTANCE_MARGIN();
public static final double CONVEX_DISTANCE_MARGIN = CONVEX_DISTANCE_MARGIN();  // btScalar(0.1)//;//btScalar(0.01)

// #endif  //BT_COLLISION_MARGIN_H


// Parsed from BulletCollision/CollisionShapes/btCollisionShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COLLISION_SHAPE_H
// #define BT_COLLISION_SHAPE_H

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  //for the shape types
// Targeting ..\BulletCollision\btCollisionShape.java


// Targeting ..\BulletCollision\btCollisionShapeData.java


// clang-format on


// #endif  //BT_COLLISION_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btCompoundShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_COMPOUND_SHAPE_H
// #define BT_COMPOUND_SHAPE_H

// #include "btCollisionShape.h"

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "btCollisionMargin.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btCompoundShapeChild.java



public static native @Cast("bool") @Name("operator ==") boolean equals(@Const @ByRef btCompoundShapeChild c1, @Const @ByRef btCompoundShapeChild c2);
// Targeting ..\BulletCollision\btCompoundShape.java


// Targeting ..\BulletCollision\btCompoundShapeChildData.java


// Targeting ..\BulletCollision\btCompoundShapeData.java



// clang-format on



// #endif  //BT_COMPOUND_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConcaveShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONCAVE_SHAPE_H
// #define BT_CONCAVE_SHAPE_H

// #include "btCollisionShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  // for the types
// #include "btTriangleCallback.h"

/** PHY_ScalarType enumerates possible scalar types.
 *  See the btStridingMeshInterface or btHeightfieldTerrainShape for its use */
/** enum PHY_ScalarType */
public static final int
	PHY_FLOAT = 0,
	PHY_DOUBLE = 1,
	PHY_INTEGER = 2,
	PHY_SHORT = 3,
	PHY_FIXEDPOINT88 = 4,
	PHY_UCHAR = 5;
// Targeting ..\BulletCollision\btConcaveShape.java



// #endif  //BT_CONCAVE_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConeShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONE_MINKOWSKI_H
// #define BT_CONE_MINKOWSKI_H

// #include "btConvexInternalShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btConeShape.java


// Targeting ..\BulletCollision\btConeShapeX.java


// Targeting ..\BulletCollision\btConeShapeZ.java


// Targeting ..\BulletCollision\btConeShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_CONE_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btConvex2dShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_2D_SHAPE_H
// #define BT_CONVEX_2D_SHAPE_H

// #include "BulletCollision/CollisionShapes/btConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btConvex2dShape.java



// #endif  //BT_CONVEX_2D_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConvexHullShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_HULL_SHAPE_H
// #define BT_CONVEX_HULL_SHAPE_H

// #include "btPolyhedralConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  // for the types
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btConvexHullShape.java


// Targeting ..\BulletCollision\btConvexHullShapeData.java



// clang-format on



// #endif  //BT_CONVEX_HULL_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConvexInternalShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_INTERNAL_SHAPE_H
// #define BT_CONVEX_INTERNAL_SHAPE_H

// #include "btConvexShape.h"
// #include "LinearMath/btAabbUtil2.h"
// Targeting ..\BulletCollision\btConvexInternalShape.java


// Targeting ..\BulletCollision\btConvexInternalShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */

// Targeting ..\BulletCollision\btConvexInternalAabbCachingShape.java



// #endif  //BT_CONVEX_INTERNAL_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConvexPointCloudShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_POINT_CLOUD_SHAPE_H
// #define BT_CONVEX_POINT_CLOUD_SHAPE_H

// #include "btPolyhedralConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  // for the types
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btConvexPointCloudShape.java



// #endif  //BT_CONVEX_POINT_CLOUD_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btConvexPolyhedron.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2011 Advanced Micro Devices, Inc.  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef _BT_POLYHEDRAL_FEATURES_H
// #define _BT_POLYHEDRAL_FEATURES_H

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btAlignedObjectArray.h"

public static final int TEST_INTERNAL_OBJECTS = 1;
// Targeting ..\BulletCollision\btFace.java


// Targeting ..\BulletCollision\btConvexPolyhedron.java



// #endif  //_BT_POLYHEDRAL_FEATURES_H


// Parsed from BulletCollision/CollisionShapes/btConvexShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONVEX_SHAPE_INTERFACE1
// #define BT_CONVEX_SHAPE_INTERFACE1

// #include "btCollisionShape.h"

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "btCollisionMargin.h"
// #include "LinearMath/btAlignedAllocator.h"

public static final int MAX_PREFERRED_PENETRATION_DIRECTIONS = 10;
// Targeting ..\BulletCollision\btConvexShape.java



// #endif  //BT_CONVEX_SHAPE_INTERFACE1


// Parsed from BulletCollision/CollisionShapes/btConvexTriangleMeshShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef BT_CONVEX_TRIANGLEMESH_SHAPE_H
// #define BT_CONVEX_TRIANGLEMESH_SHAPE_H

// #include "btPolyhedralConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btConvexTriangleMeshShape.java



// #endif  //BT_CONVEX_TRIANGLEMESH_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btCylinderShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CYLINDER_MINKOWSKI_H
// #define BT_CYLINDER_MINKOWSKI_H

// #include "btBoxShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  // for the types
// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btCylinderShape.java


// Targeting ..\BulletCollision\btCylinderShapeX.java


// Targeting ..\BulletCollision\btCylinderShapeZ.java


// Targeting ..\BulletCollision\btCylinderShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_CYLINDER_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btEmptyShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_EMPTY_SHAPE_H
// #define BT_EMPTY_SHAPE_H

// #include "btConcaveShape.h"

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "btCollisionMargin.h"
// Targeting ..\BulletCollision\btEmptyShape.java



// #endif  //BT_EMPTY_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btHeightfieldTerrainShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_HEIGHTFIELD_TERRAIN_SHAPE_H
// #define BT_HEIGHTFIELD_TERRAIN_SHAPE_H

// #include "btConcaveShape.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btHeightfieldTerrainShape.java



// #endif  //BT_HEIGHTFIELD_TERRAIN_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btMaterial.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/** This file was created by Alex Silverman */

// #ifndef BT_MATERIAL_H
// #define BT_MATERIAL_H
// Targeting ..\BulletCollision\btMaterial.java



// #endif  // BT_MATERIAL_H


// Parsed from BulletCollision/CollisionShapes/btMiniSDF.h

// #ifndef MINISDF_H
// #define MINISDF_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAabbUtil2.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btMultiIndex.java


// Targeting ..\BulletCollision\btAlignedBox3d.java


// Targeting ..\BulletCollision\btShapeMatrix.java


// Targeting ..\BulletCollision\btShapeGradients.java


// Targeting ..\BulletCollision\btCell32.java


// Targeting ..\BulletCollision\btMiniSDF.java



// #endif  //MINISDF_H


// Parsed from BulletCollision/CollisionShapes/btMinkowskiSumShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MINKOWSKI_SUM_SHAPE_H
// #define BT_MINKOWSKI_SUM_SHAPE_H

// #include "btConvexInternalShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btMinkowskiSumShape.java



// #endif  //BT_MINKOWSKI_SUM_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btMultimaterialTriangleMeshShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/** This file was created by Alex Silverman */

// #ifndef BT_BVH_TRIANGLE_MATERIAL_MESH_SHAPE_H
// #define BT_BVH_TRIANGLE_MATERIAL_MESH_SHAPE_H

// #include "btBvhTriangleMeshShape.h"
// #include "btMaterial.h"
// Targeting ..\BulletCollision\btMultimaterialTriangleMeshShape.java



// #endif  //BT_BVH_TRIANGLE_MATERIAL_MESH_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btMultiSphereShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTI_SPHERE_MINKOWSKI_H
// #define BT_MULTI_SPHERE_MINKOWSKI_H

// #include "btConvexInternalShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"  // for the types
// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btAabbUtil2.h"
// Targeting ..\BulletCollision\btMultiSphereShape.java


// Targeting ..\BulletCollision\btPositionAndRadius.java


// Targeting ..\BulletCollision\btMultiSphereShapeData.java



// clang-format on



// #endif  //BT_MULTI_SPHERE_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btOptimizedBvh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**Contains contributions from Disney Studio's */

// #ifndef BT_OPTIMIZED_BVH_H
// #define BT_OPTIMIZED_BVH_H

// #include "BulletCollision/BroadphaseCollision/btQuantizedBvh.h"
// Targeting ..\BulletCollision\btOptimizedBvh.java



// #endif  //BT_OPTIMIZED_BVH_H


// Parsed from BulletCollision/CollisionShapes/btPolyhedralConvexShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_POLYHEDRAL_CONVEX_SHAPE_H
// #define BT_POLYHEDRAL_CONVEX_SHAPE_H

// #include "LinearMath/btMatrix3x3.h"
// #include "btConvexInternalShape.h"
// Targeting ..\BulletCollision\btPolyhedralConvexShape.java


// Targeting ..\BulletCollision\btPolyhedralConvexAabbCachingShape.java



// #endif  //BT_POLYHEDRAL_CONVEX_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btScaledBvhTriangleMeshShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SCALED_BVH_TRIANGLE_MESH_SHAPE_H
// #define BT_SCALED_BVH_TRIANGLE_MESH_SHAPE_H

// #include "BulletCollision/CollisionShapes/btBvhTriangleMeshShape.h"
// Targeting ..\BulletCollision\btScaledBvhTriangleMeshShape.java


// Targeting ..\BulletCollision\btScaledTriangleMeshShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_SCALED_BVH_TRIANGLE_MESH_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btSdfCollisionShape.h

// #ifndef BT_SDF_COLLISION_SHAPE_H
// #define BT_SDF_COLLISION_SHAPE_H

// #include "btConcaveShape.h"
// Targeting ..\BulletCollision\btSdfCollisionShape.java



// #endif  //BT_SDF_COLLISION_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btShapeHull.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**btShapeHull implemented by John McCutchan. */

// #ifndef BT_SHAPE_HULL_H
// #define BT_SHAPE_HULL_H

// #include "LinearMath/btAlignedObjectArray.h"
// #include "BulletCollision/CollisionShapes/btConvexShape.h"
// Targeting ..\BulletCollision\btShapeHull.java



// #endif  //BT_SHAPE_HULL_H


// Parsed from BulletCollision/CollisionShapes/btSphereShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
// #ifndef BT_SPHERE_MINKOWSKI_H
// #define BT_SPHERE_MINKOWSKI_H

// #include "btConvexInternalShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btSphereShape.java



// #endif  //BT_SPHERE_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btStaticPlaneShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_STATIC_PLANE_SHAPE_H
// #define BT_STATIC_PLANE_SHAPE_H

// #include "btConcaveShape.h"
// Targeting ..\BulletCollision\btStaticPlaneShape.java


// Targeting ..\BulletCollision\btStaticPlaneShapeData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_STATIC_PLANE_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btStridingMeshInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_STRIDING_MESHINTERFACE_H
// #define BT_STRIDING_MESHINTERFACE_H

// #include "LinearMath/btVector3.h"
// #include "btTriangleCallback.h"
// #include "btConcaveShape.h"
// Targeting ..\BulletCollision\btStridingMeshInterface.java


// Targeting ..\BulletCollision\btIntIndexData.java


// Targeting ..\BulletCollision\btShortIntIndexData.java


// Targeting ..\BulletCollision\btShortIntIndexTripletData.java


// Targeting ..\BulletCollision\btCharIndexTripletData.java


// Targeting ..\BulletCollision\btMeshPartData.java


// Targeting ..\BulletCollision\btStridingMeshInterfaceData.java



// clang-format on



// #endif  //BT_STRIDING_MESHINTERFACE_H


// Parsed from BulletCollision/CollisionShapes/btTetrahedronShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMPLEX_1TO4_SHAPE
// #define BT_SIMPLEX_1TO4_SHAPE

// #include "btPolyhedralConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btBU_Simplex1to4.java



// #endif  //BT_SIMPLEX_1TO4_SHAPE


// Parsed from BulletCollision/CollisionShapes/btTriangleBuffer.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRIANGLE_BUFFER_H
// #define BT_TRIANGLE_BUFFER_H

// #include "btTriangleCallback.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btTriangle.java


// Targeting ..\BulletCollision\btTriangleBuffer.java



// #endif  //BT_TRIANGLE_BUFFER_H


// Parsed from BulletCollision/CollisionShapes/btTriangleCallback.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRIANGLE_CALLBACK_H
// #define BT_TRIANGLE_CALLBACK_H

// #include "LinearMath/btVector3.h"
// Targeting ..\BulletCollision\btTriangleCallback.java


// Targeting ..\BulletCollision\btInternalTriangleIndexCallback.java



// #endif  //BT_TRIANGLE_CALLBACK_H


// Parsed from BulletCollision/CollisionShapes/btTriangleIndexVertexArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRIANGLE_INDEX_VERTEX_ARRAY_H
// #define BT_TRIANGLE_INDEX_VERTEX_ARRAY_H

// #include "btStridingMeshInterface.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btScalar.h"
// Targeting ..\BulletCollision\btIndexedMesh.java


// Targeting ..\BulletCollision\btTriangleIndexVertexArray.java



// #endif  //BT_TRIANGLE_INDEX_VERTEX_ARRAY_H


// Parsed from BulletCollision/CollisionShapes/btTriangleIndexVertexMaterialArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was created by Alex Silverman */

// #ifndef BT_MULTIMATERIAL_TRIANGLE_INDEX_VERTEX_ARRAY_H
// #define BT_MULTIMATERIAL_TRIANGLE_INDEX_VERTEX_ARRAY_H

// #include "btTriangleIndexVertexArray.h"
// Targeting ..\BulletCollision\btMaterialProperties.java


// Targeting ..\BulletCollision\btTriangleIndexVertexMaterialArray.java



// #endif  //BT_MULTIMATERIAL_TRIANGLE_INDEX_VERTEX_ARRAY_H


// Parsed from BulletCollision/CollisionShapes/btTriangleInfoMap.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2010 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef _BT_TRIANGLE_INFO_MAP_H
// #define _BT_TRIANGLE_INFO_MAP_H

// #include "LinearMath/btHashMap.h"
// #include "LinearMath/btSerializer.h"

/**for btTriangleInfo m_flags */
public static final int TRI_INFO_V0V1_CONVEX = 1;
public static final int TRI_INFO_V1V2_CONVEX = 2;
public static final int TRI_INFO_V2V0_CONVEX = 4;

public static final int TRI_INFO_V0V1_SWAP_NORMALB = 8;
public static final int TRI_INFO_V1V2_SWAP_NORMALB = 16;
public static final int TRI_INFO_V2V0_SWAP_NORMALB = 32;
// Targeting ..\BulletCollision\btTriangleInfo.java


// Targeting ..\BulletCollision\btTriangleInfoMap.java


// Targeting ..\BulletCollision\btTriangleInfoData.java


// Targeting ..\BulletCollision\btTriangleInfoMapData.java



// clang-format on



/**fills the dataBuffer and returns the struct name (and 0 on failure) */


/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //_BT_TRIANGLE_INFO_MAP_H


// Parsed from BulletCollision/CollisionShapes/btTriangleMesh.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRIANGLE_MESH_H
// #define BT_TRIANGLE_MESH_H

// #include "btTriangleIndexVertexArray.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletCollision\btTriangleMesh.java



// #endif  //BT_TRIANGLE_MESH_H


// Parsed from BulletCollision/CollisionShapes/btTriangleMeshShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TRIANGLE_MESH_SHAPE_H
// #define BT_TRIANGLE_MESH_SHAPE_H

// #include "btConcaveShape.h"
// #include "btStridingMeshInterface.h"
// Targeting ..\BulletCollision\btTriangleMeshShape.java



// #endif  //BT_TRIANGLE_MESH_SHAPE_H


// Parsed from BulletCollision/CollisionShapes/btTriangleShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBB_TRIANGLE_MINKOWSKI_H
// #define BT_OBB_TRIANGLE_MINKOWSKI_H

// #include "btConvexShape.h"
// #include "btBoxShape.h"
// Targeting ..\BulletCollision\btTriangleShape.java



// #endif  //BT_OBB_TRIANGLE_MINKOWSKI_H


// Parsed from BulletCollision/CollisionShapes/btUniformScalingShape.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_UNIFORM_SCALING_SHAPE_H
// #define BT_UNIFORM_SCALING_SHAPE_H

// #include "btConvexShape.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// Targeting ..\BulletCollision\btUniformScalingShape.java



// #endif  //BT_UNIFORM_SCALING_SHAPE_H


// Parsed from BulletCollision/Gimpact/btBoxCollision.h

// #ifndef BT_BOX_COLLISION_H_INCLUDED
// #define BT_BOX_COLLISION_H_INCLUDED

/** \file gim_box_collision.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btTransform.h"

/**Swap numbers */
// #define BT_SWAP_NUMBERS(a, b)
// 	{
// 		a = a + b;
// 		b = a - b;
// 		a = a - b;
// 	}

// #define BT_MAX(a, b) (a < b ? b : a)
// #define BT_MIN(a, b) (a > b ? b : a)

// #define BT_GREATER(x, y) btFabs(x) > (y)

// #define BT_MAX3(a, b, c) BT_MAX(a, BT_MAX(b, c))
// #define BT_MIN3(a, b, c) BT_MIN(a, BT_MIN(b, c))

/** enum eBT_PLANE_INTERSECTION_TYPE */
public static final int
	BT_CONST_BACK_PLANE = 0,
	BT_CONST_COLLIDE_PLANE = 1,
	BT_CONST_FRONT_PLANE = 2;

//SIMD_FORCE_INLINE bool test_cross_edge_box(
//	const btVector3 & edge,
//	const btVector3 & absolute_edge,
//	const btVector3 & pointa,
//	const btVector3 & pointb, const btVector3 & extend,
//	int dir_index0,
//	int dir_index1
//	int component_index0,
//	int component_index1)
//{
//	// dir coords are -z and y
//
//	const btScalar dir0 = -edge[dir_index0];
//	const btScalar dir1 = edge[dir_index1];
//	btScalar pmin = pointa[component_index0]*dir0 + pointa[component_index1]*dir1;
//	btScalar pmax = pointb[component_index0]*dir0 + pointb[component_index1]*dir1;
//	//find minmax
//	if(pmin>pmax)
//	{
//		BT_SWAP_NUMBERS(pmin,pmax);
//	}
//	//find extends
//	const btScalar rad = extend[component_index0] * absolute_edge[dir_index0] +
//					extend[component_index1] * absolute_edge[dir_index1];
//
//	if(pmin>rad || -rad>pmax) return false;
//	return true;
//}
//
//SIMD_FORCE_INLINE bool test_cross_edge_box_X_axis(
//	const btVector3 & edge,
//	const btVector3 & absolute_edge,
//	const btVector3 & pointa,
//	const btVector3 & pointb, btVector3 & extend)
//{
//
//	return test_cross_edge_box(edge,absolute_edge,pointa,pointb,extend,2,1,1,2);
//}
//
//
//SIMD_FORCE_INLINE bool test_cross_edge_box_Y_axis(
//	const btVector3 & edge,
//	const btVector3 & absolute_edge,
//	const btVector3 & pointa,
//	const btVector3 & pointb, btVector3 & extend)
//{
//
//	return test_cross_edge_box(edge,absolute_edge,pointa,pointb,extend,0,2,2,0);
//}
//
//SIMD_FORCE_INLINE bool test_cross_edge_box_Z_axis(
//	const btVector3 & edge,
//	const btVector3 & absolute_edge,
//	const btVector3 & pointa,
//	const btVector3 & pointb, btVector3 & extend)
//{
//
//	return test_cross_edge_box(edge,absolute_edge,pointa,pointb,extend,1,0,0,1);
//}

// #define TEST_CROSS_EDGE_BOX_MCR(edge, absolute_edge, pointa, pointb, _extend, i_dir_0, i_dir_1, i_comp_0, i_comp_1)
// 	{
// 		const btScalar dir0 = -edge[i_dir_0];
// 		const btScalar dir1 = edge[i_dir_1];
// 		btScalar pmin = pointa[i_comp_0] * dir0 + pointa[i_comp_1] * dir1;
// 		btScalar pmax = pointb[i_comp_0] * dir0 + pointb[i_comp_1] * dir1;
// 		if (pmin > pmax)
// 		{
// 			BT_SWAP_NUMBERS(pmin, pmax);
// 		}
// 		const btScalar abs_dir0 = absolute_edge[i_dir_0];
// 		const btScalar abs_dir1 = absolute_edge[i_dir_1];
// 		const btScalar rad = _extend[i_comp_0] * abs_dir0 + _extend[i_comp_1] * abs_dir1;
// 		if (pmin > rad || -rad > pmax) return false;
// 	}

// #define TEST_CROSS_EDGE_BOX_X_AXIS_MCR(edge, absolute_edge, pointa, pointb, _extend)
// 	{
// 		TEST_CROSS_EDGE_BOX_MCR(edge, absolute_edge, pointa, pointb, _extend, 2, 1, 1, 2);
// 	}

// #define TEST_CROSS_EDGE_BOX_Y_AXIS_MCR(edge, absolute_edge, pointa, pointb, _extend)
// 	{
// 		TEST_CROSS_EDGE_BOX_MCR(edge, absolute_edge, pointa, pointb, _extend, 0, 2, 2, 0);
// 	}

// #define TEST_CROSS_EDGE_BOX_Z_AXIS_MCR(edge, absolute_edge, pointa, pointb, _extend)
// 	{
// 		TEST_CROSS_EDGE_BOX_MCR(edge, absolute_edge, pointa, pointb, _extend, 1, 0, 0, 1);
// 	}

/** Returns the dot product between a vec3f and the col of a matrix */
public static native @Cast("btScalar") double bt_mat3_dot_col(
	@Const @ByRef btMatrix3x3 mat, @Const @ByRef btVector3 vec3, int colindex);
// Targeting ..\BulletCollision\BT_BOX_BOX_TRANSFORM_CACHE.java



public static final double BOX_PLANE_EPSILON = 0.000001f;

/** Axis aligned box */

/** Compairison of transformation objects */
public static native @Cast("bool") boolean btCompareTransformsEqual(@Const @ByRef btTransform t1, @Const @ByRef btTransform t2);

// #endif  // GIM_BOX_COLLISION_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btClipPolygon.h

// #ifndef BT_CLIP_POLYGON_H_INCLUDED
// #define BT_CLIP_POLYGON_H_INCLUDED

/** \file btClipPolygon.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btGeometryUtil.h"

public static native @Cast("btScalar") double bt_distance_point_plane(@Const @ByRef btVector4 plane, @Const @ByRef btVector3 point);

/** Vector blending
Takes two vectors a, b, blends them together*/
public static native void bt_vec_blend(@ByRef btVector3 vr, @Const @ByRef btVector3 va, @Const @ByRef btVector3 vb, @Cast("btScalar") double blend_factor);

/** This function calcs the distance from a 3D plane */
public static native void bt_plane_clip_polygon_collect(
	@Const @ByRef btVector3 point0,
	@Const @ByRef btVector3 point1,
	@Cast("btScalar") double dist0,
	@Cast("btScalar") double dist1,
	btVector3 clipped,
	@ByRef IntPointer clipped_count);
public static native void bt_plane_clip_polygon_collect(
	@Const @ByRef btVector3 point0,
	@Const @ByRef btVector3 point1,
	@Cast("btScalar") double dist0,
	@Cast("btScalar") double dist1,
	btVector3 clipped,
	@ByRef IntBuffer clipped_count);
public static native void bt_plane_clip_polygon_collect(
	@Const @ByRef btVector3 point0,
	@Const @ByRef btVector3 point1,
	@Cast("btScalar") double dist0,
	@Cast("btScalar") double dist1,
	btVector3 clipped,
	@ByRef int[] clipped_count);

/** Clips a polygon by a plane
/**
*@return The count of the clipped counts
*/
public static native int bt_plane_clip_polygon(
	@Const @ByRef btVector4 plane,
	@Const btVector3 polygon_points,
	int polygon_point_count,
	btVector3 clipped);

/** Clips a polygon by a plane
/**
*@param clipped must be an array of 16 points.
*@return The count of the clipped counts
*/
public static native int bt_plane_clip_triangle(
	@Const @ByRef btVector4 plane,
	@Const @ByRef btVector3 point0,
	@Const @ByRef btVector3 point1,
	@Const @ByRef btVector3 point2,
	btVector3 clipped
);

// #endif  // GIM_TRI_COLLISION_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btCompoundFromGimpact.h

// #ifndef BT_COMPOUND_FROM_GIMPACT
// #define BT_COMPOUND_FROM_GIMPACT

// #include "BulletCollision/CollisionShapes/btCompoundShape.h"
// #include "btGImpactShape.h"
// #include "BulletCollision/NarrowPhaseCollision/btRaycastCallback.h"
// Targeting ..\BulletCollision\btCompoundFromGimpactShape.java


// Targeting ..\BulletCollision\MyCallback.java


// Targeting ..\BulletCollision\MyInternalTriangleIndexCallback.java



public static native btCompoundShape btCreateCompoundFromGimpactShape(@Const btGImpactMeshShape gimpactMesh, @Cast("btScalar") double depth);

// #endif  //BT_COMPOUND_FROM_GIMPACT


// Parsed from BulletCollision/Gimpact/btContactProcessing.h

// #ifndef BT_CONTACT_H_INCLUDED
// #define BT_CONTACT_H_INCLUDED

/** \file gim_contact.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "btTriangleShapeEx.h"
// #include "btContactProcessingStructs.h"
// Targeting ..\BulletCollision\btContactArray.java



// #endif  // GIM_CONTACT_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btContactProcessingStructs.h

// #ifndef BT_CONTACT_H_STRUCTS_INCLUDED
// #define BT_CONTACT_H_STRUCTS_INCLUDED

/** \file gim_contact.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btTransform.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "btTriangleShapeEx.h"

/**
Configuration var for applying interpolation of  contact normals
*/
public static final int NORMAL_CONTACT_AVERAGE = 1;

public static final double CONTACT_DIFF_EPSILON = 0.00001f;
// Targeting ..\BulletCollision\GIM_CONTACT.java



// #endif  // BT_CONTACT_H_STRUCTS_INCLUDED


// Parsed from BulletCollision/Gimpact/btGImpactBvh.h

// #ifndef BT_GIMPACT_BVH_H_INCLUDED
// #define BT_GIMPACT_BVH_H_INCLUDED

/** \file gim_box_set.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btAlignedObjectArray.h"

// #include "btBoxCollision.h"
// #include "btTriangleShapeEx.h"
// #include "btGImpactBvhStructs.h"
// Targeting ..\BulletCollision\btPairSet.java


// Targeting ..\BulletCollision\GIM_BVH_DATA_ARRAY.java


// Targeting ..\BulletCollision\GIM_BVH_TREE_NODE_ARRAY.java


// Targeting ..\BulletCollision\btBvhTree.java


// Targeting ..\BulletCollision\btPrimitiveManagerBase.java


// Targeting ..\BulletCollision\btGImpactBvh.java



// #endif  // BT_GIMPACT_BVH_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btGImpactBvhStructs.h

// #ifndef GIM_BOX_SET_STRUCT_H_INCLUDED
// #define GIM_BOX_SET_STRUCT_H_INCLUDED

/** \file gim_box_set.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btAlignedObjectArray.h"

// #include "btBoxCollision.h"
// #include "btTriangleShapeEx.h"
// #include "gim_pair.h"
// Targeting ..\BulletCollision\GIM_BVH_DATA.java


// Targeting ..\BulletCollision\GIM_BVH_TREE_NODE.java



// #endif  // GIM_BOXPRUNING_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btGImpactCollisionAlgorithm.h

/** \file btGImpactShape.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GIMPACT_BVH_CONCAVE_COLLISION_ALGORITHM_H
// #define BT_GIMPACT_BVH_CONCAVE_COLLISION_ALGORITHM_H

// #include "BulletCollision/CollisionDispatch/btActivatingCollisionAlgorithm.h"
// #include "BulletCollision/BroadphaseCollision/btDispatcher.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseInterface.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionCreateFunc.h"
// #include "BulletCollision/CollisionDispatch/btCollisionDispatcher.h"

// #include "LinearMath/btAlignedObjectArray.h"

// #include "btGImpactShape.h"
// #include "BulletCollision/CollisionShapes/btStaticPlaneShape.h"
// #include "BulletCollision/CollisionShapes/btCompoundShape.h"
// #include "BulletCollision/CollisionDispatch/btConvexConvexAlgorithm.h"
// #include "LinearMath/btIDebugDraw.h"
// #include "BulletCollision/CollisionDispatch/btCollisionObjectWrapper.h"
// Targeting ..\BulletCollision\btGImpactCollisionAlgorithm.java



//algorithm details
//#define BULLET_TRIANGLE_COLLISION 1
public static final int GIMPACT_VS_PLANE_COLLISION = 1;

// #endif  //BT_GIMPACT_BVH_CONCAVE_COLLISION_ALGORITHM_H


// Parsed from BulletCollision/Gimpact/btGImpactMassUtil.h

/** \file btGImpactMassUtil.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef GIMPACT_MASS_UTIL_H
// #define GIMPACT_MASS_UTIL_H

// #include "LinearMath/btTransform.h"

public static native @ByVal btVector3 gim_inertia_add_transformed(
	@Const @ByRef btVector3 source_inertia, @Const @ByRef btVector3 added_inertia, @Const @ByRef btTransform transform);

public static native @ByVal btVector3 gim_get_point_inertia(@Const @ByRef btVector3 point, @Cast("btScalar") double mass);

// #endif  //GIMPACT_MESH_SHAPE_H


// Parsed from BulletCollision/Gimpact/btGImpactQuantizedBvh.h

// #ifndef GIM_QUANTIZED_SET_H_INCLUDED
// #define GIM_QUANTIZED_SET_H_INCLUDED

/** \file btGImpactQuantizedBvh.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "btGImpactBvh.h"
// #include "btQuantization.h"
// #include "btGImpactQuantizedBvhStructs.h"
// Targeting ..\BulletCollision\GIM_QUANTIZED_BVH_NODE_ARRAY.java


// Targeting ..\BulletCollision\btQuantizedBvhTree.java


// Targeting ..\BulletCollision\btGImpactQuantizedBvh.java



// #endif  // GIM_BOXPRUNING_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btGImpactQuantizedBvhStructs.h

// #ifndef GIM_QUANTIZED_SET_STRUCTS_H_INCLUDED
// #define GIM_QUANTIZED_SET_STRUCTS_H_INCLUDED

/** \file btGImpactQuantizedBvh.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "btGImpactBvh.h"
// #include "btQuantization.h"
// Targeting ..\BulletCollision\BT_QUANTIZED_BVH_NODE.java



// #endif  // GIM_QUANTIZED_SET_STRUCTS_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btGImpactShape.h

/** \file btGImpactShape.h
@author Francisco Len Njera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef GIMPACT_SHAPE_H
// #define GIMPACT_SHAPE_H

// #include "BulletCollision/CollisionShapes/btCollisionShape.h"
// #include "BulletCollision/CollisionShapes/btTriangleShape.h"
// #include "BulletCollision/CollisionShapes/btStridingMeshInterface.h"
// #include "BulletCollision/CollisionShapes/btCollisionMargin.h"
// #include "BulletCollision/CollisionDispatch/btCollisionWorld.h"
// #include "BulletCollision/CollisionShapes/btConcaveShape.h"
// #include "BulletCollision/CollisionShapes/btTetrahedronShape.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "LinearMath/btAlignedObjectArray.h"

// #include "btGImpactQuantizedBvh.h"  // box tree class

/** declare Quantized trees, (you can change to float based trees) */

/** enum eGIMPACT_SHAPE_TYPE */
public static final int
	CONST_GIMPACT_COMPOUND_SHAPE = 0,
	CONST_GIMPACT_TRIMESH_SHAPE_PART = 1,
	CONST_GIMPACT_TRIMESH_SHAPE = 2;
// Targeting ..\BulletCollision\btTetrahedronShapeEx.java


// Targeting ..\BulletCollision\btGImpactShapeInterface.java


// Targeting ..\BulletCollision\btGImpactCompoundShape.java


// Targeting ..\BulletCollision\btGImpactMeshShapePart.java


// Targeting ..\BulletCollision\btGImpactMeshShape.java


// Targeting ..\BulletCollision\btGImpactMeshShapeData.java





// #endif  //GIMPACT_MESH_SHAPE_H


// Parsed from BulletCollision/Gimpact/btGenericPoolAllocator.h

/** \file btGenericPoolAllocator.h
@author Francisco Leon Najera. email projectileman\yahoo.com
<p>
General purpose allocator class
*/
/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GENERIC_POOL_ALLOCATOR_H
// #define BT_GENERIC_POOL_ALLOCATOR_H

// #include <limits.h>
// #include <stdio.h>
// #include <string.h>
// #include "LinearMath/btAlignedAllocator.h"

// #define BT_UINT_MAX UINT_MAX
public static final int BT_DEFAULT_MAX_POOLS = 16;
// Targeting ..\BulletCollision\btGenericMemoryPool.java


// Targeting ..\BulletCollision\btGenericPoolAllocator.java



public static native Pointer btPoolAlloc(@Cast("size_t") long size);
public static native Pointer btPoolRealloc(Pointer ptr, @Cast("size_t") long oldsize, @Cast("size_t") long newsize);
public static native void btPoolFree(Pointer ptr);

// #endif


// Parsed from BulletCollision/Gimpact/btGeometryOperations.h

// #ifndef BT_BASIC_GEOMETRY_OPERATIONS_H_INCLUDED
// #define BT_BASIC_GEOMETRY_OPERATIONS_H_INCLUDED

/** \file btGeometryOperations.h
*@author Francisco Leon Najera
<p>
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "btBoxCollision.h"

public static final double PLANEDIREPSILON = 0.0000001f;
public static final double PARALELENORMALS = 0.000001f;

// #define BT_CLAMP(number, minval, maxval) (number < minval ? minval : (number > maxval ? maxval : number))

/** Calc a plane from a triangle edge an a normal. plane is a vec4f */
public static native void bt_edge_plane(@Const @ByRef btVector3 e1, @Const @ByRef btVector3 e2, @Const @ByRef btVector3 normal, @ByRef btVector4 plane);

//***************** SEGMENT and LINE FUNCTIONS **********************************///

/** Finds the closest point(cp) to (v) on a segment (e1,e2)
 */
public static native void bt_closest_point_on_segment(
	@ByRef btVector3 cp, @Const @ByRef btVector3 v,
	@Const @ByRef btVector3 e1, @Const @ByRef btVector3 e2);

/** line plane collision
/**
*@return
	-0  if the ray never intersects
	-1 if the ray collides in front
	-2 if the ray collides in back
*/

public static native int bt_line_plane_collision(
	@Const @ByRef btVector4 plane,
	@Const @ByRef btVector3 vDir,
	@Const @ByRef btVector3 vPoint,
	@ByRef btVector3 pout,
	@Cast("btScalar*") @ByRef DoublePointer tparam,
	@Cast("btScalar") double tmin, @Cast("btScalar") double tmax);
public static native int bt_line_plane_collision(
	@Const @ByRef btVector4 plane,
	@Const @ByRef btVector3 vDir,
	@Const @ByRef btVector3 vPoint,
	@ByRef btVector3 pout,
	@Cast("btScalar*") @ByRef DoubleBuffer tparam,
	@Cast("btScalar") double tmin, @Cast("btScalar") double tmax);
public static native int bt_line_plane_collision(
	@Const @ByRef btVector4 plane,
	@Const @ByRef btVector3 vDir,
	@Const @ByRef btVector3 vPoint,
	@ByRef btVector3 pout,
	@Cast("btScalar*") @ByRef double[] tparam,
	@Cast("btScalar") double tmin, @Cast("btScalar") double tmax);

/** Find closest points on segments */
public static native void bt_segment_collision(
	@Const @ByRef btVector3 vA1,
	@Const @ByRef btVector3 vA2,
	@Const @ByRef btVector3 vB1,
	@Const @ByRef btVector3 vB2,
	@ByRef btVector3 vPointA,
	@ByRef btVector3 vPointB);

// #endif  // GIM_VECTOR_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btQuantization.h

// #ifndef BT_GIMPACT_QUANTIZATION_H_INCLUDED
// #define BT_GIMPACT_QUANTIZATION_H_INCLUDED

/** \file btQuantization.h
*@author Francisco Leon Najera
<p>
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #include "LinearMath/btTransform.h"

public static native void bt_calc_quantization_parameters(
	@ByRef btVector3 outMinBound,
	@ByRef btVector3 outMaxBound,
	@ByRef btVector3 bvhQuantization,
	@Const @ByRef btVector3 srcMinBound, @Const @ByRef btVector3 srcMaxBound,
	@Cast("btScalar") double quantizationMargin);

public static native void bt_quantize_clamp(
	@Cast("unsigned short*") ShortPointer out,
	@Const @ByRef btVector3 point,
	@Const @ByRef btVector3 min_bound,
	@Const @ByRef btVector3 max_bound,
	@Const @ByRef btVector3 bvhQuantization);
public static native void bt_quantize_clamp(
	@Cast("unsigned short*") ShortBuffer out,
	@Const @ByRef btVector3 point,
	@Const @ByRef btVector3 min_bound,
	@Const @ByRef btVector3 max_bound,
	@Const @ByRef btVector3 bvhQuantization);
public static native void bt_quantize_clamp(
	@Cast("unsigned short*") short[] out,
	@Const @ByRef btVector3 point,
	@Const @ByRef btVector3 min_bound,
	@Const @ByRef btVector3 max_bound,
	@Const @ByRef btVector3 bvhQuantization);

public static native @ByVal btVector3 bt_unquantize(
	@Cast("const unsigned short*") ShortPointer vecIn,
	@Const @ByRef btVector3 offset,
	@Const @ByRef btVector3 bvhQuantization);
public static native @ByVal btVector3 bt_unquantize(
	@Cast("const unsigned short*") ShortBuffer vecIn,
	@Const @ByRef btVector3 offset,
	@Const @ByRef btVector3 bvhQuantization);
public static native @ByVal btVector3 bt_unquantize(
	@Cast("const unsigned short*") short[] vecIn,
	@Const @ByRef btVector3 offset,
	@Const @ByRef btVector3 bvhQuantization);

// #endif  // BT_GIMPACT_QUANTIZATION_H_INCLUDED


// Parsed from BulletCollision/Gimpact/btTriangleShapeEx.h

/** \file btGImpactShape.h
@author Francisco Leon Najera
*/
/*
This source file is part of GIMPACT Library.

For the latest info, see http://gimpact.sourceforge.net/

Copyright (c) 2007 Francisco Leon Najera. C.C. 80087371.
email: projectileman@yahoo.com


This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef GIMPACT_TRIANGLE_SHAPE_EX_H
// #define GIMPACT_TRIANGLE_SHAPE_EX_H

// #include "BulletCollision/CollisionShapes/btCollisionShape.h"
// #include "BulletCollision/CollisionShapes/btTriangleShape.h"
// #include "btBoxCollision.h"
// #include "btClipPolygon.h"
// #include "btGeometryOperations.h"

public static final int MAX_TRI_CLIPPING = 16;
// Targeting ..\BulletCollision\GIM_TRIANGLE_CONTACT.java


// Targeting ..\BulletCollision\btPrimitiveTriangle.java


// Targeting ..\BulletCollision\btTriangleShapeEx.java



// #endif  //GIMPACT_TRIANGLE_MESH_SHAPE_H


// Parsed from BulletCollision/Gimpact/gim_pair.h

// #ifndef GIM_PAIR_H
// #define GIM_PAIR_H
// Targeting ..\BulletCollision\GIM_PAIR.java



// #endif //GIM_PAIR_H



}
