// Targeted by JavaCPP version 1.5.8: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.global;

import org.bytedeco.bullet.BulletDynamics.*;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;
import org.bytedeco.bullet.BulletCollision.*;
import static org.bytedeco.bullet.global.BulletCollision.*;

public class BulletDynamics extends org.bytedeco.bullet.presets.BulletDynamics {
    static { Loader.load(); }

// Parsed from LinearMath/btAlignedObjectArray.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_OBJECT_ARRAY__
// #define BT_OBJECT_ARRAY__

// #include "btScalar.h"  // has definitions like SIMD_FORCE_INLINE
// #include "btAlignedAllocator.h"

/**If the platform doesn't support placement new, you can disable BT_USE_PLACEMENT_NEW
 * then the btAlignedObjectArray doesn't support objects with virtual methods, and non-trivial constructors/destructors
 * You can enable BT_USE_MEMCPY, then swapping elements in the array will use memcpy instead of operator=
 * see discussion here: https://bulletphysics.orgphpBB2/viewtopic.php?t=1231 and
 * http://www.continuousphysics.com/Bullet/phpBB2/viewtopic.php?t=1240 */

public static final int BT_USE_PLACEMENT_NEW = 1;
//#define BT_USE_MEMCPY 1 //disable, because it is cumbersome to find out for each platform where memcpy is defined. It can be in <memory.h> or <string.h> or otherwise...
// #define BT_ALLOW_ARRAY_COPY_OPERATOR  // enabling this can accidently perform deep copies of data if you are not careful

// #ifdef BT_USE_MEMCPY
// #include <memory.h>
// #include <string.h>
// #endif  //BT_USE_MEMCPY

// #ifdef BT_USE_PLACEMENT_NEW
// #include <new>
// Targeting ..\BulletDynamics\RangeArray.java


// Targeting ..\BulletDynamics\btMultiBodyConstraintArray.java


// Targeting ..\BulletDynamics\btMultiBodySolverConstraintArray.java


// Targeting ..\BulletDynamics\btRigidBodyArray.java


// Targeting ..\BulletDynamics\JointParamsArray.java


// Targeting ..\BulletDynamics\IslandArray.java


// Targeting ..\BulletDynamics\btSolverAnalyticsDataArray.java


// Targeting ..\BulletDynamics\btSolverBodyArray.java


// Targeting ..\BulletDynamics\btSolverConstraintArray.java


// Targeting ..\BulletDynamics\btTypedConstraintArray.java


// Targeting ..\BulletDynamics\btWheelInfoArray.java



// #endif  //BT_OBJECT_ARRAY__


// Parsed from BulletDynamics/ConstraintSolver/btBatchedConstraints.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_BATCHED_CONSTRAINTS_H
// #define BT_BATCHED_CONSTRAINTS_H

// #include "LinearMath/btThreads.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "BulletDynamics/ConstraintSolver/btSolverBody.h"
// #include "BulletDynamics/ConstraintSolver/btSolverConstraint.h"
// Targeting ..\BulletDynamics\btBatchedConstraints.java



// #endif  // BT_BATCHED_CONSTRAINTS_H


// Parsed from BulletDynamics/ConstraintSolver/btConeTwistConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
btConeTwistConstraint is Copyright (c) 2007 Starbreeze Studios

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.

Written by: Marcus Hennix
*/

/*
Overview:

btConeTwistConstraint can be used to simulate ragdoll joints (upper arm, leg etc).
It is a fixed translation, 3 degree-of-freedom (DOF) rotational "joint".
It divides the 3 rotational DOFs into swing (movement within a cone) and twist.
Swing is divided into swing1 and swing2 which can have different limits, giving an elliptical shape.
(Note: the cone's base isn't flat, so this ellipse is "embedded" on the surface of a sphere.)

In the contraint's frame of reference:
twist is along the x-axis,
and swing 1 and 2 are along the z and y axes respectively.
*/

// #ifndef BT_CONETWISTCONSTRAINT_H
// #define BT_CONETWISTCONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btConeTwistConstraintData2 btConeTwistConstraintDoubleData
public static final String btConeTwistConstraintDataName = "btConeTwistConstraintDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

/** enum btConeTwistFlags */
public static final int
	BT_CONETWIST_FLAGS_LIN_CFM = 1,
	BT_CONETWIST_FLAGS_LIN_ERP = 2,
	BT_CONETWIST_FLAGS_ANG_CFM = 4;
// Targeting ..\BulletDynamics\btConeTwistConstraint.java


// Targeting ..\BulletDynamics\btConeTwistConstraintDoubleData.java


// Targeting ..\BulletDynamics\btConeTwistConstraintData.java


// #endif  //BT_BACKWARDS_COMPATIBLE_SERIALIZATION
//



/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_CONETWISTCONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btConstraintSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONSTRAINT_SOLVER_H
// #define BT_CONSTRAINT_SOLVER_H

// #include "LinearMath/btScalar.h"
/** btConstraintSolver provides solver interface */

/** enum btConstraintSolverType */
public static final int
	BT_SEQUENTIAL_IMPULSE_SOLVER = 1,
	BT_MLCP_SOLVER = 2,
	BT_NNCG_SOLVER = 4,
	BT_MULTIBODY_SOLVER = 8,
	BT_BLOCK_SOLVER = 16;
// Targeting ..\BulletDynamics\btConstraintSolver.java



// #endif  //BT_CONSTRAINT_SOLVER_H


// Parsed from BulletDynamics/ConstraintSolver/btContactConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONTACT_CONSTRAINT_H
// #define BT_CONTACT_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"
// #include "BulletCollision/NarrowPhaseCollision/btPersistentManifold.h"
// Targeting ..\BulletDynamics\btContactConstraint.java



/**very basic collision resolution without friction */
public static native @Cast("btScalar") double resolveSingleCollision(btRigidBody body1, btCollisionObject colObj2, @Const @ByRef btVector3 contactPositionWorld, @Const @ByRef btVector3 contactNormalOnB, @Const @ByRef btContactSolverInfo solverInfo, @Cast("btScalar") double distance);

/**resolveSingleBilateral is an obsolete methods used for vehicle friction between two dynamic objects */
public static native void resolveSingleBilateral(@ByRef btRigidBody body1, @Const @ByRef btVector3 pos1,
							@ByRef btRigidBody body2, @Const @ByRef btVector3 pos2,
							@Cast("btScalar") double distance, @Const @ByRef btVector3 normal, @Cast("btScalar*") @ByRef DoublePointer impulse, @Cast("btScalar") double timeStep);
public static native void resolveSingleBilateral(@ByRef btRigidBody body1, @Const @ByRef btVector3 pos1,
							@ByRef btRigidBody body2, @Const @ByRef btVector3 pos2,
							@Cast("btScalar") double distance, @Const @ByRef btVector3 normal, @Cast("btScalar*") @ByRef DoubleBuffer impulse, @Cast("btScalar") double timeStep);
public static native void resolveSingleBilateral(@ByRef btRigidBody body1, @Const @ByRef btVector3 pos1,
							@ByRef btRigidBody body2, @Const @ByRef btVector3 pos2,
							@Cast("btScalar") double distance, @Const @ByRef btVector3 normal, @Cast("btScalar*") @ByRef double[] impulse, @Cast("btScalar") double timeStep);

// #endif  //BT_CONTACT_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btContactSolverInfo.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CONTACT_SOLVER_INFO
// #define BT_CONTACT_SOLVER_INFO

// #include "LinearMath/btScalar.h"

/** enum btSolverMode */
public static final int
	SOLVER_RANDMIZE_ORDER = 1,
	SOLVER_FRICTION_SEPARATE = 2,
	SOLVER_USE_WARMSTARTING = 4,
	SOLVER_USE_2_FRICTION_DIRECTIONS = 16,
	SOLVER_ENABLE_FRICTION_DIRECTION_CACHING = 32,
	SOLVER_DISABLE_VELOCITY_DEPENDENT_FRICTION_DIRECTION = 64,
	SOLVER_CACHE_FRIENDLY = 128,
	SOLVER_SIMD = 256,
	SOLVER_INTERLEAVE_CONTACT_AND_FRICTION_CONSTRAINTS = 512,
	SOLVER_ALLOW_ZERO_LENGTH_FRICTION_DIRECTIONS = 1024,
	SOLVER_DISABLE_IMPLICIT_CONE_FRICTION = 2048,
	SOLVER_USE_ARTICULATED_WARMSTARTING = 4096;
// Targeting ..\BulletDynamics\btContactSolverInfoData.java


// Targeting ..\BulletDynamics\btContactSolverInfo.java


// Targeting ..\BulletDynamics\btContactSolverInfoDoubleData.java


// Targeting ..\BulletDynamics\btContactSolverInfoFloatData.java



// #endif  //BT_CONTACT_SOLVER_INFO


// Parsed from BulletDynamics/ConstraintSolver/btFixedConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_FIXED_CONSTRAINT_H
// #define BT_FIXED_CONSTRAINT_H

// #include "btGeneric6DofSpring2Constraint.h"
// Targeting ..\BulletDynamics\btFixedConstraint.java



// #endif  //BT_FIXED_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btGearConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2012 Advanced Micro Devices, Inc.  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GEAR_CONSTRAINT_H
// #define BT_GEAR_CONSTRAINT_H

// #include "BulletDynamics/ConstraintSolver/btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btGearConstraintData btGearConstraintDoubleData
public static final String btGearConstraintDataName = "btGearConstraintDoubleData";
// Targeting ..\BulletDynamics\btGearConstraint.java


// Targeting ..\BulletDynamics\btGearConstraintFloatData.java


// Targeting ..\BulletDynamics\btGearConstraintDoubleData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_GEAR_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btGeneric6DofConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/** 2009 March: btGeneric6DofConstraint refactored by Roman Ponomarev
/** Added support for generic constraint solver through getInfo1/getInfo2 methods */

/*
2007-09-09
btGeneric6DofConstraint Refactored by Francisco Le?n
email: projectileman@yahoo.com
http://gimpact.sf.net
*/

// #ifndef BT_GENERIC_6DOF_CONSTRAINT_H
// #define BT_GENERIC_6DOF_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btGeneric6DofConstraintData2 btGeneric6DofConstraintDoubleData2
public static final String btGeneric6DofConstraintDataName = "btGeneric6DofConstraintDoubleData2";
// Targeting ..\BulletDynamics\btRotationalLimitMotor.java


// Targeting ..\BulletDynamics\btTranslationalLimitMotor.java



/** enum bt6DofFlags */
public static final int
	BT_6DOF_FLAGS_CFM_NORM = 1,
	BT_6DOF_FLAGS_CFM_STOP = 2,
	BT_6DOF_FLAGS_ERP_STOP = 4;
public static final int BT_6DOF_FLAGS_AXIS_SHIFT = 3;
// Targeting ..\BulletDynamics\btGeneric6DofConstraint.java


// Targeting ..\BulletDynamics\btGeneric6DofConstraintData.java


// Targeting ..\BulletDynamics\btGeneric6DofConstraintDoubleData2.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_GENERIC_6DOF_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btGeneric6DofSpring2Constraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
2014 May: btGeneric6DofSpring2Constraint is created from the original (2.82.2712) btGeneric6DofConstraint by Gabor Puhr and Tamas Umenhoffer
Pros:
- Much more accurate and stable in a lot of situation. (Especially when a sleeping chain of RBs connected with 6dof2 is pulled)
- Stable and accurate spring with minimal energy loss that works with all of the solvers. (latter is not true for the original 6dof spring)
- Servo motor functionality
- Much more accurate bouncing. 0 really means zero bouncing (not true for the original 6odf) and there is only a minimal energy loss when the value is 1 (because of the solvers' precision)
- Rotation order for the Euler system can be set. (One axis' freedom is still limited to pi/2)

Cons:
- It is slower than the original 6dof. There is no exact ratio, but half speed is a good estimation.
- At bouncing the correct velocity is calculated, but not the correct position. (it is because of the solver can correct position or velocity, but not both.)
*/

/** 2009 March: btGeneric6DofConstraint refactored by Roman Ponomarev
/** Added support for generic constraint solver through getInfo1/getInfo2 methods */

/*
2007-09-09
btGeneric6DofConstraint Refactored by Francisco Le?n
email: projectileman@yahoo.com
http://gimpact.sf.net
*/

// #ifndef BT_GENERIC_6DOF_CONSTRAINT2_H
// #define BT_GENERIC_6DOF_CONSTRAINT2_H

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btGeneric6DofSpring2ConstraintData2 btGeneric6DofSpring2ConstraintDoubleData2
public static final String btGeneric6DofSpring2ConstraintDataName = "btGeneric6DofSpring2ConstraintDoubleData2";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

/** enum RotateOrder */
public static final int
	RO_XYZ = 0,
	RO_XZY = 1,
	RO_YXZ = 2,
	RO_YZX = 3,
	RO_ZXY = 4,
	RO_ZYX = 5;
// Targeting ..\BulletDynamics\btRotationalLimitMotor2.java


// Targeting ..\BulletDynamics\btTranslationalLimitMotor2.java



/** enum bt6DofFlags2 */
public static final int
	BT_6DOF_FLAGS_CFM_STOP2 = 1,
	BT_6DOF_FLAGS_ERP_STOP2 = 2,
	BT_6DOF_FLAGS_CFM_MOTO2 = 4,
	BT_6DOF_FLAGS_ERP_MOTO2 = 8,
	BT_6DOF_FLAGS_USE_INFINITE_ERROR = (1<<16);
public static final int BT_6DOF_FLAGS_AXIS_SHIFT2 = 4;
// Targeting ..\BulletDynamics\btGeneric6DofSpring2Constraint.java


// Targeting ..\BulletDynamics\btGeneric6DofSpring2ConstraintData.java


// Targeting ..\BulletDynamics\btGeneric6DofSpring2ConstraintDoubleData2.java







// #endif  //BT_GENERIC_6DOF_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btGeneric6DofSpringConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library, http://bulletphysics.org
Copyright (C) 2006, 2007 Sony Computer Entertainment Inc. 

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_GENERIC_6DOF_SPRING_CONSTRAINT_H
// #define BT_GENERIC_6DOF_SPRING_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btTypedConstraint.h"
// #include "btGeneric6DofConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btGeneric6DofSpringConstraintData2 btGeneric6DofSpringConstraintDoubleData2
public static final String btGeneric6DofSpringConstraintDataName = "btGeneric6DofSpringConstraintDoubleData2";
// Targeting ..\BulletDynamics\btGeneric6DofSpringConstraint.java


// Targeting ..\BulletDynamics\btGeneric6DofSpringConstraintData.java


// Targeting ..\BulletDynamics\btGeneric6DofSpringConstraintDoubleData2.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  // BT_GENERIC_6DOF_SPRING_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btHinge2Constraint.h

/*
Bullet Continuous Collision Detection and Physics Library, http://bulletphysics.org
Copyright (C) 2006, 2007 Sony Computer Entertainment Inc. 

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_HINGE2_CONSTRAINT_H
// #define BT_HINGE2_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btTypedConstraint.h"
// #include "btGeneric6DofSpring2Constraint.h"
// Targeting ..\BulletDynamics\btHinge2Constraint.java



// #endif  // BT_HINGE2_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btHingeConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/* Hinge Constraint by Dirk Gregorius. Limits added by Marcus Hennix at Starbreeze Studios */

// #ifndef BT_HINGECONSTRAINT_H
// #define BT_HINGECONSTRAINT_H

public static final int _BT_USE_CENTER_LIMIT_ = 1;

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btHingeConstraintData btHingeConstraintDoubleData2  //rename to 2 for backwards compatibility, so we can still load the 'btHingeConstraintDoubleData' version
public static final String btHingeConstraintDataName = "btHingeConstraintDoubleData2";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

/** enum btHingeFlags */
public static final int
	BT_HINGE_FLAGS_CFM_STOP = 1,
	BT_HINGE_FLAGS_ERP_STOP = 2,
	BT_HINGE_FLAGS_CFM_NORM = 4,
	BT_HINGE_FLAGS_ERP_NORM = 8;
// Targeting ..\BulletDynamics\btHingeConstraint.java


// Targeting ..\BulletDynamics\btHingeConstraintDoubleData.java


// Targeting ..\BulletDynamics\btHingeAccumulatedAngleConstraint.java


// Targeting ..\BulletDynamics\btHingeConstraintFloatData.java


// Targeting ..\BulletDynamics\btHingeConstraintDoubleData2.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_HINGECONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btJacobianEntry.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_JACOBIAN_ENTRY_H
// #define BT_JACOBIAN_ENTRY_H

// #include "LinearMath/btMatrix3x3.h"
// Targeting ..\BulletDynamics\btJacobianEntry.java



// #endif  //BT_JACOBIAN_ENTRY_H


// Parsed from BulletDynamics/ConstraintSolver/btNNCGConstraintSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_NNCG_CONSTRAINT_SOLVER_H
// #define BT_NNCG_CONSTRAINT_SOLVER_H

// #include "btSequentialImpulseConstraintSolver.h"
// Targeting ..\BulletDynamics\btNNCGConstraintSolver.java



// #endif  //BT_NNCG_CONSTRAINT_SOLVER_H


// Parsed from BulletDynamics/ConstraintSolver/btPoint2PointConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_POINT2POINTCONSTRAINT_H
// #define BT_POINT2POINTCONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btPoint2PointConstraintData2 btPoint2PointConstraintDoubleData2
public static final String btPoint2PointConstraintDataName = "btPoint2PointConstraintDoubleData2";
// Targeting ..\BulletDynamics\btConstraintSetting.java



/** enum btPoint2PointFlags */
public static final int
	BT_P2P_FLAGS_ERP = 1,
	BT_P2P_FLAGS_CFM = 2;
// Targeting ..\BulletDynamics\btPoint2PointConstraint.java


// Targeting ..\BulletDynamics\btPoint2PointConstraintFloatData.java


// Targeting ..\BulletDynamics\btPoint2PointConstraintDoubleData2.java


// Targeting ..\BulletDynamics\btPoint2PointConstraintDoubleData.java


// #endif  //BT_BACKWARDS_COMPATIBLE_SERIALIZATION



/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_POINT2POINTCONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_H
// #define BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_H
// #include "BulletDynamics/ConstraintSolver/btTypedConstraint.h"
// #include "BulletDynamics/ConstraintSolver/btContactSolverInfo.h"
// #include "BulletDynamics/ConstraintSolver/btSolverBody.h"
// #include "BulletDynamics/ConstraintSolver/btSolverConstraint.h"
// #include "BulletCollision/NarrowPhaseCollision/btManifoldPoint.h"
// #include "BulletDynamics/ConstraintSolver/btConstraintSolver.h"
// Targeting ..\BulletDynamics\btSingleConstraintRowSolver.java


// Targeting ..\BulletDynamics\btSolverAnalyticsData.java


// Targeting ..\BulletDynamics\btSequentialImpulseConstraintSolver.java



// #endif  //BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_H


// Parsed from BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolverMt.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_MT_H
// #define BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_MT_H

// #include "btSequentialImpulseConstraintSolver.h"
// #include "btBatchedConstraints.h"


///
///
///
///
///
///
///
// #include "LinearMath/btThreads.h"
// Targeting ..\BulletDynamics\btSequentialImpulseConstraintSolverMt.java



// #endif  //BT_SEQUENTIAL_IMPULSE_CONSTRAINT_SOLVER_MT_H


// Parsed from BulletDynamics/ConstraintSolver/btSliderConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/*
Added by Roman Ponomarev (rponom@gmail.com)
April 04, 2008

TODO:
 - add clamping od accumulated impulse to improve stability
 - add conversion for ODE constraint solver
*/

// #ifndef BT_SLIDER_CONSTRAINT_H
// #define BT_SLIDER_CONSTRAINT_H

// #include "LinearMath/btScalar.h"  //for BT_USE_DOUBLE_PRECISION

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btSliderConstraintData2 btSliderConstraintDoubleData
public static final String btSliderConstraintDataName = "btSliderConstraintDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

// #include "LinearMath/btVector3.h"
// #include "btJacobianEntry.h"
// #include "btTypedConstraint.h"

public static native @MemberGetter double SLIDER_CONSTRAINT_DEF_SOFTNESS();
public static final double SLIDER_CONSTRAINT_DEF_SOFTNESS = SLIDER_CONSTRAINT_DEF_SOFTNESS();
public static native @MemberGetter double SLIDER_CONSTRAINT_DEF_DAMPING();
public static final double SLIDER_CONSTRAINT_DEF_DAMPING = SLIDER_CONSTRAINT_DEF_DAMPING();
public static native @MemberGetter double SLIDER_CONSTRAINT_DEF_RESTITUTION();
public static final double SLIDER_CONSTRAINT_DEF_RESTITUTION = SLIDER_CONSTRAINT_DEF_RESTITUTION();
public static native @MemberGetter double SLIDER_CONSTRAINT_DEF_CFM();
public static final double SLIDER_CONSTRAINT_DEF_CFM = SLIDER_CONSTRAINT_DEF_CFM();

/** enum btSliderFlags */
public static final int
	BT_SLIDER_FLAGS_CFM_DIRLIN = (1 << 0),
	BT_SLIDER_FLAGS_ERP_DIRLIN = (1 << 1),
	BT_SLIDER_FLAGS_CFM_DIRANG = (1 << 2),
	BT_SLIDER_FLAGS_ERP_DIRANG = (1 << 3),
	BT_SLIDER_FLAGS_CFM_ORTLIN = (1 << 4),
	BT_SLIDER_FLAGS_ERP_ORTLIN = (1 << 5),
	BT_SLIDER_FLAGS_CFM_ORTANG = (1 << 6),
	BT_SLIDER_FLAGS_ERP_ORTANG = (1 << 7),
	BT_SLIDER_FLAGS_CFM_LIMLIN = (1 << 8),
	BT_SLIDER_FLAGS_ERP_LIMLIN = (1 << 9),
	BT_SLIDER_FLAGS_CFM_LIMANG = (1 << 10),
	BT_SLIDER_FLAGS_ERP_LIMANG = (1 << 11);
// Targeting ..\BulletDynamics\btSliderConstraint.java


// Targeting ..\BulletDynamics\btSliderConstraintData.java


// Targeting ..\BulletDynamics\btSliderConstraintDoubleData.java





/**fills the dataBuffer and returns the struct name (and 0 on failure) */


// #endif  //BT_SLIDER_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btSolve2LinearConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOLVE_2LINEAR_CONSTRAINT_H
// #define BT_SOLVE_2LINEAR_CONSTRAINT_H

// #include "LinearMath/btMatrix3x3.h"
// #include "LinearMath/btVector3.h"
// Targeting ..\BulletDynamics\btSolve2LinearConstraint.java



// #endif  //BT_SOLVE_2LINEAR_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btSolverBody.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOLVER_BODY_H
// #define BT_SOLVER_BODY_H
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btMatrix3x3.h"

// #include "LinearMath/btAlignedAllocator.h"
// #include "LinearMath/btTransformUtil.h"

/**Until we get other contributions, only use SIMD on Windows, when using Visual Studio 2008 or later, and not double precision */
// #ifdef BT_USE_SSE
// #endif  //

// #ifdef USE_SIMD

// #else
// #define btSimdScalar btScalar
// Targeting ..\BulletDynamics\btSolverBody.java



// #endif  //BT_SOLVER_BODY_H


// Parsed from BulletDynamics/ConstraintSolver/btSolverConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SOLVER_CONSTRAINT_H
// #define BT_SOLVER_CONSTRAINT_H
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "btJacobianEntry.h"
// #include "LinearMath/btAlignedObjectArray.h"

//#define NO_FRICTION_TANGENTIALS 1
// #include "btSolverBody.h"
// Targeting ..\BulletDynamics\btSolverConstraint.java



// #endif  //BT_SOLVER_CONSTRAINT_H


// Parsed from BulletDynamics/Dynamics/btRigidBody.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_RIGIDBODY_H
// #define BT_RIGIDBODY_H

// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btTransform.h"
// #include "BulletCollision/BroadphaseCollision/btBroadphaseProxy.h"
// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"

public static native @Cast("btScalar") double gDeactivationTime(); public static native void gDeactivationTime(double setter);
public static native @Cast("bool") boolean gDisableDeactivation(); public static native void gDisableDeactivation(boolean setter);

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btRigidBodyData btRigidBodyDoubleData
public static final String btRigidBodyDataName = "btRigidBodyDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

/** enum btRigidBodyFlags */
public static final int
	BT_DISABLE_WORLD_GRAVITY = 1,
	/**BT_ENABLE_GYROPSCOPIC_FORCE flags is enabled by default in Bullet 2.83 and onwards.
	 * and it BT_ENABLE_GYROPSCOPIC_FORCE becomes equivalent to BT_ENABLE_GYROSCOPIC_FORCE_IMPLICIT_BODY
	 * See Demos/GyroscopicDemo and computeGyroscopicImpulseImplicit */
	BT_ENABLE_GYROSCOPIC_FORCE_EXPLICIT = 2,
	BT_ENABLE_GYROSCOPIC_FORCE_IMPLICIT_WORLD = 4,
	BT_ENABLE_GYROSCOPIC_FORCE_IMPLICIT_BODY = 8,
	BT_ENABLE_GYROPSCOPIC_FORCE = BT_ENABLE_GYROSCOPIC_FORCE_IMPLICIT_BODY;
// Targeting ..\BulletDynamics\btRigidBody.java


// Targeting ..\BulletDynamics\btRigidBodyFloatData.java


// Targeting ..\BulletDynamics\btRigidBodyDoubleData.java



// #endif  //BT_RIGIDBODY_H


// Parsed from BulletDynamics/ConstraintSolver/btTypedConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2010 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_TYPED_CONSTRAINT_H
// #define BT_TYPED_CONSTRAINT_H

// #include "LinearMath/btScalar.h"
// #include "btSolverConstraint.h"
// #include "BulletDynamics/Dynamics/btRigidBody.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btTypedConstraintData2 btTypedConstraintDoubleData
public static final String btTypedConstraintDataName = "btTypedConstraintDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

//Don't change any of the existing enum values, so add enum types at the end for serialization compatibility
/** enum btTypedConstraintType */
public static final int
	POINT2POINT_CONSTRAINT_TYPE = 3,
	HINGE_CONSTRAINT_TYPE = 4,
	CONETWIST_CONSTRAINT_TYPE = 5,
	D6_CONSTRAINT_TYPE = 6,
	SLIDER_CONSTRAINT_TYPE = 7,
	CONTACT_CONSTRAINT_TYPE = 8,
	D6_SPRING_CONSTRAINT_TYPE = 9,
	GEAR_CONSTRAINT_TYPE = 10,
	FIXED_CONSTRAINT_TYPE = 11,
	D6_SPRING_2_CONSTRAINT_TYPE = 12,
	MAX_CONSTRAINT_TYPE = 13;

/** enum btConstraintParams */
public static final int
	BT_CONSTRAINT_ERP = 1,
	BT_CONSTRAINT_STOP_ERP = 2,
	BT_CONSTRAINT_CFM = 3,
	BT_CONSTRAINT_STOP_CFM = 4;

// #if 1
// #define btAssertConstrParams(_par) btAssert(_par)
// #else
// #define btAssertConstrParams(_par)
// Targeting ..\BulletDynamics\btJointFeedback.java


// Targeting ..\BulletDynamics\btTypedConstraint.java



// returns angle in range [-SIMD_2_PI, SIMD_2_PI], closest to one of the limits
// all arguments should be normalized angles (i.e. in range [-SIMD_PI, SIMD_PI])
public static native @Cast("btScalar") double btAdjustAngleToLimits(@Cast("btScalar") double angleInRadians, @Cast("btScalar") double angleLowerLimitInRadians, @Cast("btScalar") double angleUpperLimitInRadians);
// Targeting ..\BulletDynamics\btTypedConstraintFloatData.java





/**do not change those serialization structures, it requires an updated sBulletDNAstr/sBulletDNAstr64 */

// #define BT_BACKWARDS_COMPATIBLE_SERIALIZATION
// Targeting ..\BulletDynamics\btTypedConstraintData.java


// Targeting ..\BulletDynamics\btTypedConstraintDoubleData.java



// clang-format on


// Targeting ..\BulletDynamics\btAngularLimit.java



// #endif  //BT_TYPED_CONSTRAINT_H


// Parsed from BulletDynamics/ConstraintSolver/btUniversalConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library, http://bulletphysics.org
Copyright (C) 2006, 2007 Sony Computer Entertainment Inc. 

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_UNIVERSAL_CONSTRAINT_H
// #define BT_UNIVERSAL_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "btTypedConstraint.h"
// #include "btGeneric6DofConstraint.h"
// Targeting ..\BulletDynamics\btUniversalConstraint.java



// #endif  // BT_UNIVERSAL_CONSTRAINT_H


// Parsed from BulletDynamics/Dynamics/btActionInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef _BT_ACTION_INTERFACE_H
// #define _BT_ACTION_INTERFACE_H

// #include "LinearMath/btScalar.h"
// #include "btRigidBody.h"
// Targeting ..\BulletDynamics\btActionInterface.java



// #endif  //_BT_ACTION_INTERFACE_H


// Parsed from BulletDynamics/Dynamics/btDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DYNAMICS_WORLD_H
// #define BT_DYNAMICS_WORLD_H

// #include "BulletCollision/CollisionDispatch/btCollisionWorld.h"
// #include "BulletDynamics/ConstraintSolver/btContactSolverInfo.h"
// Targeting ..\BulletDynamics\btInternalTickCallback.java



/** enum btDynamicsWorldType */
public static final int
	BT_SIMPLE_DYNAMICS_WORLD = 1,
	BT_DISCRETE_DYNAMICS_WORLD = 2,
	BT_CONTINUOUS_DYNAMICS_WORLD = 3,
	BT_SOFT_RIGID_DYNAMICS_WORLD = 4,
	BT_GPU_DYNAMICS_WORLD = 5,
	BT_SOFT_MULTIBODY_DYNAMICS_WORLD = 6,
    BT_DEFORMABLE_MULTIBODY_DYNAMICS_WORLD = 7;
// Targeting ..\BulletDynamics\btDynamicsWorld.java


// Targeting ..\BulletDynamics\btDynamicsWorldDoubleData.java


// Targeting ..\BulletDynamics\btDynamicsWorldFloatData.java



// #endif  //BT_DYNAMICS_WORLD_H


// Parsed from BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DISCRETE_DYNAMICS_WORLD_H
// #define BT_DISCRETE_DYNAMICS_WORLD_H

// #include "btDynamicsWorld.h"
// Targeting ..\BulletDynamics\InplaceSolverIslandCallback.java



// #include "LinearMath/btAlignedObjectArray.h"
// #include "LinearMath/btThreads.h"
// Targeting ..\BulletDynamics\btDiscreteDynamicsWorld.java



// #endif  //BT_DISCRETE_DYNAMICS_WORLD_H


// Parsed from BulletDynamics/Dynamics/btDiscreteDynamicsWorldMt.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2009 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_DISCRETE_DYNAMICS_WORLD_MT_H
// #define BT_DISCRETE_DYNAMICS_WORLD_MT_H

// #include "btDiscreteDynamicsWorld.h"
// #include "btSimulationIslandManagerMt.h"


///
///
///
// #include "BulletDynamics/ConstraintSolver/btConstraintSolver.h"
// Targeting ..\BulletDynamics\btConstraintSolverPoolMt.java


// Targeting ..\BulletDynamics\btDiscreteDynamicsWorldMt.java



// #endif  //BT_DISCRETE_DYNAMICS_WORLD_H


// Parsed from BulletDynamics/Dynamics/btSimpleDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMPLE_DYNAMICS_WORLD_H
// #define BT_SIMPLE_DYNAMICS_WORLD_H

// #include "btDynamicsWorld.h"
// Targeting ..\BulletDynamics\btSimpleDynamicsWorld.java



// #endif  //BT_SIMPLE_DYNAMICS_WORLD_H


// Parsed from BulletDynamics/Dynamics/btSimulationIslandManagerMt.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2006 Erwin Coumans  https://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_SIMULATION_ISLAND_MANAGER_MT_H
// #define BT_SIMULATION_ISLAND_MANAGER_MT_H

// #include "BulletCollision/CollisionDispatch/btSimulationIslandManager.h"
// Targeting ..\BulletDynamics\btSimulationIslandManagerMt.java



// #endif  //BT_SIMULATION_ISLAND_MANAGER_H


// Parsed from BulletDynamics/Vehicle/btRaycastVehicle.h

/*
 * Copyright (c) 2005 Erwin Coumans https://bulletphysics.org
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies.
 * Erwin Coumans makes no representations about the suitability 
 * of this software for any purpose.  
 * It is provided "as is" without express or implied warranty.
*/
// #ifndef BT_RAYCASTVEHICLE_H
// #define BT_RAYCASTVEHICLE_H

// #include "BulletDynamics/Dynamics/btRigidBody.h"
// #include "BulletDynamics/ConstraintSolver/btTypedConstraint.h"
// #include "btVehicleRaycaster.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "btWheelInfo.h"
// #include "BulletDynamics/Dynamics/btActionInterface.h"
// Targeting ..\BulletDynamics\btRaycastVehicle.java


// Targeting ..\BulletDynamics\btDefaultVehicleRaycaster.java



// #endif  //BT_RAYCASTVEHICLE_H


// Parsed from BulletDynamics/Vehicle/btVehicleRaycaster.h

/*
 * Copyright (c) 2005 Erwin Coumans http://bulletphysics.org
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies.
 * Erwin Coumans makes no representations about the suitability 
 * of this software for any purpose.  
 * It is provided "as is" without express or implied warranty.
*/
// #ifndef BT_VEHICLE_RAYCASTER_H
// #define BT_VEHICLE_RAYCASTER_H

// #include "LinearMath/btVector3.h"
// Targeting ..\BulletDynamics\btVehicleRaycaster.java



// #endif  //BT_VEHICLE_RAYCASTER_H


// Parsed from BulletDynamics/Vehicle/btWheelInfo.h

/*
 * Copyright (c) 2005 Erwin Coumans https://bulletphysics.org
 *
 * Permission to use, copy, modify, distribute and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appear in all copies.
 * Erwin Coumans makes no representations about the suitability 
 * of this software for any purpose.  
 * It is provided "as is" without express or implied warranty.
*/
// #ifndef BT_WHEEL_INFO_H
// #define BT_WHEEL_INFO_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btTransform.h"
// Targeting ..\BulletDynamics\btWheelInfoConstructionInfo.java


// Targeting ..\BulletDynamics\btWheelInfo.java



// #endif  //BT_WHEEL_INFO_H


// Parsed from BulletDynamics/Featherstone/btMultiBody.h

/*
 * PURPOSE:
 *   Class representing an articulated rigid body. Stores the body's
 *   current state, allows forces and torques to be set, handles
 *   timestepping and implements Featherstone's algorithm.
 *   
 * COPYRIGHT:
 *   Copyright (C) Stephen Thompson, <stephen@solarflare.org.uk>, 2011-2013
 *   Portions written By Erwin Coumans: connection to LCP solver, various multibody constraints, replacing Eigen math library by Bullet LinearMath and a dedicated 6x6 matrix inverse (solveImatrix)
 *   Portions written By Jakub Stepien: support for multi-DOF constraints, introduction of spatial algebra and several other improvements

 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 
 */

// #ifndef BT_MULTIBODY_H
// #define BT_MULTIBODY_H

// #include "LinearMath/btScalar.h"
// #include "LinearMath/btVector3.h"
// #include "LinearMath/btQuaternion.h"
// #include "LinearMath/btMatrix3x3.h"
// #include "LinearMath/btAlignedObjectArray.h"

/**serialization data, don't change them if you are not familiar with the details of the serialization mechanisms */
// #ifdef BT_USE_DOUBLE_PRECISION
// #define btMultiBodyData btMultiBodyDoubleData
public static final String btMultiBodyDataName = "btMultiBodyDoubleData";
// #define btMultiBodyLinkData btMultiBodyLinkDoubleData
public static final String btMultiBodyLinkDataName = "btMultiBodyLinkDoubleData";
// #else
// #endif  //BT_USE_DOUBLE_PRECISION

// #include "btMultiBodyLink.h"
// Targeting ..\BulletDynamics\btMultiBody.java


// Targeting ..\BulletDynamics\btMultiBodyLinkDoubleData.java


// Targeting ..\BulletDynamics\btMultiBodyLinkFloatData.java


// Targeting ..\BulletDynamics\btMultiBodyDoubleData.java


// Targeting ..\BulletDynamics\btMultiBodyFloatData.java



// #endif


// Parsed from BulletDynamics/Featherstone/btMultiBodyConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_CONSTRAINT_H
// #define BT_MULTIBODY_CONSTRAINT_H

// #include "LinearMath/btScalar.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "btMultiBody.h"


//Don't change any of the existing enum values, so add enum types at the end for serialization compatibility
/** enum btTypedMultiBodyConstraintType */
public static final int
	MULTIBODY_CONSTRAINT_LIMIT = 3,
	MULTIBODY_CONSTRAINT_1DOF_JOINT_MOTOR = 4,
	MULTIBODY_CONSTRAINT_GEAR = 5,
	MULTIBODY_CONSTRAINT_POINT_TO_POINT = 6,
	MULTIBODY_CONSTRAINT_SLIDER = 7,
	MULTIBODY_CONSTRAINT_SPHERICAL_MOTOR = 8,
	MULTIBODY_CONSTRAINT_FIXED = 9,
	MULTIBODY_CONSTRAINT_SPHERICAL_LIMIT = 10,
	MAX_MULTIBODY_CONSTRAINT_TYPE = 11;
// Targeting ..\BulletDynamics\btSolverInfo.java



// #include "btMultiBodySolverConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyJacobianData.java


// Targeting ..\BulletDynamics\btMultiBodyConstraint.java



// #endif  //BT_MULTIBODY_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyConstraintSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_CONSTRAINT_SOLVER_H
// #define BT_MULTIBODY_CONSTRAINT_SOLVER_H

// #include "BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.h"
// #include "btMultiBodySolverConstraint.h"

// #define DIRECTLY_UPDATE_VELOCITY_DURING_SOLVER_ITERATIONS

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyConstraintSolver.java



// #endif  //BT_MULTIBODY_CONSTRAINT_SOLVER_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyDynamicsWorld.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_DYNAMICS_WORLD_H
// #define BT_MULTIBODY_DYNAMICS_WORLD_H

// #include "BulletDynamics/Dynamics/btDiscreteDynamicsWorld.h"
// #include "BulletDynamics/Featherstone/btMultiBodyInplaceSolverIslandCallback.h"

// #define BT_USE_VIRTUAL_CLEARFORCES_AND_GRAVITY
// Targeting ..\BulletDynamics\btMultiBodyDynamicsWorld.java


// #endif  //BT_MULTIBODY_DYNAMICS_WORLD_H


// Parsed from BulletDynamics/Featherstone/btMultiBodySolverConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_SOLVER_CONSTRAINT_H
// #define BT_MULTIBODY_SOLVER_CONSTRAINT_H

// #include "LinearMath/btVector3.h"
// #include "LinearMath/btAlignedObjectArray.h"
// #include "BulletDynamics/ConstraintSolver/btSolverBody.h"
// #include "BulletDynamics/ConstraintSolver/btContactSolverInfo.h"
// Targeting ..\BulletDynamics\btMultiBodySolverConstraint.java



// #endif  //BT_MULTIBODY_SOLVER_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyFixedConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_FIXED_CONSTRAINT_H
// #define BT_MULTIBODY_FIXED_CONSTRAINT_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyFixedConstraint.java



// #endif  //BT_MULTIBODY_FIXED_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyGearConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_GEAR_CONSTRAINT_H
// #define BT_MULTIBODY_GEAR_CONSTRAINT_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyGearConstraint.java



// #endif  //BT_MULTIBODY_GEAR_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyInplaceSolverIslandCallback.h

/*
 Bullet Continuous Collision Detection and Physics Library
 Copyright (c) 2019 Google Inc. http://bulletphysics.org
 This software is provided 'as-is', without any express or implied warranty.
 In no event will the authors be held liable for any damages arising from the use of this software.
 Permission is granted to anyone to use this software for any purpose,
 including commercial applications, and to alter it and redistribute it freely,
 subject to the following restrictions:
 1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
 2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
 3. This notice may not be removed or altered from any source distribution.
 */

// #ifndef BT_MULTIBODY_INPLACE_SOLVER_ISLAND_CALLBACK_H
// #define BT_MULTIBODY_INPLACE_SOLVER_ISLAND_CALLBACK_H

// #include "BulletDynamics/Featherstone/btMultiBodyConstraintSolver.h"
// #include "BulletCollision/CollisionDispatch/btSimulationIslandManager.h"
// #include "BulletDynamics/Featherstone/btMultiBodyDynamicsWorld.h"
// #include "btMultiBodyConstraintSolver.h"

public static native int btGetConstraintIslandId2(@Const btTypedConstraint lhs);
// Targeting ..\BulletDynamics\btSortConstraintOnIslandPredicate2.java



public static native int btGetMultiBodyConstraintIslandId(@Const btMultiBodyConstraint lhs);
// Targeting ..\BulletDynamics\btSortMultiBodyConstraintOnIslandPredicate.java


// Targeting ..\BulletDynamics\MultiBodyInplaceSolverIslandCallback.java




// #endif /*BT_MULTIBODY_INPLACE_SOLVER_ISLAND_CALLBACK_H */


// Parsed from BulletDynamics/Featherstone/btMultiBodyJointFeedback.h

/*
Copyright (c) 2015 Google Inc.

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_JOINT_FEEDBACK_H
// #define BT_MULTIBODY_JOINT_FEEDBACK_H

// #include "LinearMath/btSpatialAlgebra.h"
// Targeting ..\BulletDynamics\btMultiBodyJointFeedback.java



// #endif  //BT_MULTIBODY_JOINT_FEEDBACK_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyJointLimitConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_JOINT_LIMIT_CONSTRAINT_H
// #define BT_MULTIBODY_JOINT_LIMIT_CONSTRAINT_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyJointLimitConstraint.java



// #endif  //BT_MULTIBODY_JOINT_LIMIT_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyJointMotor.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_JOINT_MOTOR_H
// #define BT_MULTIBODY_JOINT_MOTOR_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyJointMotor.java



// #endif  //BT_MULTIBODY_JOINT_MOTOR_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyLink.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_LINK_H
// #define BT_MULTIBODY_LINK_H

// #include "LinearMath/btQuaternion.h"
// #include "LinearMath/btVector3.h"
// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"

/** enum btMultiBodyLinkFlags */
public static final int
	BT_MULTIBODYLINKFLAGS_DISABLE_PARENT_COLLISION = 1,
	BT_MULTIBODYLINKFLAGS_DISABLE_ALL_PARENT_COLLISION = 2;

//both defines are now permanently enabled
// #define BT_MULTIBODYLINK_INCLUDE_PLANAR_JOINTS
// #define TEST_SPATIAL_ALGEBRA_LAYER

//
// Various spatial helper functions
//

//namespace {

// #include "LinearMath/btSpatialAlgebra.h"
// Targeting ..\BulletDynamics\btMultibodyLink.java



// #endif  //BT_MULTIBODY_LINK_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyLinkCollider.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_FEATHERSTONE_LINK_COLLIDER_H
// #define BT_FEATHERSTONE_LINK_COLLIDER_H

// #include "BulletCollision/CollisionDispatch/btCollisionObject.h"

// #include "btMultiBody.h"
// #include "LinearMath/btSerializer.h"

// #ifdef BT_USE_DOUBLE_PRECISION
// #define btMultiBodyLinkColliderData btMultiBodyLinkColliderDoubleData
public static final String btMultiBodyLinkColliderDataName = "btMultiBodyLinkColliderDoubleData";
// Targeting ..\BulletDynamics\btMultiBodyLinkCollider.java


// Targeting ..\BulletDynamics\btMultiBodyLinkColliderFloatData.java


// Targeting ..\BulletDynamics\btMultiBodyLinkColliderDoubleData.java



// clang-format on





// #endif  //BT_FEATHERSTONE_LINK_COLLIDER_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyMLCPConstraintSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2018 Google Inc. http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_MULTIBODY_MLCP_CONSTRAINT_SOLVER_H
// #define BT_MULTIBODY_MLCP_CONSTRAINT_SOLVER_H

// #include "LinearMath/btMatrixX.h"
// #include "LinearMath/btThreads.h"
// #include "BulletDynamics/Featherstone/btMultiBodyConstraintSolver.h"
// Targeting ..\BulletDynamics\btMultiBodyMLCPConstraintSolver.java



// #endif  // BT_MULTIBODY_MLCP_CONSTRAINT_SOLVER_H


// Parsed from BulletDynamics/Featherstone/btMultiBodyPoint2Point.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_POINT2POINT_H
// #define BT_MULTIBODY_POINT2POINT_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodyPoint2Point.java



// #endif  //BT_MULTIBODY_POINT2POINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodySliderConstraint.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_SLIDER_CONSTRAINT_H
// #define BT_MULTIBODY_SLIDER_CONSTRAINT_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodySliderConstraint.java



// #endif  //BT_MULTIBODY_SLIDER_CONSTRAINT_H


// Parsed from BulletDynamics/Featherstone/btMultiBodySphericalJointMotor.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2018 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it freely,
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

/**This file was written by Erwin Coumans */

// #ifndef BT_MULTIBODY_SPHERICAL_JOINT_MOTOR_H
// #define BT_MULTIBODY_SPHERICAL_JOINT_MOTOR_H

// #include "btMultiBodyConstraint.h"
// Targeting ..\BulletDynamics\btMultiBodySphericalJointMotor.java



// #endif  //BT_MULTIBODY_SPHERICAL_JOINT_MOTOR_H


// Parsed from BulletDynamics/MLCPSolvers/btDantzigLCP.h

/*************************************************************************
 *                                                                       *
 * Open Dynamics Engine, Copyright (C) 2001,2002 Russell L. Smith.       *
 * All rights reserved.  Email: russ\q12.org   Web: www.q12.org          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of                                          * 
 *   The BSD-style license that is included with this library in         *
 *   the file LICENSE-BSD.TXT.                                           *
 *                                                                       *
 * This library is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the files    *
 * LICENSE.TXT and LICENSE-BSD.TXT for more details.                     *
 *                                                                       *
 *************************************************************************/

/*

given (A,b,lo,hi), solve the LCP problem: A*x = b+w, where each x(i),w(i)
satisfies one of
	(1) x = lo, w >= 0
	(2) x = hi, w <= 0
	(3) lo < x < hi, w = 0
A is a matrix of dimension n*n, everything else is a vector of size n*1.
lo and hi can be +/- dInfinity as needed. the first `nub' variables are
unbounded, i.e. hi and lo are assumed to be +/- dInfinity.

we restrict lo(i) <= 0 and hi(i) >= 0.

the original data (A,b) may be modified by this function.

if the `findex' (friction index) parameter is nonzero, it points to an array
of index values. in this case constraints that have findex[i] >= 0 are
special. all non-special constraints are solved for, then the lo and hi values
for the special constraints are set:
  hi[i] = abs( hi[i] * x[findex[i]] )
  lo[i] = -hi[i]
and the solution continues. this mechanism allows a friction approximation
to be implemented. the first `nub' variables are assumed to have findex < 0.

*/

// #ifndef _BT_LCP_H_
// #define _BT_LCP_H_

// #include <stdlib.h>
// #include <stdio.h>
// #include <assert.h>

// #include "LinearMath/btScalar.h"
// #include "LinearMath/btAlignedObjectArray.h"
// Targeting ..\BulletDynamics\btDantzigScratchMemory.java



//return false if solving failed
public static native @Cast("bool") boolean btSolveDantzigLCP(int n, @Cast("btScalar*") DoublePointer A, @Cast("btScalar*") DoublePointer x, @Cast("btScalar*") DoublePointer b, @Cast("btScalar*") DoublePointer w,
					   int nub, @Cast("btScalar*") DoublePointer lo, @Cast("btScalar*") DoublePointer hi, IntPointer findex, @ByRef btDantzigScratchMemory scratch);
public static native @Cast("bool") boolean btSolveDantzigLCP(int n, @Cast("btScalar*") DoubleBuffer A, @Cast("btScalar*") DoubleBuffer x, @Cast("btScalar*") DoubleBuffer b, @Cast("btScalar*") DoubleBuffer w,
					   int nub, @Cast("btScalar*") DoubleBuffer lo, @Cast("btScalar*") DoubleBuffer hi, IntBuffer findex, @ByRef btDantzigScratchMemory scratch);
public static native @Cast("bool") boolean btSolveDantzigLCP(int n, @Cast("btScalar*") double[] A, @Cast("btScalar*") double[] x, @Cast("btScalar*") double[] b, @Cast("btScalar*") double[] w,
					   int nub, @Cast("btScalar*") double[] lo, @Cast("btScalar*") double[] hi, int[] findex, @ByRef btDantzigScratchMemory scratch);

// #endif  //_BT_LCP_H_


// Parsed from BulletDynamics/MLCPSolvers/btDantzigSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_DANTZIG_SOLVER_H
// #define BT_DANTZIG_SOLVER_H

// #include "btMLCPSolverInterface.h"
// #include "btDantzigLCP.h"
// Targeting ..\BulletDynamics\btDantzigSolver.java



// #endif  //BT_DANTZIG_SOLVER_H


// Parsed from BulletDynamics/MLCPSolvers/btLemkeAlgorithm.h

/* Copyright (C) 2004-2013 MBSim Development Team

Code was converted for the Bullet Continuous Collision Detection and Physics Library

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

//The original version is here
//https://code.google.com/p/mbsim-env/source/browse/trunk/kernel/mbsim/numerics/linear_complementarity_problem/lemke_algorithm.cc
//This file is re-distributed under the ZLib license, with permission of the original author (Kilian Grundl)
//Math library was replaced from fmatvec to a the file src/LinearMath/btMatrixX.h
//STL/std::vector replaced by btAlignedObjectArray

// #ifndef BT_NUMERICS_LEMKE_ALGORITHM_H_
// #define BT_NUMERICS_LEMKE_ALGORITHM_H_

// #include "LinearMath/btMatrixX.h"

// #include <vector>
// Targeting ..\BulletDynamics\btLemkeAlgorithm.java



// #endif /* BT_NUMERICS_LEMKE_ALGORITHM_H_ */


// Parsed from BulletDynamics/MLCPSolvers/btLemkeSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_LEMKE_SOLVER_H
// #define BT_LEMKE_SOLVER_H

// #include "btMLCPSolverInterface.h"
// #include "btLemkeAlgorithm.h"
// Targeting ..\BulletDynamics\btLemkeSolver.java



// #endif  //BT_LEMKE_SOLVER_H


// Parsed from BulletDynamics/MLCPSolvers/btMLCPSolver.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_MLCP_SOLVER_H
// #define BT_MLCP_SOLVER_H

// #include "BulletDynamics/ConstraintSolver/btSequentialImpulseConstraintSolver.h"
// #include "LinearMath/btMatrixX.h"
// #include "BulletDynamics/MLCPSolvers/btMLCPSolverInterface.h"
// Targeting ..\BulletDynamics\btMLCPSolver.java



// #endif  //BT_MLCP_SOLVER_H


// Parsed from BulletDynamics/MLCPSolvers/btMLCPSolverInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_MLCP_SOLVER_INTERFACE_H
// #define BT_MLCP_SOLVER_INTERFACE_H

// #include "LinearMath/btMatrixX.h"
// Targeting ..\BulletDynamics\btMLCPSolverInterface.java



// #endif  //BT_MLCP_SOLVER_INTERFACE_H


// Parsed from BulletDynamics/MLCPSolvers/btSolveProjectedGaussSeidel.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2013 Erwin Coumans  http://bulletphysics.org

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/
/**original version written by Erwin Coumans, October 2013 */

// #ifndef BT_SOLVE_PROJECTED_GAUSS_SEIDEL_H
// #define BT_SOLVE_PROJECTED_GAUSS_SEIDEL_H

// #include "btMLCPSolverInterface.h"
// Targeting ..\BulletDynamics\btSolveProjectedGaussSeidel.java



// #endif  //BT_SOLVE_PROJECTED_GAUSS_SEIDEL_H


// Parsed from BulletDynamics/Character/btCharacterControllerInterface.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  http://bulletphysics.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_CHARACTER_CONTROLLER_INTERFACE_H
// #define BT_CHARACTER_CONTROLLER_INTERFACE_H

// #include "LinearMath/btVector3.h"
// #include "BulletDynamics/Dynamics/btActionInterface.h"
// Targeting ..\BulletDynamics\btCharacterControllerInterface.java



// #endif  //BT_CHARACTER_CONTROLLER_INTERFACE_H


// Parsed from BulletDynamics/Character/btKinematicCharacterController.h

/*
Bullet Continuous Collision Detection and Physics Library
Copyright (c) 2003-2008 Erwin Coumans  http://bulletphysics.com

This software is provided 'as-is', without any express or implied warranty.
In no event will the authors be held liable for any damages arising from the use of this software.
Permission is granted to anyone to use this software for any purpose, 
including commercial applications, and to alter it and redistribute it freely, 
subject to the following restrictions:

1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
3. This notice may not be removed or altered from any source distribution.
*/

// #ifndef BT_KINEMATIC_CHARACTER_CONTROLLER_H
// #define BT_KINEMATIC_CHARACTER_CONTROLLER_H

// #include "LinearMath/btVector3.h"

// #include "btCharacterControllerInterface.h"

// #include "BulletCollision/BroadphaseCollision/btCollisionAlgorithm.h"
// Targeting ..\BulletDynamics\btKinematicCharacterController.java



// #endif  // BT_KINEMATIC_CHARACTER_CONTROLLER_H


}
