// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.Bullet3Dynamics;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.Bullet3Common.*;
import static org.bytedeco.bullet.global.Bullet3Common.*;
import org.bytedeco.bullet.Bullet3Collision.*;
import static org.bytedeco.bullet.global.Bullet3Collision.*;

import static org.bytedeco.bullet.global.Bullet3Dynamics.*;
  // bits per axis

/** b3Generic6DofConstraint between two rigidbodies each with a pivotpoint that descibes the axis location in local space
/**
b3Generic6DofConstraint can leave any of the 6 degree of freedom 'free' or 'locked'.
currently this limit supports rotational motors<br>
<ul>
<li> For Linear limits, use b3Generic6DofConstraint.setLinearUpperLimit, b3Generic6DofConstraint.setLinearLowerLimit. You can set the parameters with the b3TranslationalLimitMotor structure accsesible through the b3Generic6DofConstraint.getTranslationalLimitMotor method.
At this moment translational motors are not supported. May be in the future. </li>
<p>
<li> For Angular limits, use the b3RotationalLimitMotor structure for configuring the limit.
This is accessible through b3Generic6DofConstraint.getLimitMotor method,
This brings support for limit parameters and motors. </li>
<p>
<li> Angulars limits have these possible ranges:
<table border=1 >
<tr>
	<td><b>AXIS</b></td>
	<td><b>MIN ANGLE</b></td>
	<td><b>MAX ANGLE</b></td>
</tr><tr>
	<td>X</td>
	<td>-PI</td>
	<td>PI</td>
</tr><tr>
	<td>Y</td>
	<td>-PI/2</td>
	<td>PI/2</td>
</tr><tr>
	<td>Z</td>
	<td>-PI</td>
	<td>PI</td>
</tr>
</table>
</li>
</ul>
<p>
*/
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.Bullet3Dynamics.class)
public class b3Generic6DofConstraint extends b3TypedConstraint {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public b3Generic6DofConstraint(Pointer p) { super(p); }


	public b3Generic6DofConstraint(int rbA, int rbB, @Const @ByRef b3Transform frameInA, @Const @ByRef b3Transform frameInB, @Cast("bool") boolean useLinearReferenceFrameA, @Const b3RigidBodyData bodies) { super((Pointer)null); allocate(rbA, rbB, frameInA, frameInB, useLinearReferenceFrameA, bodies); }
	private native void allocate(int rbA, int rbB, @Const @ByRef b3Transform frameInA, @Const @ByRef b3Transform frameInB, @Cast("bool") boolean useLinearReferenceFrameA, @Const b3RigidBodyData bodies);

	/** Calcs global transform of the offsets
	/**
	Calcs the global transform for the joint offset for body A an B, and also calcs the agle differences between the bodies.
	@see b3Generic6DofConstraint.getCalculatedTransformA , b3Generic6DofConstraint.getCalculatedTransformB, b3Generic6DofConstraint.calculateAngleInfo
	*/
	public native void calculateTransforms(@Const @ByRef b3Transform transA, @Const @ByRef b3Transform transB, @Const b3RigidBodyData bodies);

	public native void calculateTransforms(@Const b3RigidBodyData bodies);

	/** Gets the global transform of the offset for body A
	/**
    @see b3Generic6DofConstraint.getFrameOffsetA, b3Generic6DofConstraint.getFrameOffsetB, b3Generic6DofConstraint.calculateAngleInfo.
    */
	public native @Const @ByRef b3Transform getCalculatedTransformA();

	/** Gets the global transform of the offset for body B
	/**
    @see b3Generic6DofConstraint.getFrameOffsetA, b3Generic6DofConstraint.getFrameOffsetB, b3Generic6DofConstraint.calculateAngleInfo.
    */
	public native @Const @ByRef b3Transform getCalculatedTransformB();

	public native @ByRef b3Transform getFrameOffsetA();

	public native @ByRef b3Transform getFrameOffsetB();

	public native void getInfo1(b3ConstraintInfo1 info, @Const b3RigidBodyData bodies);

	public native void getInfo1NonVirtual(b3ConstraintInfo1 info, @Const b3RigidBodyData bodies);

	public native void getInfo2(b3ConstraintInfo2 info, @Const b3RigidBodyData bodies);

	public native void getInfo2NonVirtual(b3ConstraintInfo2 info, @Const @ByRef b3Transform transA, @Const @ByRef b3Transform transB, @Const @ByRef b3Vector3 linVelA, @Const @ByRef b3Vector3 linVelB, @Const @ByRef b3Vector3 angVelA, @Const @ByRef b3Vector3 angVelB, @Const b3RigidBodyData bodies);

	public native void updateRHS(@Cast("b3Scalar") float timeStep);

	/** Get the rotation axis in global coordinates */
	public native @ByVal b3Vector3 getAxis(int axis_index);

	/** Get the relative Euler angle
	/**
	\pre b3Generic6DofConstraint::calculateTransforms() must be called previously.
	*/
	public native @Cast("b3Scalar") float getAngle(int axis_index);

	/** Get the relative position of the constraint pivot
	/**
	\pre b3Generic6DofConstraint::calculateTransforms() must be called previously.
	*/
	public native @Cast("b3Scalar") float getRelativePivotPosition(int axis_index);

	public native void setFrames(@Const @ByRef b3Transform frameA, @Const @ByRef b3Transform frameB, @Const b3RigidBodyData bodies);

	/** Test angular limit.
	/**
	Calculates angular correction and returns true if limit needs to be corrected.
	\pre b3Generic6DofConstraint::calculateTransforms() must be called previously.
	*/
	public native @Cast("bool") boolean testAngularLimitMotor(int axis_index);

	public native void setLinearLowerLimit(@Const @ByRef b3Vector3 linearLower);

	public native void getLinearLowerLimit(@ByRef b3Vector3 linearLower);

	public native void setLinearUpperLimit(@Const @ByRef b3Vector3 linearUpper);

	public native void getLinearUpperLimit(@ByRef b3Vector3 linearUpper);

	public native void setAngularLowerLimit(@Const @ByRef b3Vector3 angularLower);

	public native void getAngularLowerLimit(@ByRef b3Vector3 angularLower);

	public native void setAngularUpperLimit(@Const @ByRef b3Vector3 angularUpper);

	public native void getAngularUpperLimit(@ByRef b3Vector3 angularUpper);

	/** Retrieves the angular limit informacion */
	public native b3RotationalLimitMotor getRotationalLimitMotor(int index);

	/** Retrieves the  limit informacion */
	public native b3TranslationalLimitMotor getTranslationalLimitMotor();

	//first 3 are linear, next 3 are angular
	public native void setLimit(int axis, @Cast("b3Scalar") float lo, @Cast("b3Scalar") float hi);

	/** Test limit
	/**
    - free means upper < lower,
    - locked means upper == lower
    - limited means upper > lower
    - limitIndex: first 3 are linear, next 3 are angular
    */
	public native @Cast("bool") boolean isLimited(int limitIndex);

	public native void calcAnchorPos(@Const b3RigidBodyData bodies);  // overridable

	public native int get_limit_motor_info2(b3RotationalLimitMotor limot,
								  @Const @ByRef b3Transform transA, @Const @ByRef b3Transform transB, @Const @ByRef b3Vector3 linVelA, @Const @ByRef b3Vector3 linVelB, @Const @ByRef b3Vector3 angVelA, @Const @ByRef b3Vector3 angVelB,
								  b3ConstraintInfo2 info, int row, @ByRef b3Vector3 ax1, int rotational, int rotAllowed/*=false*/);
	public native int get_limit_motor_info2(b3RotationalLimitMotor limot,
								  @Const @ByRef b3Transform transA, @Const @ByRef b3Transform transB, @Const @ByRef b3Vector3 linVelA, @Const @ByRef b3Vector3 linVelB, @Const @ByRef b3Vector3 angVelA, @Const @ByRef b3Vector3 angVelB,
								  b3ConstraintInfo2 info, int row, @ByRef b3Vector3 ax1, int rotational);

	// access for UseFrameOffset
	public native @Cast("bool") boolean getUseFrameOffset();
	public native void setUseFrameOffset(@Cast("bool") boolean frameOffsetOnOff);

	/**override the default global value of a parameter (such as ERP or CFM), optionally provide the axis (0..5).
	 * If no axis is provided, it uses the default axis for this constraint. */
	public native void setParam(int num, @Cast("b3Scalar") float value, int axis/*=-1*/);
	public native void setParam(int num, @Cast("b3Scalar") float value);
	/**return the local value of parameter */
	public native @Cast("b3Scalar") float getParam(int num, int axis/*=-1*/);
	public native @Cast("b3Scalar") float getParam(int num);

	public native void setAxis(@Const @ByRef b3Vector3 axis1, @Const @ByRef b3Vector3 axis2, @Const b3RigidBodyData bodies);
}
