// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btBoxShape is a box primitive around the origin, its sides axis aligned with length specified by half extents, in local shape coordinates. When used as part of a btCollisionObject or btRigidBody it will be an oriented box in world space. */
@Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btBoxShape extends btPolyhedralConvexShape {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btBoxShape(Pointer p) { super(p); }


	public native @ByVal btVector3 getHalfExtentsWithMargin();

	public native @Const @ByRef btVector3 getHalfExtentsWithoutMargin();

	public native @ByVal btVector3 localGetSupportingVertex(@Const @ByRef btVector3 vec);

	public native @ByVal btVector3 localGetSupportingVertexWithoutMargin(@Const @ByRef btVector3 vec);

	public native void batchedUnitVectorGetSupportingVertexWithoutMargin(@Const btVector3 vectors, btVector3 supportVerticesOut, int numVectors);

	public btBoxShape(@Const @ByRef btVector3 boxHalfExtents) { super((Pointer)null); allocate(boxHalfExtents); }
	private native void allocate(@Const @ByRef btVector3 boxHalfExtents);

	public native void setMargin(@Cast("btScalar") double collisionMargin);
	public native void setLocalScaling(@Const @ByRef btVector3 scaling);

	public native void getAabb(@Const @ByRef btTransform t, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	public native void calculateLocalInertia(@Cast("btScalar") double mass, @ByRef btVector3 inertia);

	public native void getPlane(@ByRef btVector3 planeNormal, @ByRef btVector3 planeSupport, int i);

	public native int getNumPlanes();

	public native int getNumVertices();

	public native int getNumEdges();

	public native void getVertex(int i, @ByRef btVector3 vtx);

	public native void getPlaneEquation(@ByRef btVector4 plane, int i);

	public native void getEdge(int i, @ByRef btVector3 pa, @ByRef btVector3 pb);

	public native @Cast("bool") boolean isInside(@Const @ByRef btVector3 pt, @Cast("btScalar") double tolerance);

	//debugging
	public native @Cast("const char*") BytePointer getName();

	public native int getNumPreferredPenetrationDirections();

	public native void getPreferredPenetrationDirection(int index, @ByRef btVector3 penetrationVector);
}
