// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;

// #else
// #endif

/** btCollisionObject can be used to manage collision detection objects.
 *  btCollisionObject maintains all information that is needed for a collision detection: Shape, Transform and AABB proxy.
 *  They can be added to the btCollisionWorld. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btCollisionObject extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btCollisionObject(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btCollisionObject(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btCollisionObject position(long position) {
        return (btCollisionObject)super.position(position);
    }
    @Override public btCollisionObject getPointer(long i) {
        return new btCollisionObject((Pointer)this).offsetAddress(i);
    }


	/** enum btCollisionObject::CollisionFlags */
	public static final int
		CF_DYNAMIC_OBJECT = 0,
		CF_STATIC_OBJECT = 1,
		CF_KINEMATIC_OBJECT = 2,
		CF_NO_CONTACT_RESPONSE = 4,
		CF_CUSTOM_MATERIAL_CALLBACK = 8,  //this allows per-triangle material (friction/restitution)
		CF_CHARACTER_OBJECT = 16,
		CF_DISABLE_VISUALIZE_OBJECT = 32,          //disable debug drawing
		CF_DISABLE_SPU_COLLISION_PROCESSING = 64,  //disable parallel/SPU processing
		CF_HAS_CONTACT_STIFFNESS_DAMPING = 128,
		CF_HAS_CUSTOM_DEBUG_RENDERING_COLOR = 256,
		CF_HAS_FRICTION_ANCHOR = 512,
		CF_HAS_COLLISION_SOUND_TRIGGER = 1024;

	/** enum btCollisionObject::CollisionObjectTypes */
	public static final int
		CO_COLLISION_OBJECT = 1,
		CO_RIGID_BODY = 2,
		/**CO_GHOST_OBJECT keeps track of all objects overlapping its AABB and that pass its collision filter
		 * It is useful for collision sensors, explosion objects, character controller etc. */
		CO_GHOST_OBJECT = 4,
		CO_SOFT_BODY = 8,
		CO_HF_FLUID = 16,
		CO_USER_TYPE = 32,
		CO_FEATHERSTONE_LINK = 64;

	/** enum btCollisionObject::AnisotropicFrictionFlags */
	public static final int
		CF_ANISOTROPIC_FRICTION_DISABLED = 0,
		CF_ANISOTROPIC_FRICTION = 1,
		CF_ANISOTROPIC_ROLLING_FRICTION = 2;

	public native @Cast("bool") boolean mergesSimulationIslands();

	public native @Const @ByRef btVector3 getAnisotropicFriction();
	public native void setAnisotropicFriction(@Const @ByRef btVector3 anisotropicFriction, int frictionMode/*=btCollisionObject::CF_ANISOTROPIC_FRICTION*/);
	public native void setAnisotropicFriction(@Const @ByRef btVector3 anisotropicFriction);
	public native @Cast("bool") boolean hasAnisotropicFriction(int frictionMode/*=btCollisionObject::CF_ANISOTROPIC_FRICTION*/);
	public native @Cast("bool") boolean hasAnisotropicFriction();

	/**the constraint solver can discard solving contacts, if the distance is above this threshold. 0 by default.
	 * Note that using contacts with positive distance can improve stability. It increases, however, the chance of colliding with degerate contacts, such as 'interior' triangle edges */
	public native void setContactProcessingThreshold(@Cast("btScalar") double contactProcessingThreshold);
	public native @Cast("btScalar") double getContactProcessingThreshold();

	public native @Cast("bool") boolean isStaticObject();

	public native @Cast("bool") boolean isKinematicObject();

	public native @Cast("bool") boolean isStaticOrKinematicObject();

	public native @Cast("bool") boolean hasContactResponse();

	public btCollisionObject() { super((Pointer)null); allocate(); }
	private native void allocate();

	public native void setCollisionShape(btCollisionShape collisionShape);

	public native btCollisionShape getCollisionShape();

	public native void setIgnoreCollisionCheck(@Const btCollisionObject co, @Cast("bool") boolean ignoreCollisionCheck);

        public native int getNumObjectsWithoutCollision();

	public native @Const btCollisionObject getObjectWithoutCollision(int index);

	public native @Cast("bool") boolean checkCollideWithOverride(@Const btCollisionObject co);

	/**Avoid using this internal API call, the extension pointer is used by some Bullet extensions.
	 * If you need to store your own user pointer, use 'setUserPointer/getUserPointer' instead. */
	public native Pointer internalGetExtensionPointer();
	/**Avoid using this internal API call, the extension pointer is used by some Bullet extensions
	 * If you need to store your own user pointer, use 'setUserPointer/getUserPointer' instead. */
	public native void internalSetExtensionPointer(Pointer pointer);

	public native int getActivationState();

	public native void setActivationState(int newState);

	public native void setDeactivationTime(@Cast("btScalar") double time);
	public native @Cast("btScalar") double getDeactivationTime();

	public native void forceActivationState(int newState);

	public native void activate(@Cast("bool") boolean forceActivation/*=false*/);
	public native void activate();

	public native @Cast("bool") boolean isActive();

	public native void setRestitution(@Cast("btScalar") double rest);
	public native @Cast("btScalar") double getRestitution();
	public native void setFriction(@Cast("btScalar") double frict);
	public native @Cast("btScalar") double getFriction();

	public native void setRollingFriction(@Cast("btScalar") double frict);
	public native @Cast("btScalar") double getRollingFriction();
	public native void setSpinningFriction(@Cast("btScalar") double frict);
	public native @Cast("btScalar") double getSpinningFriction();
	public native void setContactStiffnessAndDamping(@Cast("btScalar") double stiffness, @Cast("btScalar") double damping);

	public native @Cast("btScalar") double getContactStiffness();

	public native @Cast("btScalar") double getContactDamping();

	/**reserved for Bullet internal usage */
	public native int getInternalType();

	public native @ByRef btTransform getWorldTransform();

	public native void setWorldTransform(@Const @ByRef btTransform worldTrans);

	public native btBroadphaseProxy getBroadphaseHandle();

	public native void setBroadphaseHandle(btBroadphaseProxy handle);

	public native @ByRef btTransform getInterpolationWorldTransform();

	public native void setInterpolationWorldTransform(@Const @ByRef btTransform trans);

	public native void setInterpolationLinearVelocity(@Const @ByRef btVector3 linvel);

	public native void setInterpolationAngularVelocity(@Const @ByRef btVector3 angvel);

	public native @Const @ByRef btVector3 getInterpolationLinearVelocity();

	public native @Const @ByRef btVector3 getInterpolationAngularVelocity();

	public native int getIslandTag();

	public native void setIslandTag(int tag);

	public native int getCompanionId();

	public native void setCompanionId(int id);

	public native int getWorldArrayIndex();

	// only should be called by CollisionWorld
	public native void setWorldArrayIndex(int ix);

	public native @Cast("btScalar") double getHitFraction();

	public native void setHitFraction(@Cast("btScalar") double hitFraction);

	public native int getCollisionFlags();

	public native void setCollisionFlags(int flags);

	/**Swept sphere radius (0.0 by default), see btConvexConvexAlgorithm:: */
	public native @Cast("btScalar") double getCcdSweptSphereRadius();

	/**Swept sphere radius (0.0 by default), see btConvexConvexAlgorithm:: */
	public native void setCcdSweptSphereRadius(@Cast("btScalar") double radius);

	public native @Cast("btScalar") double getCcdMotionThreshold();

	public native @Cast("btScalar") double getCcdSquareMotionThreshold();

	/** Don't do continuous collision detection if the motion (in one step) is less then m_ccdMotionThreshold */
	public native void setCcdMotionThreshold(@Cast("btScalar") double ccdMotionThreshold);

	/**users can point to their objects, userPointer is not used by Bullet */
	public native Pointer getUserPointer();

	public native int getUserIndex();

	public native int getUserIndex2();

	public native int getUserIndex3();

	/**users can point to their objects, userPointer is not used by Bullet */
	public native void setUserPointer(Pointer userPointer);

	/**users can point to their objects, userPointer is not used by Bullet */
	public native void setUserIndex(int index);

	public native void setUserIndex2(int index);

	public native void setUserIndex3(int index);

	public native int getUpdateRevisionInternal();

	public native void setCustomDebugColor(@Const @ByRef btVector3 colorRGB);

	public native void removeCustomDebugColor();

	public native @Cast("bool") boolean getCustomDebugColor(@ByRef btVector3 colorRGB);

	public native @Cast("bool") boolean checkCollideWith(@Const btCollisionObject co);

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);

	public native void serializeSingleObject(btSerializer serializer);
}
