// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/**The btCollisionShape class provides an interface for collision shapes that can be shared among btCollisionObjects. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btCollisionShape extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btCollisionShape(Pointer p) { super(p); }


	/**getAabb returns the axis aligned bounding box in the coordinate frame of the given transform t. */
	public native void getAabb(@Const @ByRef btTransform t, @ByRef btVector3 aabbMin, @ByRef btVector3 aabbMax);

	public native void getBoundingSphere(@ByRef btVector3 center, @Cast("btScalar*") @ByRef DoublePointer radius);
	public native void getBoundingSphere(@ByRef btVector3 center, @Cast("btScalar*") @ByRef DoubleBuffer radius);
	public native void getBoundingSphere(@ByRef btVector3 center, @Cast("btScalar*") @ByRef double[] radius);

	/**getAngularMotionDisc returns the maximum radius needed for Conservative Advancement to handle time-of-impact with rotations. */
	public native @Cast("btScalar") double getAngularMotionDisc();

	public native @Cast("btScalar") double getContactBreakingThreshold(@Cast("btScalar") double defaultContactThresholdFactor);

	/**calculateTemporalAabb calculates the enclosing aabb for the moving object over interval [0..timeStep)
	 * result is conservative */
	public native void calculateTemporalAabb(@Const @ByRef btTransform curTrans, @Const @ByRef btVector3 linvel, @Const @ByRef btVector3 angvel, @Cast("btScalar") double timeStep, @ByRef btVector3 temporalAabbMin, @ByRef btVector3 temporalAabbMax);

	public native @Cast("bool") boolean isPolyhedral();

	public native @Cast("bool") boolean isConvex2d();

	public native @Cast("bool") boolean isConvex();
	public native @Cast("bool") boolean isNonMoving();
	public native @Cast("bool") boolean isConcave();
	public native @Cast("bool") boolean isCompound();

	public native @Cast("bool") boolean isSoftBody();

	/**isInfinite is used to catch simulation error (aabb check) */
	public native @Cast("bool") boolean isInfinite();

// #ifndef __SPU__
	public native void setLocalScaling(@Const @ByRef btVector3 scaling);
	public native @Const @ByRef btVector3 getLocalScaling();
	public native void calculateLocalInertia(@Cast("btScalar") double mass, @ByRef btVector3 inertia);

	//debugging support
	public native @Cast("const char*") BytePointer getName();
// #endif  //__SPU__

	public native int getShapeType();

	/**the getAnisotropicRollingFrictionDirection can be used in combination with setAnisotropicFriction
	 * See Bullet/Demos/RollingFrictionDemo for an example */
	public native @ByVal btVector3 getAnisotropicRollingFrictionDirection();
	public native void setMargin(@Cast("btScalar") double margin);
	public native @Cast("btScalar") double getMargin();

	/**optional user data pointer */
	public native void setUserPointer(Pointer userPtr);

	public native Pointer getUserPointer();
	public native void setUserIndex(int index);

	public native int getUserIndex();

	public native void setUserIndex2(int index);

	public native int getUserIndex2();

	public native int calculateSerializeBufferSize();

	/**fills the dataBuffer and returns the struct name (and 0 on failure) */
	public native @Cast("const char*") BytePointer serialize(Pointer dataBuffer, btSerializer serializer);

	public native void serializeSingleShape(btSerializer serializer);
}
