// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/** ManifoldContactPoint collects and maintains persistent contactpoints.
 *  used to improve stability and performance of rigidbody dynamics response. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btManifoldPoint extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btManifoldPoint(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public btManifoldPoint(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public btManifoldPoint position(long position) {
        return (btManifoldPoint)super.position(position);
    }
    @Override public btManifoldPoint getPointer(long i) {
        return new btManifoldPoint((Pointer)this).offsetAddress(i);
    }

	public btManifoldPoint() { super((Pointer)null); allocate(); }
	private native void allocate();

	public btManifoldPoint(@Const @ByRef btVector3 pointA, @Const @ByRef btVector3 pointB,
						@Const @ByRef btVector3 normal,
						@Cast("btScalar") double distance) { super((Pointer)null); allocate(pointA, pointB, normal, distance); }
	private native void allocate(@Const @ByRef btVector3 pointA, @Const @ByRef btVector3 pointB,
						@Const @ByRef btVector3 normal,
						@Cast("btScalar") double distance);

	public native @ByRef btVector3 m_localPointA(); public native btManifoldPoint m_localPointA(btVector3 setter);
	public native @ByRef btVector3 m_localPointB(); public native btManifoldPoint m_localPointB(btVector3 setter);
	public native @ByRef btVector3 m_positionWorldOnB(); public native btManifoldPoint m_positionWorldOnB(btVector3 setter);
	/**m_positionWorldOnA is redundant information, see getPositionWorldOnA(), but for clarity */
	public native @ByRef btVector3 m_positionWorldOnA(); public native btManifoldPoint m_positionWorldOnA(btVector3 setter);
	public native @ByRef btVector3 m_normalWorldOnB(); public native btManifoldPoint m_normalWorldOnB(btVector3 setter);

	public native @Cast("btScalar") double m_distance1(); public native btManifoldPoint m_distance1(double setter);
	public native @Cast("btScalar") double m_combinedFriction(); public native btManifoldPoint m_combinedFriction(double setter);
	public native @Cast("btScalar") double m_combinedRollingFriction(); public native btManifoldPoint m_combinedRollingFriction(double setter);   //torsional friction orthogonal to contact normal, useful to make spheres stop rolling forever
	public native @Cast("btScalar") double m_combinedSpinningFriction(); public native btManifoldPoint m_combinedSpinningFriction(double setter);  //torsional friction around contact normal, useful for grasping objects
	public native @Cast("btScalar") double m_combinedRestitution(); public native btManifoldPoint m_combinedRestitution(double setter);

	//BP mod, store contact triangles.
	public native int m_partId0(); public native btManifoldPoint m_partId0(int setter);
	public native int m_partId1(); public native btManifoldPoint m_partId1(int setter);
	public native int m_index0(); public native btManifoldPoint m_index0(int setter);
	public native int m_index1(); public native btManifoldPoint m_index1(int setter);

	public native Pointer m_userPersistentData(); public native btManifoldPoint m_userPersistentData(Pointer setter);
	//bool			m_lateralFrictionInitialized;
	public native int m_contactPointFlags(); public native btManifoldPoint m_contactPointFlags(int setter);

	public native @Cast("btScalar") double m_appliedImpulse(); public native btManifoldPoint m_appliedImpulse(double setter);
	public native @Cast("btScalar") double m_prevRHS(); public native btManifoldPoint m_prevRHS(double setter);
	public native @Cast("btScalar") double m_appliedImpulseLateral1(); public native btManifoldPoint m_appliedImpulseLateral1(double setter);
	public native @Cast("btScalar") double m_appliedImpulseLateral2(); public native btManifoldPoint m_appliedImpulseLateral2(double setter);
	public native @Cast("btScalar") double m_contactMotion1(); public native btManifoldPoint m_contactMotion1(double setter);
	public native @Cast("btScalar") double m_contactMotion2(); public native btManifoldPoint m_contactMotion2(double setter);
		public native @Cast("btScalar") double m_contactCFM(); public native btManifoldPoint m_contactCFM(double setter);
		public native @Cast("btScalar") double m_combinedContactStiffness1(); public native btManifoldPoint m_combinedContactStiffness1(double setter);
		public native @Cast("btScalar") double m_contactERP(); public native btManifoldPoint m_contactERP(double setter);
		public native @Cast("btScalar") double m_combinedContactDamping1(); public native btManifoldPoint m_combinedContactDamping1(double setter);

	public native @Cast("btScalar") double m_frictionCFM(); public native btManifoldPoint m_frictionCFM(double setter);

	public native int m_lifeTime(); public native btManifoldPoint m_lifeTime(int setter);  //lifetime of the contactpoint in frames

	public native @ByRef btVector3 m_lateralFrictionDir1(); public native btManifoldPoint m_lateralFrictionDir1(btVector3 setter);
	public native @ByRef btVector3 m_lateralFrictionDir2(); public native btManifoldPoint m_lateralFrictionDir2(btVector3 setter);

	public native @Cast("btScalar") double getDistance();
	public native int getLifeTime();

	public native @Const @ByRef btVector3 getPositionWorldOnA();

	public native @Const @ByRef btVector3 getPositionWorldOnB();

	public native void setDistance(@Cast("btScalar") double dist);

	/**this returns the most recent applied impulse, to satisfy contact constraints by the constraint solver */
	public native @Cast("btScalar") double getAppliedImpulse();
}
