// Targeted by JavaCPP version 1.5.10: DO NOT EDIT THIS FILE

package org.bytedeco.bullet.BulletCollision;

import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import org.bytedeco.bullet.LinearMath.*;
import static org.bytedeco.bullet.global.LinearMath.*;

import static org.bytedeco.bullet.global.BulletCollision.*;


/** btSphereBoxCollisionAlgorithm  provides sphere-box collision detection.
 *  Other features are frame-coherency (persistent data) and collision response. */
@NoOffset @Properties(inherit = org.bytedeco.bullet.presets.BulletCollision.class)
public class btSphereBoxCollisionAlgorithm extends btActivatingCollisionAlgorithm {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public btSphereBoxCollisionAlgorithm(Pointer p) { super(p); }

	public btSphereBoxCollisionAlgorithm(btPersistentManifold mf, @Const @ByRef btCollisionAlgorithmConstructionInfo ci, @Const btCollisionObjectWrapper body0Wrap, @Const btCollisionObjectWrapper body1Wrap, @Cast("bool") boolean isSwapped) { super((Pointer)null); allocate(mf, ci, body0Wrap, body1Wrap, isSwapped); }
	private native void allocate(btPersistentManifold mf, @Const @ByRef btCollisionAlgorithmConstructionInfo ci, @Const btCollisionObjectWrapper body0Wrap, @Const btCollisionObjectWrapper body1Wrap, @Cast("bool") boolean isSwapped);

	public native void processCollision(@Const btCollisionObjectWrapper body0Wrap, @Const btCollisionObjectWrapper body1Wrap, @Const @ByRef btDispatcherInfo dispatchInfo, btManifoldResult resultOut);

	public native @Cast("btScalar") double calculateTimeOfImpact(btCollisionObject body0, btCollisionObject body1, @Const @ByRef btDispatcherInfo dispatchInfo, btManifoldResult resultOut);

	public native void getAllContactManifolds(@Cast("btManifoldArray*") @ByRef btPersistentManifoldArray manifoldArray);

	public native @Cast("bool") boolean getSphereDistance(@Const btCollisionObjectWrapper boxObjWrap, @ByRef btVector3 v3PointOnBox, @ByRef btVector3 normal, @Cast("btScalar*") @ByRef DoublePointer penetrationDepth, @Const @ByRef btVector3 v3SphereCenter, @Cast("btScalar") double fRadius, @Cast("btScalar") double maxContactDistance);
	public native @Cast("bool") boolean getSphereDistance(@Const btCollisionObjectWrapper boxObjWrap, @ByRef btVector3 v3PointOnBox, @ByRef btVector3 normal, @Cast("btScalar*") @ByRef DoubleBuffer penetrationDepth, @Const @ByRef btVector3 v3SphereCenter, @Cast("btScalar") double fRadius, @Cast("btScalar") double maxContactDistance);
	public native @Cast("bool") boolean getSphereDistance(@Const btCollisionObjectWrapper boxObjWrap, @ByRef btVector3 v3PointOnBox, @ByRef btVector3 normal, @Cast("btScalar*") @ByRef double[] penetrationDepth, @Const @ByRef btVector3 v3SphereCenter, @Cast("btScalar") double fRadius, @Cast("btScalar") double maxContactDistance);

	public native @Cast("btScalar") double getSpherePenetration(@Const @ByRef btVector3 boxHalfExtent, @Const @ByRef btVector3 sphereRelPos, @ByRef btVector3 closestPoint, @ByRef btVector3 normal);

	public static class CreateFunc extends btCollisionAlgorithmCreateFunc {
	    static { Loader.load(); }
	    /** Default native constructor. */
	    public CreateFunc() { super((Pointer)null); allocate(); }
	    /** Native array allocator. Access with {@link Pointer#position(long)}. */
	    public CreateFunc(long size) { super((Pointer)null); allocateArray(size); }
	    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
	    public CreateFunc(Pointer p) { super(p); }
	    private native void allocate();
	    private native void allocateArray(long size);
	    @Override public CreateFunc position(long position) {
	        return (CreateFunc)super.position(position);
	    }
	    @Override public CreateFunc getPointer(long i) {
	        return new CreateFunc((Pointer)this).offsetAddress(i);
	    }
	
		public native btCollisionAlgorithm CreateCollisionAlgorithm(@ByRef btCollisionAlgorithmConstructionInfo ci, @Const btCollisionObjectWrapper body0Wrap, @Const btCollisionObjectWrapper body1Wrap);
	}
}
